/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.repository;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.CommonizerTargetKt;
import org.jetbrains.kotlin.commonizer.NativeLibraryLoader;
import org.jetbrains.kotlin.commonizer.konan.NativeLibrary;
import org.jetbrains.kotlin.commonizer.repository.Repository;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R3\u0010\b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00030\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/commonizer/repository/FilesRepository;", "Lorg/jetbrains/kotlin/commonizer/repository/Repository;", "libraryFiles", "", "Ljava/io/File;", "libraryLoader", "Lorg/jetbrains/kotlin/commonizer/NativeLibraryLoader;", "(Ljava/util/Set;Lorg/jetbrains/kotlin/commonizer/NativeLibraryLoader;)V", "librariesByKonanTargets", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "Lorg/jetbrains/kotlin/commonizer/konan/NativeLibrary;", "getLibrariesByKonanTargets", "()Ljava/util/Map;", "librariesByKonanTargets$delegate", "Lkotlin/Lazy;", "getLibraries", "target", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "konanTargetOrThrow", "value", "", "kotlin-klib-commonizer"})
public final class FilesRepository
implements Repository {
    @NotNull
    private final Set<File> libraryFiles;
    @NotNull
    private final NativeLibraryLoader libraryLoader;
    @NotNull
    private final Lazy librariesByKonanTargets$delegate;

    public FilesRepository(@NotNull Set<? extends File> libraryFiles, @NotNull NativeLibraryLoader libraryLoader) {
        Intrinsics.checkNotNullParameter(libraryFiles, (String)"libraryFiles");
        Intrinsics.checkNotNullParameter((Object)libraryLoader, (String)"libraryLoader");
        this.libraryFiles = libraryFiles;
        this.libraryLoader = libraryLoader;
        this.librariesByKonanTargets$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<Set<? extends KonanTarget>, ? extends Set<? extends NativeLibrary>>>(this){
            final /* synthetic */ FilesRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<Set<KonanTarget>, Set<NativeLibrary>> invoke() {
                void $this$mapValuesTo$iv$iv;
                Object object;
                void $this$groupByTo$iv$iv;
                void $this$groupBy$iv;
                Object object2;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Iterable iterable = FilesRepository.access$getLibraryFiles$p(this.this$0);
                Object object3 = FilesRepository.access$getLibraryLoader$p(this.this$0);
                boolean $i$f$map = false;
                void var4_6 = $this$map$iv;
                Object destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    File file2 = (File)item$iv$iv;
                    object2 = destination$iv$iv;
                    boolean bl = false;
                    object2.add(object3.invoke((File)p0));
                }
                $this$map$iv = (List)destination$iv$iv;
                object3 = this.this$0;
                boolean $i$f$groupBy22 = false;
                $this$mapTo$iv$iv = $this$groupBy$iv;
                destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$groupByTo = false;
                for (T element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object4;
                    NativeLibrary library = (NativeLibrary)element$iv$iv;
                    boolean bl = false;
                    Object object5 = library.getManifestData().getCommonizerTarget();
                    if (object5 == null || (object5 = CommonizerTargetKt.getKonanTargets((CommonizerTarget)object5)) == null) {
                        void $this$mapTo$iv$iv2;
                        Iterable $this$map$iv2 = library.getManifestData().getNativeTargets();
                        boolean $i$f$map2 = false;
                        object = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv2) {
                            void p0;
                            String string2 = (String)item$iv$iv;
                            Collection collection = destination$iv$iv2;
                            boolean bl2 = false;
                            collection.add(FilesRepository.access$konanTargetOrThrow((FilesRepository)object3, (String)p0));
                        }
                        object5 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                    }
                    Object key$iv$iv = object5;
                    Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl3 = false;
                        List answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object4 = answer$iv$iv$iv;
                    } else {
                        object4 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object4;
                    list$iv$iv.add(element$iv$iv);
                }
                Object $this$mapValues$iv = destination$iv$iv;
                boolean $i$f$mapValues = false;
                Object $i$f$groupBy22 = $this$mapValues$iv;
                Map destination$iv$iv3 = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    Map.Entry bl = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv3;
                    boolean bl4 = false;
                    object = (Map.Entry)element$iv$iv$iv;
                    K k = it$iv$iv.getKey();
                    object2 = map2;
                    boolean bl5 = false;
                    List list = (List)object.getValue();
                    Set set2 = CollectionsKt.toSet((Iterable)list);
                    object2.put(k, set2);
                }
                return destination$iv$iv3;
            }
        }));
    }

    private final Map<Set<KonanTarget>, Set<NativeLibrary>> getLibrariesByKonanTargets() {
        Lazy lazy = this.librariesByKonanTargets$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    @NotNull
    public Set<NativeLibrary> getLibraries(@NotNull CommonizerTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Set set2 = this.getLibrariesByKonanTargets().get(CommonizerTargetKt.getKonanTargets(target));
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    private final KonanTarget konanTargetOrThrow(String value) {
        KonanTarget konanTarget = (KonanTarget)KonanTarget.Companion.getPredefinedTargets().get(value);
        if (konanTarget == null) {
            throw new IllegalStateException(("Unexpected KonanTarget " + value).toString());
        }
        return konanTarget;
    }

    public static final /* synthetic */ Set access$getLibraryFiles$p(FilesRepository $this) {
        return $this.libraryFiles;
    }

    public static final /* synthetic */ NativeLibraryLoader access$getLibraryLoader$p(FilesRepository $this) {
        return $this.libraryLoader;
    }

    public static final /* synthetic */ KonanTarget access$konanTargetOrThrow(FilesRepository $this, String value) {
        return $this.konanTargetOrThrow(value);
    }
}

