/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.cir.CirClassOrTypeAliasType;
import org.jetbrains.kotlin.commonizer.cir.CirFlexibleType;
import org.jetbrains.kotlin.commonizer.cir.CirType;
import org.jetbrains.kotlin.commonizer.cir.CirTypeParameterType;
import org.jetbrains.kotlin.commonizer.core.AssociativeCommonizer;
import org.jetbrains.kotlin.commonizer.core.ClassOrTypeAliasTypeCommonizer;
import org.jetbrains.kotlin.commonizer.core.FlexibleTypeAssociativeCommonizer;
import org.jetbrains.kotlin.commonizer.core.TypeParameterTypeCommonizer;
import org.jetbrains.kotlin.commonizer.mergedtree.CirKnownClassifiers;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer;", "Lorg/jetbrains/kotlin/commonizer/core/AssociativeCommonizer;", "Lorg/jetbrains/kotlin/commonizer/cir/CirType;", "classifiers", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;", "options", "Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer$Options;", "(Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer$Options;)V", "commonize", "first", "second", "Options", "kotlin-klib-commonizer"})
public final class TypeCommonizer
implements AssociativeCommonizer<CirType> {
    @NotNull
    private final CirKnownClassifiers classifiers;
    @NotNull
    private final Options options;

    public TypeCommonizer(@NotNull CirKnownClassifiers classifiers2, @NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)classifiers2, (String)"classifiers");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.classifiers = classifiers2;
        this.options = options;
    }

    public /* synthetic */ TypeCommonizer(CirKnownClassifiers cirKnownClassifiers, Options options, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            options = Options.Companion.getDefault();
        }
        this(cirKnownClassifiers, options);
    }

    @Override
    @Nullable
    public CirType commonize(@NotNull CirType first, @NotNull CirType second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (first instanceof CirClassOrTypeAliasType && second instanceof CirClassOrTypeAliasType) {
            return new ClassOrTypeAliasTypeCommonizer(this.classifiers, this.options).commonize((CirClassOrTypeAliasType)first, (CirClassOrTypeAliasType)second);
        }
        if (first instanceof CirTypeParameterType && second instanceof CirTypeParameterType) {
            return TypeParameterTypeCommonizer.INSTANCE.commonize((CirTypeParameterType)first, (CirTypeParameterType)second);
        }
        if (first instanceof CirFlexibleType && second instanceof CirFlexibleType) {
            return new FlexibleTypeAssociativeCommonizer(this.classifiers, this.options).commonize((CirFlexibleType)first, (CirFlexibleType)second);
        }
        return null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u0010\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0013\u001a\u00020\u0003J\u0010\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0013\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer$Options;", "", "enableOptimisticNumberTypeCommonization", "", "enableCovariantNullabilityCommonization", "(ZZ)V", "getEnableCovariantNullabilityCommonization", "()Z", "getEnableOptimisticNumberTypeCommonization", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "withCovariantNullabilityCommonizationEnabled", "enabled", "withOptimisticNumberTypeCommonizationEnabled", "Companion", "kotlin-klib-commonizer"})
    public static final class Options {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean enableOptimisticNumberTypeCommonization;
        private final boolean enableCovariantNullabilityCommonization;
        @NotNull
        private static final Options default = new Options(false, false, 3, null);

        public Options(boolean enableOptimisticNumberTypeCommonization, boolean enableCovariantNullabilityCommonization) {
            this.enableOptimisticNumberTypeCommonization = enableOptimisticNumberTypeCommonization;
            this.enableCovariantNullabilityCommonization = enableCovariantNullabilityCommonization;
        }

        public /* synthetic */ Options(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public final boolean getEnableOptimisticNumberTypeCommonization() {
            return this.enableOptimisticNumberTypeCommonization;
        }

        public final boolean getEnableCovariantNullabilityCommonization() {
            return this.enableCovariantNullabilityCommonization;
        }

        @NotNull
        public final Options withOptimisticNumberTypeCommonizationEnabled(boolean enabled) {
            return this.enableOptimisticNumberTypeCommonization == enabled ? this : Options.copy$default(this, enabled, false, 2, null);
        }

        public static /* synthetic */ Options withOptimisticNumberTypeCommonizationEnabled$default(Options options, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return options.withOptimisticNumberTypeCommonizationEnabled(bl);
        }

        @NotNull
        public final Options withCovariantNullabilityCommonizationEnabled(boolean enabled) {
            return this.enableCovariantNullabilityCommonization == enabled ? this : Options.copy$default(this, false, enabled, 1, null);
        }

        public static /* synthetic */ Options withCovariantNullabilityCommonizationEnabled$default(Options options, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return options.withCovariantNullabilityCommonizationEnabled(bl);
        }

        public final boolean component1() {
            return this.enableOptimisticNumberTypeCommonization;
        }

        public final boolean component2() {
            return this.enableCovariantNullabilityCommonization;
        }

        @NotNull
        public final Options copy(boolean enableOptimisticNumberTypeCommonization, boolean enableCovariantNullabilityCommonization) {
            return new Options(enableOptimisticNumberTypeCommonization, enableCovariantNullabilityCommonization);
        }

        public static /* synthetic */ Options copy$default(Options options, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = options.enableOptimisticNumberTypeCommonization;
            }
            if ((n & 2) != 0) {
                bl2 = options.enableCovariantNullabilityCommonization;
            }
            return options.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Options(enableOptimisticNumberTypeCommonization=" + this.enableOptimisticNumberTypeCommonization + ", enableCovariantNullabilityCommonization=" + this.enableCovariantNullabilityCommonization + ')';
        }

        public int hashCode() {
            int n;
            int result;
            int n2 = this.enableOptimisticNumberTypeCommonization ? 1 : 0;
            if (n2 != 0) {
                n2 = result = 1;
            }
            if ((n = this.enableCovariantNullabilityCommonization) != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Options)) {
                return false;
            }
            Options options = (Options)other;
            if (this.enableOptimisticNumberTypeCommonization != options.enableOptimisticNumberTypeCommonization) {
                return false;
            }
            return this.enableCovariantNullabilityCommonization == options.enableCovariantNullabilityCommonization;
        }

        public Options() {
            this(false, false, 3, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer$Options$Companion;", "", "()V", "default", "Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer$Options;", "getDefault", "()Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer$Options;", "kotlin-klib-commonizer"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Options getDefault() {
                return default;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

