/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.cir.CirClassType;
import org.jetbrains.kotlin.commonizer.cir.CirEntityId;
import org.jetbrains.kotlin.commonizer.core.AssociativeCommonizer;
import org.jetbrains.kotlin.commonizer.core.OptimisticNumbersTypeCommonizerKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/OptimisticNumbersTypeCommonizer;", "Lorg/jetbrains/kotlin/commonizer/core/AssociativeCommonizer;", "Lorg/jetbrains/kotlin/commonizer/cir/CirClassType;", "()V", "commonize", "first", "second", "isOptimisticallySubstitutable", "", "classId", "Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "kotlin-klib-commonizer"})
public final class OptimisticNumbersTypeCommonizer
implements AssociativeCommonizer<CirClassType> {
    @NotNull
    public static final OptimisticNumbersTypeCommonizer INSTANCE = new OptimisticNumbersTypeCommonizer();

    private OptimisticNumbersTypeCommonizer() {
    }

    @Override
    @Nullable
    public CirClassType commonize(@NotNull CirClassType first, @NotNull CirClassType second) {
        CirClassType cirClassType;
        CirClassType cirClassType2;
        CirClassType cirClassType3;
        CirClassType cirClassType4;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        CirClassType cirClassType5 = OptimisticNumbersTypeCommonizerKt.access$getSignedIntegers$p().choose(first, second);
        CirClassType cirClassType6 = cirClassType5 == null ? ((cirClassType4 = OptimisticNumbersTypeCommonizerKt.access$getUnsignedIntegers$p().choose(first, second)) == null ? ((cirClassType3 = OptimisticNumbersTypeCommonizerKt.access$getFloatingPoints$p().choose(first, second)) == null ? ((cirClassType2 = OptimisticNumbersTypeCommonizerKt.access$getSignedVarIntegers$p().choose(first, second)) == null ? ((cirClassType = OptimisticNumbersTypeCommonizerKt.access$getUnsignedVarIntegers$p().choose(first, second)) == null ? OptimisticNumbersTypeCommonizerKt.access$getFloatingPointVars$p().choose(first, second) : cirClassType) : cirClassType2) : cirClassType3) : cirClassType4) : cirClassType5;
        return cirClassType6;
    }

    public final boolean isOptimisticallySubstitutable(@NotNull CirEntityId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        String firstPackageSegment = (String)ArraysKt.firstOrNull((Object[])classId.getPackageName().getSegments());
        if (!Intrinsics.areEqual((Object)firstPackageSegment, (Object)"kotlinx") && !Intrinsics.areEqual((Object)firstPackageSegment, (Object)"kotlin")) {
            return false;
        }
        return OptimisticNumbersTypeCommonizerKt.access$getSignedIntegers$p().contains(classId) || OptimisticNumbersTypeCommonizerKt.access$getUnsignedIntegers$p().contains(classId) || OptimisticNumbersTypeCommonizerKt.access$getFloatingPoints$p().contains(classId) || OptimisticNumbersTypeCommonizerKt.access$getSignedVarIntegers$p().contains(classId) || OptimisticNumbersTypeCommonizerKt.access$getUnsignedVarIntegers$p().contains(classId) || OptimisticNumbersTypeCommonizerKt.access$getFloatingPointVars$p().contains(classId);
    }
}

