/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.cli;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.CommonizerLogLevel;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\bH\u0016J)\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0012\"\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/commonizer/cli/CliLoggerAdapter;", "Lorg/jetbrains/kotlin/util/Logger;", "level", "Lorg/jetbrains/kotlin/commonizer/CommonizerLogLevel;", "indentSize", "", "(Lorg/jetbrains/kotlin/commonizer/CommonizerLogLevel;I)V", "indent", "", "error", "", "message", "fatal", "log", "", "printlnIndented", "text", "levels", "", "(Ljava/lang/String;[Lorg/jetbrains/kotlin/commonizer/CommonizerLogLevel;)V", "warning", "kotlin-klib-commonizer"})
public final class CliLoggerAdapter
implements Logger {
    @NotNull
    private final CommonizerLogLevel level;
    @NotNull
    private final String indent;

    public CliLoggerAdapter(@NotNull CommonizerLogLevel level, int indentSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.level = level;
        this.indent = StringsKt.repeat((CharSequence)" ", (int)indentSize);
    }

    public /* synthetic */ CliLoggerAdapter(CommonizerLogLevel commonizerLogLevel, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(commonizerLogLevel, n);
    }

    public void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CommonizerLogLevel[] commonizerLogLevelArray = new CommonizerLogLevel[]{CommonizerLogLevel.Info};
        this.printlnIndented(message, commonizerLogLevelArray);
    }

    public void warning(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CommonizerLogLevel[] commonizerLogLevelArray = CommonizerLogLevel.values();
        this.printlnIndented(Intrinsics.stringPlus((String)"Warning: ", (Object)message), Arrays.copyOf(commonizerLogLevelArray, commonizerLogLevelArray.length));
    }

    @NotNull
    public Void error(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.fatal(message);
        throw null;
    }

    @NotNull
    public Void fatal(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CommonizerLogLevel[] commonizerLogLevelArray = CommonizerLogLevel.values();
        this.printlnIndented("Error: " + message + '\n', Arrays.copyOf(commonizerLogLevelArray, commonizerLogLevelArray.length));
        System.exit(1);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final void printlnIndented(String text, CommonizerLogLevel ... levels) {
        if (ArraysKt.contains((Object[])levels, (Object)((Object)this.level))) {
            Object object = this.indent;
            if (object.length() == 0) {
                System.out.println((Object)text);
            } else {
                object = new char[1];
                object[0] = 10;
                Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)text, (char[])object, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    System.out.println((Object)Intrinsics.stringPlus((String)this.indent, (Object)it));
                }
            }
        }
    }
}

