/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.InputTargetsSelectorKt;
import org.jetbrains.kotlin.commonizer.SharedCommonizerTarget;
import org.jetbrains.kotlin.commonizer.TargetDependent;
import org.jetbrains.kotlin.commonizer.TargetDependentKt;
import org.jetbrains.kotlin.commonizer.mergedtree.CirRootNode;
import org.jetbrains.kotlin.commonizer.tree.AssembelCirTreeKt;
import org.jetbrains.kotlin.commonizer.tree.CirTreeRoot;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0003,-.B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010#\u001a\u0004\u0018\u00010\u00132\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0014\u0010%\u001a\u00020&2\n\u0010'\u001a\u00060\u0006j\u0002`\u0007H\u0002J\u0006\u0010(\u001a\u00020&J\u0012\u0010)\u001a\u00020&2\n\u0010'\u001a\u00060\u0006j\u0002`\u0007J\u0014\u0010*\u001a\u00020&2\n\u0010'\u001a\u00060\u0006j\u0002`\u0007H\u0002J\u0014\u0010+\u001a\u00020&2\n\u0010$\u001a\u00060\u0006j\u0002`\u0007H\u0002R$\u0010\u0010\u001a\u0018\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u0018\u0012\b\u0012\u00060\u0015j\u0002`\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u001b\u0010\u001c\u001a\f\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R+\u0010\u001e\u001a\u001c\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u00050\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\"\u001a\u001c\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u00050\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/commonizer/CommonizerQueue;", "", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "outputTargets", "", "Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "Lorg/jetbrains/kotlin/commonizer/OutputCommonizerTarget;", "deserializers", "Lorg/jetbrains/kotlin/commonizer/TargetDependent;", "Lorg/jetbrains/kotlin/commonizer/CommonizerQueue$Deserializer;", "commonizer", "Lorg/jetbrains/kotlin/commonizer/CommonizerQueue$Commonizer;", "serializer", "Lorg/jetbrains/kotlin/commonizer/CommonizerQueue$Serializer;", "(Lorg/jetbrains/kotlin/storage/StorageManager;Ljava/util/Set;Lorg/jetbrains/kotlin/commonizer/TargetDependent;Lorg/jetbrains/kotlin/commonizer/CommonizerQueue$Commonizer;Lorg/jetbrains/kotlin/commonizer/CommonizerQueue$Serializer;)V", "commonizedTargets", "", "Lorg/jetbrains/kotlin/storage/NullableLazyValue;", "Lorg/jetbrains/kotlin/commonizer/tree/CirTreeRoot;", "deserializedTargets", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "Lorg/jetbrains/kotlin/commonizer/InputCommonizerTarget;", "pendingOutputTargets", "getPendingOutputTargets", "()Ljava/util/Set;", "retainedCommonizedTargets", "getRetainedCommonizedTargets", "retainedDeserializedTargets", "getRetainedDeserializedTargets", "retainedTargetDependencies", "", "getRetainedTargetDependencies", "()Ljava/util/Map;", "targetDependencies", "commonize", "target", "enqueue", "", "outputTarget", "invokeAll", "invokeTarget", "registerTargetDependencies", "removeTargetDependencies", "Commonizer", "Deserializer", "Serializer", "kotlin-klib-commonizer"})
public final class CommonizerQueue {
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final Set<SharedCommonizerTarget> outputTargets;
    @NotNull
    private final TargetDependent<Deserializer> deserializers;
    @NotNull
    private final Commonizer commonizer;
    @NotNull
    private final Serializer serializer;
    @NotNull
    private final Map<CommonizerTarget, NullableLazyValue<CirTreeRoot>> deserializedTargets;
    @NotNull
    private final Map<SharedCommonizerTarget, NullableLazyValue<CirTreeRoot>> commonizedTargets;
    @NotNull
    private final Map<SharedCommonizerTarget, Set<CommonizerTarget>> targetDependencies;

    /*
     * WARNING - void declaration
     */
    public CommonizerQueue(@NotNull StorageManager storageManager, @NotNull Set<SharedCommonizerTarget> outputTargets, @NotNull TargetDependent<Deserializer> deserializers, @NotNull Commonizer commonizer, @NotNull Serializer serializer) {
        void var21_25;
        void destination$iv;
        void $this$mapValuesTo$iv;
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter(outputTargets, (String)"outputTargets");
        Intrinsics.checkNotNullParameter(deserializers, (String)"deserializers");
        Intrinsics.checkNotNullParameter((Object)commonizer, (String)"commonizer");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        this.storageManager = storageManager;
        this.outputTargets = outputTargets;
        this.deserializers = deserializers;
        this.commonizer = commonizer;
        this.serializer = serializer;
        Map<CommonizerTarget, Deserializer> map2 = TargetDependentKt.toMap(this.deserializers);
        Map map3 = new LinkedHashMap();
        CommonizerQueue commonizerQueue = this;
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv = $this$mapValuesTo$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void $dstr$_u24__u24$deserializer;
            void it$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            void var14_19 = destination$iv;
            boolean bl = false;
            Object k = it$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv;
            Object k2 = k;
            var21_25 = var14_19;
            boolean bl2 = false;
            Deserializer deserializer = (Deserializer)$dstr$_u24__u24$deserializer.getValue();
            NullableLazyValue nullableLazyValue = this.storageManager.createNullableLazyValue((Function0)new Function0<CirTreeRoot>(deserializer){
                final /* synthetic */ Deserializer $deserializer;
                {
                    this.$deserializer = $deserializer;
                    super(0);
                }

                @Nullable
                public final CirTreeRoot invoke() {
                    return this.$deserializer.invoke();
                }
            });
            var21_25.put(k2, nullableLazyValue);
        }
        var21_25 = destination$iv;
        commonizerQueue.deserializedTargets = var21_25;
        this.commonizedTargets = new LinkedHashMap();
        this.targetDependencies = new LinkedHashMap();
        Iterable $this$forEach$iv = this.outputTargets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SharedCommonizerTarget p0 = (SharedCommonizerTarget)element$iv;
            boolean bl = false;
            this.enqueue(p0);
        }
    }

    @NotNull
    public final Set<CommonizerTarget> getRetainedDeserializedTargets() {
        return this.deserializedTargets.keySet();
    }

    @NotNull
    public final Set<SharedCommonizerTarget> getRetainedCommonizedTargets() {
        return this.commonizedTargets.keySet();
    }

    @NotNull
    public final Map<SharedCommonizerTarget, Set<CommonizerTarget>> getRetainedTargetDependencies() {
        return MapsKt.toMap(this.targetDependencies);
    }

    @NotNull
    public final Set<CommonizerTarget> getPendingOutputTargets() {
        return this.targetDependencies.keySet();
    }

    public final void invokeAll() {
        Iterable $this$forEach$iv = this.outputTargets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SharedCommonizerTarget outputTarget = (SharedCommonizerTarget)element$iv;
            boolean bl = false;
            this.invokeTarget(outputTarget);
        }
        boolean bl = this.deserializedTargets.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CommonizerQueue$invokeAll$52 = false;
            String $i$a$-assert-CommonizerQueue$invokeAll$52 = Intrinsics.stringPlus((String)"Expected 'deserializedTargets' to be empty. Found ", this.deserializedTargets.keySet());
            throw new AssertionError((Object)$i$a$-assert-CommonizerQueue$invokeAll$52);
        }
        bl = this.commonizedTargets.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CommonizerQueue$invokeAll$62 = false;
            String $i$a$-assert-CommonizerQueue$invokeAll$62 = Intrinsics.stringPlus((String)"Expected 'commonizedTargets' to be empty. Found ", this.commonizedTargets.keySet());
            throw new AssertionError((Object)$i$a$-assert-CommonizerQueue$invokeAll$62);
        }
        bl = this.targetDependencies.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = Intrinsics.stringPlus((String)"Expected 'targetDependencies' to be empty. Found ", this.targetDependencies);
            throw new AssertionError((Object)string2);
        }
    }

    public final void invokeTarget(@NotNull SharedCommonizerTarget outputTarget) {
        Intrinsics.checkNotNullParameter((Object)outputTarget, (String)"outputTarget");
        NullableLazyValue<CirTreeRoot> nullableLazyValue = this.commonizedTargets.get(outputTarget);
        if (nullableLazyValue != null) {
            CirTreeRoot cfr_ignored_0 = (CirTreeRoot)nullableLazyValue.invoke();
        }
    }

    private final void enqueue(SharedCommonizerTarget outputTarget) {
        this.registerTargetDependencies(outputTarget);
        Map<SharedCommonizerTarget, NullableLazyValue<CirTreeRoot>> map2 = this.commonizedTargets;
        NullableLazyValue nullableLazyValue = this.storageManager.createNullableLazyValue((Function0)new Function0<CirTreeRoot>(this, outputTarget){
            final /* synthetic */ CommonizerQueue this$0;
            final /* synthetic */ SharedCommonizerTarget $outputTarget;
            {
                this.this$0 = $receiver;
                this.$outputTarget = $outputTarget;
                super(0);
            }

            @Nullable
            public final CirTreeRoot invoke() {
                return CommonizerQueue.access$commonize(this.this$0, this.$outputTarget);
            }
        });
        map2.put(outputTarget, (NullableLazyValue<CirTreeRoot>)nullableLazyValue);
    }

    private final CirTreeRoot commonize(SharedCommonizerTarget target) {
        CirTreeRoot cirTreeRoot;
        CirRootNode cirRootNode;
        Set inputTargets = (Set)MapsKt.getValue(this.targetDependencies, (Object)target);
        TargetDependent<CirTreeRoot> inputDeclarations2 = TargetDependentKt.EagerTargetDependent(inputTargets, (Function1)new Function1<CommonizerTarget, CirTreeRoot>(this){
            final /* synthetic */ CommonizerQueue this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final CirTreeRoot invoke(@NotNull CommonizerTarget inputTarget) {
                NullableLazyValue nullableLazyValue;
                Intrinsics.checkNotNullParameter((Object)inputTarget, (String)"inputTarget");
                NullableLazyValue nullableLazyValue2 = (NullableLazyValue)CommonizerQueue.access$getDeserializedTargets$p(this.this$0).get(inputTarget);
                if (nullableLazyValue2 == null) {
                    Map map2 = CommonizerQueue.access$getCommonizedTargets$p(this.this$0);
                    NullableLazyValue nullableLazyValue3 = (NullableLazyValue)map2.get(inputTarget);
                    if (nullableLazyValue3 == null) {
                        throw new IllegalStateException(Intrinsics.stringPlus((String)"Missing inputTarget ", (Object)inputTarget));
                    }
                    nullableLazyValue = nullableLazyValue3;
                } else {
                    nullableLazyValue = nullableLazyValue2;
                }
                return (CirTreeRoot)nullableLazyValue.invoke();
            }
        });
        CirRootNode it = cirRootNode = this.commonizer.invoke(inputDeclarations2, target);
        boolean bl = false;
        this.removeTargetDependencies(target);
        CirRootNode cirRootNode2 = cirRootNode;
        if (cirRootNode2 == null) {
            cirTreeRoot = null;
        } else {
            CirRootNode cirRootNode3;
            CirRootNode commonizedDeclarations = cirRootNode3 = cirRootNode2;
            boolean bl2 = false;
            this.serializer.invoke(commonizedDeclarations, target);
            cirRootNode = cirRootNode3;
            cirTreeRoot = AssembelCirTreeKt.assembleCirTree(cirRootNode);
        }
        return cirTreeRoot;
    }

    private final void registerTargetDependencies(SharedCommonizerTarget outputTarget) {
        Map<SharedCommonizerTarget, Set<CommonizerTarget>> map2 = this.targetDependencies;
        Set<CommonizerTarget> set = InputTargetsSelectorKt.selectInputTargets(SetsKt.plus(this.outputTargets, (Iterable)this.deserializers.getTargets()), outputTarget);
        map2.put(outputTarget, set);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeTargetDependencies(SharedCommonizerTarget target) {
        void $this$filterTo$iv$iv;
        Object p0;
        void $this$forEach$iv;
        CommonizerTarget it;
        void $this$filterTo$iv$iv2;
        Set<CommonizerTarget> set = this.targetDependencies.remove(target);
        if (set == null) {
            return;
        }
        Set referencedDependencyTargets = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)this.targetDependencies.values()));
        Iterable $this$filter$iv = this.commonizedTargets.keySet();
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (SharedCommonizerTarget)element$iv$iv;
            boolean bl = false;
            if (!(!referencedDependencyTargets.contains(it) && !this.getPendingOutputTargets().contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Map<SharedCommonizerTarget, NullableLazyValue<CirTreeRoot>> $i$f$filter22 = this.commonizedTargets;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (SharedCommonizerTarget)element$iv;
            $i$f$filter22.remove(p0);
        }
        $this$filter$iv = this.deserializedTargets.keySet();
        boolean $i$f$filter = false;
        Iterable $i$f$forEach22 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CommonizerTarget)element$iv$iv;
            boolean bl = false;
            if (!(!referencedDependencyTargets.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Map<CommonizerTarget, NullableLazyValue<CirTreeRoot>> map2 = this.deserializedTargets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (CommonizerTarget)element$iv;
            map2.remove(p0);
        }
    }

    public static final /* synthetic */ CirTreeRoot access$commonize(CommonizerQueue $this, SharedCommonizerTarget target) {
        return $this.commonize(target);
    }

    public static final /* synthetic */ Map access$getDeserializedTargets$p(CommonizerQueue $this) {
        return $this.deserializedTargets;
    }

    public static final /* synthetic */ Map access$getCommonizedTargets$p(CommonizerQueue $this) {
        return $this.commonizedTargets;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u000b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00a6\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/commonizer/CommonizerQueue$Deserializer;", "", "invoke", "Lorg/jetbrains/kotlin/commonizer/tree/CirTreeRoot;", "kotlin-klib-commonizer"})
    public static interface Deserializer {
        @Nullable
        public CirTreeRoot invoke();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J#\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u00a6\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/commonizer/CommonizerQueue$Commonizer;", "", "invoke", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirRootNode;", "inputs", "Lorg/jetbrains/kotlin/commonizer/TargetDependent;", "Lorg/jetbrains/kotlin/commonizer/tree/CirTreeRoot;", "output", "Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "kotlin-klib-commonizer"})
    public static interface Commonizer {
        @Nullable
        public CirRootNode invoke(@NotNull TargetDependent<CirTreeRoot> var1, @NotNull SharedCommonizerTarget var2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001d\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u00a6\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/commonizer/CommonizerQueue$Serializer;", "", "invoke", "", "declarations", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirRootNode;", "outputTarget", "Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "Lorg/jetbrains/kotlin/commonizer/OutputCommonizerTarget;", "kotlin-klib-commonizer"})
    public static interface Serializer {
        public void invoke(@NotNull CirRootNode var1, @NotNull SharedCommonizerTarget var2);
    }
}

