/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.konan;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.ModulesProvider;
import org.jetbrains.kotlin.commonizer.konan.NativeLibrariesToCommonize;
import org.jetbrains.kotlin.commonizer.konan.NativeLibrary;
import org.jetbrains.kotlin.commonizer.konan.NativeSensitiveManifestData;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.SerializedMetadata;
import org.jetbrains.kotlin.library.metadata.KlibMetadataDeserializationUtilsKt;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/commonizer/konan/DefaultModulesProvider;", "Lorg/jetbrains/kotlin/commonizer/ModulesProvider;", "libraries", "", "Lorg/jetbrains/kotlin/commonizer/konan/NativeLibrary;", "(Ljava/util/Collection;)V", "libraryMap", "", "", "moduleInfoMap", "Lorg/jetbrains/kotlin/commonizer/konan/DefaultModulesProvider$NativeModuleInfo;", "loadModuleInfos", "Lorg/jetbrains/kotlin/commonizer/ModulesProvider$ModuleInfo;", "loadModuleMetadata", "Lorg/jetbrains/kotlin/library/SerializedMetadata;", "name", "Companion", "NativeModuleInfo", "kotlin-klib-commonizer"})
public final class DefaultModulesProvider
implements ModulesProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, NativeLibrary> libraryMap;
    @NotNull
    private final Map<String, NativeModuleInfo> moduleInfoMap;

    public DefaultModulesProvider(@NotNull Collection<NativeLibrary> libraries2) {
        Intrinsics.checkNotNullParameter(libraries2, (String)"libraries");
        boolean bl = false;
        Map libraryMap = new LinkedHashMap();
        boolean bl2 = false;
        Map moduleInfoMap = new LinkedHashMap();
        Iterable $this$forEach$iv = libraries2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl3;
            ModulesProvider.CInteropModuleAttributes cInteropModuleAttributes;
            Object object;
            NativeLibrary library = (NativeLibrary)element$iv;
            boolean bl4 = false;
            NativeSensitiveManifestData manifestData = library.getManifestData();
            String name = manifestData.getUniqueName();
            File location = new File(library.getLibrary().getLibraryFile().getPath());
            Set dependencies = CollectionsKt.toSet((Iterable)manifestData.getDependencies());
            if (manifestData.isInterop()) {
                object = manifestData.getPackageFqName();
                if (object == null) {
                    String string2 = Intrinsics.stringPlus((String)"Main package FQ name not specified for module ", (Object)name);
                    boolean bl5 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                String packageFqName = object;
                cInteropModuleAttributes = new ModulesProvider.CInteropModuleAttributes(packageFqName, (Collection<String>)manifestData.getExportForwardDeclarations());
            } else {
                cInteropModuleAttributes = null;
            }
            ModulesProvider.CInteropModuleAttributes cInteropAttributes = cInteropModuleAttributes;
            Object object2 = libraryMap.put(name, library);
            if (object2 != null) {
                object = object2;
                bl3 = false;
                boolean bl6 = false;
                Object it = object;
                boolean bl7 = false;
                String string3 = Intrinsics.stringPlus((String)"Duplicated libraries: ", (Object)name);
                boolean bl8 = false;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            object2 = moduleInfoMap;
            object = new NativeModuleInfo(name, location, dependencies, cInteropAttributes);
            bl3 = false;
            object2.put(name, object);
        }
        this.libraryMap = libraryMap;
        this.moduleInfoMap = moduleInfoMap;
    }

    @Override
    @NotNull
    public Collection<ModulesProvider.ModuleInfo> loadModuleInfos() {
        return this.moduleInfoMap.values();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SerializedMetadata loadModuleMetadata(@NotNull String name) {
        void $this$mapTo$iv$iv;
        KotlinLibrary kotlinLibrary;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this.libraryMap.get(name);
        KotlinLibrary kotlinLibrary2 = kotlinLibrary = object == null ? null : ((NativeLibrary)object).getLibrary();
        if (kotlinLibrary == null) {
            object = Intrinsics.stringPlus((String)"No such library: ", (Object)name);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        KotlinLibrary library = kotlinLibrary;
        byte[] moduleHeader = library.getModuleHeaderData();
        ProtocolStringList protocolStringList = KlibMetadataDeserializationUtilsKt.parseModuleHeader((byte[])moduleHeader).getPackageFragmentNameList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"parseModuleHeader(module\u2026).packageFragmentNameList");
        Set fragmentNames = CollectionsKt.toSet((Iterable)((Iterable)protocolStringList));
        Iterable $this$map$iv = fragmentNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void fragmentName;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)fragmentName, (String)"fragmentName");
            Set partNames = library.packageMetadataParts((String)fragmentName);
            Iterable $this$map$iv2 = partNames;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void partName;
                String string3 = (String)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                byte[] byArray = library.packageMetadata((String)fragmentName, (String)partName);
                collection2.add(byArray);
            }
            List list = (List)destination$iv$iv2;
            collection.add(list);
        }
        List fragments2 = (List)destination$iv$iv;
        return new SerializedMetadata(moduleHeader, fragments2, CollectionsKt.toList((Iterable)fragmentNames));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/commonizer/konan/DefaultModulesProvider$NativeModuleInfo;", "Lorg/jetbrains/kotlin/commonizer/ModulesProvider$ModuleInfo;", "name", "", "originalLocation", "Ljava/io/File;", "dependencies", "", "cInteropAttributes", "Lorg/jetbrains/kotlin/commonizer/ModulesProvider$CInteropModuleAttributes;", "(Ljava/lang/String;Ljava/io/File;Ljava/util/Set;Lorg/jetbrains/kotlin/commonizer/ModulesProvider$CInteropModuleAttributes;)V", "getDependencies", "()Ljava/util/Set;", "kotlin-klib-commonizer"})
    public static final class NativeModuleInfo
    extends ModulesProvider.ModuleInfo {
        @NotNull
        private final Set<String> dependencies;

        public NativeModuleInfo(@NotNull String name, @NotNull File originalLocation, @NotNull Set<String> dependencies, @Nullable ModulesProvider.CInteropModuleAttributes cInteropAttributes) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)originalLocation, (String)"originalLocation");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            super(name, originalLocation, cInteropAttributes);
            this.dependencies = dependencies;
        }

        @NotNull
        public final Set<String> getDependencies() {
            return this.dependencies;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/commonizer/konan/DefaultModulesProvider$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/commonizer/ModulesProvider;", "libraries", "", "Lorg/jetbrains/kotlin/commonizer/konan/NativeLibrary;", "librariesToCommonize", "Lorg/jetbrains/kotlin/commonizer/konan/NativeLibrariesToCommonize;", "kotlin-klib-commonizer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModulesProvider create(@NotNull NativeLibrariesToCommonize librariesToCommonize) {
            Intrinsics.checkNotNullParameter((Object)librariesToCommonize, (String)"librariesToCommonize");
            return new DefaultModulesProvider((Collection<NativeLibrary>)librariesToCommonize.getLibraries());
        }

        @NotNull
        public final ModulesProvider create(@NotNull Iterable<NativeLibrary> libraries2) {
            Intrinsics.checkNotNullParameter(libraries2, (String)"libraries");
            return new DefaultModulesProvider(CollectionsKt.toList(libraries2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

