/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.cir.CirClassType;
import org.jetbrains.kotlin.commonizer.cir.CirFlexibleType;
import org.jetbrains.kotlin.commonizer.cir.CirType;
import org.jetbrains.kotlin.commonizer.cir.CirTypeAliasType;
import org.jetbrains.kotlin.commonizer.cir.CirTypeParameterType;
import org.jetbrains.kotlin.commonizer.core.AbstractStandardCommonizer;
import org.jetbrains.kotlin.commonizer.core.ClassTypeCommonizer;
import org.jetbrains.kotlin.commonizer.core.CommonizerKt;
import org.jetbrains.kotlin.commonizer.core.FlexibleTypeCommonizer;
import org.jetbrains.kotlin.commonizer.core.TypeAliasTypeCommonizer;
import org.jetbrains.kotlin.commonizer.core.TypeParameterTypeCommonizer;
import org.jetbrains.kotlin.commonizer.mergedtree.CirKnownClassifiers;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0002H\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer;", "Lorg/jetbrains/kotlin/commonizer/core/AbstractStandardCommonizer;", "Lorg/jetbrains/kotlin/commonizer/cir/CirType;", "classifiers", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;", "(Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;)V", "typeCommonizer", "underlyingTypeCommonizer", "commonizationResult", "doCommonizeWith", "", "next", "doCommonizeWithClassType", "Lorg/jetbrains/kotlin/commonizer/cir/CirClassType;", "doCommonizeWithTypeAliasType", "Lorg/jetbrains/kotlin/commonizer/cir/CirTypeAliasType;", "initialize", "", "first", "kotlin-klib-commonizer"})
public final class TypeCommonizer
extends AbstractStandardCommonizer<CirType, CirType> {
    @NotNull
    private final CirKnownClassifiers classifiers;
    @Nullable
    private AbstractStandardCommonizer<?, CirType> typeCommonizer;
    @Nullable
    private TypeCommonizer underlyingTypeCommonizer;

    public TypeCommonizer(@NotNull CirKnownClassifiers classifiers) {
        Intrinsics.checkNotNullParameter((Object)classifiers, (String)"classifiers");
        this.classifiers = classifiers;
    }

    @Override
    @NotNull
    protected CirType commonizationResult() {
        CirType cirType;
        CirType cirType2;
        TypeCommonizer typeCommonizer = this.typeCommonizer;
        CirType cirType3 = cirType2 = typeCommonizer == null ? null : typeCommonizer.getResultOrNull();
        if (cirType2 == null) {
            typeCommonizer = this.underlyingTypeCommonizer;
            if (typeCommonizer == null) {
                CirType cirType4;
                AbstractStandardCommonizer<?, CirType> abstractStandardCommonizer = this.typeCommonizer;
                CirType cirType5 = cirType4 = abstractStandardCommonizer == null ? null : abstractStandardCommonizer.getResult();
                if (cirType4 == null) {
                    CommonizerKt.failInErrorState(this);
                    throw null;
                }
                cirType = cirType4;
            } else {
                cirType = (CirType)typeCommonizer.getResult();
            }
        } else {
            cirType = cirType2;
        }
        return cirType;
    }

    @Override
    protected void initialize(@NotNull CirType first) {
        AbstractStandardCommonizer abstractStandardCommonizer;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        CirType cirType = first;
        if (cirType instanceof CirClassType) {
            abstractStandardCommonizer = new ClassTypeCommonizer(this.classifiers);
        } else if (cirType instanceof CirTypeAliasType) {
            abstractStandardCommonizer = new TypeAliasTypeCommonizer(this.classifiers);
        } else if (cirType instanceof CirTypeParameterType) {
            abstractStandardCommonizer = new TypeParameterTypeCommonizer();
        } else if (cirType instanceof CirFlexibleType) {
            abstractStandardCommonizer = new FlexibleTypeCommonizer(this.classifiers);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.typeCommonizer = abstractStandardCommonizer;
        if (first instanceof CirTypeAliasType) {
            this.underlyingTypeCommonizer = new TypeCommonizer(this.classifiers);
        }
    }

    @Override
    protected boolean doCommonizeWith(@NotNull CirType next) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        CirType cirType = next;
        if (cirType instanceof CirClassType) {
            bl = this.doCommonizeWithClassType((CirClassType)next);
        } else if (cirType instanceof CirTypeAliasType) {
            bl = this.doCommonizeWithTypeAliasType((CirTypeAliasType)next);
        } else if (cirType instanceof CirTypeParameterType) {
            TypeParameterTypeCommonizer typeParameterTypeCommonizer;
            AbstractStandardCommonizer<?, CirType> abstractStandardCommonizer = this.typeCommonizer;
            TypeParameterTypeCommonizer typeParameterTypeCommonizer2 = typeParameterTypeCommonizer = abstractStandardCommonizer instanceof TypeParameterTypeCommonizer ? (TypeParameterTypeCommonizer)abstractStandardCommonizer : null;
            bl = typeParameterTypeCommonizer == null ? false : typeParameterTypeCommonizer.commonizeWith(next);
        } else if (cirType instanceof CirFlexibleType) {
            FlexibleTypeCommonizer flexibleTypeCommonizer;
            AbstractStandardCommonizer<?, CirType> abstractStandardCommonizer = this.typeCommonizer;
            FlexibleTypeCommonizer flexibleTypeCommonizer2 = flexibleTypeCommonizer = abstractStandardCommonizer instanceof FlexibleTypeCommonizer ? (FlexibleTypeCommonizer)abstractStandardCommonizer : null;
            bl = flexibleTypeCommonizer == null ? false : flexibleTypeCommonizer.commonizeWith(next);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private final boolean doCommonizeWithClassType(CirClassType next) {
        TypeCommonizer typeCommonizer;
        ClassTypeCommonizer classTypeCommonizer;
        AbstractStandardCommonizer<?, CirType> abstractStandardCommonizer = this.typeCommonizer;
        if ((abstractStandardCommonizer instanceof ClassTypeCommonizer ? (ClassTypeCommonizer)abstractStandardCommonizer : null) == null) {
            this.typeCommonizer = null;
        }
        ClassTypeCommonizer classTypeCommonizer2 = classTypeCommonizer = (typeCommonizer = this.typeCommonizer) instanceof ClassTypeCommonizer ? (ClassTypeCommonizer)((Object)typeCommonizer) : null;
        boolean firstAnswer = classTypeCommonizer == null ? false : classTypeCommonizer.commonizeWith(next);
        typeCommonizer = this.underlyingTypeCommonizer;
        boolean secondAnswer = typeCommonizer == null ? false : typeCommonizer.commonizeWith(next);
        return firstAnswer || secondAnswer;
    }

    private final boolean doCommonizeWithTypeAliasType(CirTypeAliasType next) {
        TypeAliasTypeCommonizer typeAliasTypeCommonizer;
        AbstractStandardCommonizer abstractStandardCommonizer;
        if (this.typeCommonizer != null && this.underlyingTypeCommonizer == null) {
            this.underlyingTypeCommonizer = new TypeCommonizer(this.classifiers);
            TypeCommonizer typeCommonizer = this.underlyingTypeCommonizer;
            if (typeCommonizer != null) {
                abstractStandardCommonizer = this.typeCommonizer;
                TypeAliasTypeCommonizer typeAliasTypeCommonizer2 = typeAliasTypeCommonizer = abstractStandardCommonizer == null ? null : (CirType)abstractStandardCommonizer.getResultOrNull();
                if (typeAliasTypeCommonizer == null) {
                    return false;
                }
                typeCommonizer.commonizeWith(typeAliasTypeCommonizer);
            }
            this.typeCommonizer = null;
        }
        TypeAliasTypeCommonizer typeAliasTypeCommonizer3 = typeAliasTypeCommonizer = (abstractStandardCommonizer = this.typeCommonizer) instanceof TypeAliasTypeCommonizer ? (TypeAliasTypeCommonizer)abstractStandardCommonizer : null;
        boolean firstAnswer = typeAliasTypeCommonizer == null ? false : typeAliasTypeCommonizer.commonizeWith(next);
        abstractStandardCommonizer = this.underlyingTypeCommonizer;
        boolean secondAnswer = abstractStandardCommonizer == null ? false : abstractStandardCommonizer.commonizeWith(next.getUnderlyingType());
        return firstAnswer || secondAnswer;
    }
}

