/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.cir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.cir.CirClassOrTypeAliasType;
import org.jetbrains.kotlin.commonizer.cir.CirClassType;
import org.jetbrains.kotlin.commonizer.cir.CirDeclaration;
import org.jetbrains.kotlin.commonizer.cir.CirRegularTypeProjection;
import org.jetbrains.kotlin.commonizer.cir.CirSimpleType;
import org.jetbrains.kotlin.commonizer.cir.CirType;
import org.jetbrains.kotlin.commonizer.cir.CirTypeAliasType;
import org.jetbrains.kotlin.commonizer.cir.CirTypeParameterType;
import org.jetbrains.kotlin.commonizer.cir.CirTypeProjection;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\u001a\u0011\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0080\u0010\u001a\u0019\u0010\u0004\u001a\u0002H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u0006*\u0002H\u0005\u00a2\u0006\u0002\u0010\u0007\u001a$\u0010\b\u001a\u0002H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u0006*\u0002H\u00052\u0006\u0010\t\u001a\u00020\nH\u0086\b\u00a2\u0006\u0002\u0010\u000b\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0003\u001a\r\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0080\b\u00a8\u0006\u0010"}, d2={"computeExpandedType", "Lorg/jetbrains/kotlin/commonizer/cir/CirClassType;", "underlyingType", "Lorg/jetbrains/kotlin/commonizer/cir/CirClassOrTypeAliasType;", "makeNullable", "T", "Lorg/jetbrains/kotlin/commonizer/cir/CirSimpleType;", "(Lorg/jetbrains/kotlin/commonizer/cir/CirSimpleType;)Lorg/jetbrains/kotlin/commonizer/cir/CirSimpleType;", "makeNullableIfNecessary", "necessary", "", "(Lorg/jetbrains/kotlin/commonizer/cir/CirSimpleType;Z)Lorg/jetbrains/kotlin/commonizer/cir/CirSimpleType;", "unabbreviate", "unsupported", "", "Lorg/jetbrains/kotlin/commonizer/cir/CirDeclaration;", "kotlin-klib-commonizer"})
public final class UtilsKt {
    @NotNull
    public static final <T extends CirSimpleType> T makeNullable(@NotNull T $this$makeNullable) {
        CirSimpleType cirSimpleType;
        Intrinsics.checkNotNullParameter($this$makeNullable, (String)"<this>");
        if ($this$makeNullable.isMarkedNullable()) {
            return $this$makeNullable;
        }
        T t = $this$makeNullable;
        if (t instanceof CirClassType) {
            cirSimpleType = CirClassType.Companion.createInterned(((CirClassType)$this$makeNullable).getClassifierId(), ((CirClassType)$this$makeNullable).getOuterType(), ((CirClassType)$this$makeNullable).getVisibility(), ((CirClassType)$this$makeNullable).getArguments(), true);
        } else if (t instanceof CirTypeAliasType) {
            cirSimpleType = CirTypeAliasType.Companion.createInterned(((CirTypeAliasType)$this$makeNullable).getClassifierId(), (CirClassOrTypeAliasType)UtilsKt.makeNullable((CirSimpleType)((CirTypeAliasType)$this$makeNullable).getUnderlyingType()), ((CirTypeAliasType)$this$makeNullable).getArguments(), true);
        } else if (t instanceof CirTypeParameterType) {
            cirSimpleType = CirTypeParameterType.Companion.createInterned(((CirTypeParameterType)$this$makeNullable).getIndex(), true);
        } else {
            String string2 = Intrinsics.stringPlus((String)"Unsupported type: ", $this$makeNullable);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        CirSimpleType result = cirSimpleType;
        return (T)result;
    }

    @NotNull
    public static final <T extends CirSimpleType> T makeNullableIfNecessary(@NotNull T $this$makeNullableIfNecessary, boolean necessary) {
        Intrinsics.checkNotNullParameter($this$makeNullableIfNecessary, (String)"<this>");
        boolean $i$f$makeNullableIfNecessary = false;
        return !necessary ? $this$makeNullableIfNecessary : UtilsKt.makeNullable($this$makeNullableIfNecessary);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CirClassType unabbreviate(@NotNull CirClassOrTypeAliasType $this$unabbreviate) {
        CirClassType cirClassType;
        Intrinsics.checkNotNullParameter((Object)$this$unabbreviate, (String)"<this>");
        CirClassOrTypeAliasType cirClassOrTypeAliasType = $this$unabbreviate;
        if (cirClassOrTypeAliasType instanceof CirClassType) {
            CirClassType unabbreviatedOuterType;
            List<CirTypeProjection> list;
            boolean hasAbbreviationsInArguments = false;
            Collection $this$compactMap$iv = $this$unabbreviate.getArguments();
            boolean $i$f$compactMap = false;
            int n = $this$compactMap$iv.size();
            switch (n) {
                case 0: {
                    list = CollectionsKt.emptyList();
                    break;
                }
                case 1: {
                    CirTypeProjection cirTypeProjection;
                    CirClassOrTypeAliasType cirClassOrTypeAliasType2;
                    CirTypeProjection argument = (CirTypeProjection)($this$compactMap$iv instanceof List ? ((List)$this$compactMap$iv).get(0) : $this$compactMap$iv.iterator().next());
                    boolean bl = false;
                    CirRegularTypeProjection cirRegularTypeProjection = argument instanceof CirRegularTypeProjection ? (CirRegularTypeProjection)argument : null;
                    CirType cirType = cirRegularTypeProjection == null ? null : cirRegularTypeProjection.getType();
                    CirClassOrTypeAliasType cirClassOrTypeAliasType3 = cirClassOrTypeAliasType2 = cirType instanceof CirClassOrTypeAliasType ? (CirClassOrTypeAliasType)cirType : null;
                    if (cirClassOrTypeAliasType2 == null) {
                        cirTypeProjection = argument;
                    } else {
                        CirRegularTypeProjection cirRegularTypeProjection2;
                        CirClassOrTypeAliasType argumentType = cirClassOrTypeAliasType2;
                        CirClassType unabbreviatedArgumentType = UtilsKt.unabbreviate(argumentType);
                        if (Intrinsics.areEqual((Object)argumentType, (Object)unabbreviatedArgumentType)) {
                            cirRegularTypeProjection2 = (CirRegularTypeProjection)argument;
                        } else {
                            hasAbbreviationsInArguments = true;
                            cirRegularTypeProjection2 = new CirRegularTypeProjection(((CirRegularTypeProjection)argument).getProjectionKind(), unabbreviatedArgumentType);
                        }
                        cirTypeProjection = cirRegularTypeProjection2;
                    }
                    List<CirTypeProjection> list2 = Collections.singletonList(cirTypeProjection);
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"singletonList(transform(\u2026 else iterator().next()))");
                    list = list2;
                    break;
                }
                default: {
                    void $this$mapTo$iv$iv;
                    Iterable iterable = $this$compactMap$iv;
                    Collection destination$iv$iv = new ArrayList($this$compactMap$iv.size());
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        CirTypeProjection cirTypeProjection;
                        CirClassOrTypeAliasType argumentType;
                        void argument;
                        CirTypeProjection bl = (CirTypeProjection)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean $i$a$-compactMap-UtilsKt$unabbreviate$unabbreviatedArguments$2 = false;
                        CirRegularTypeProjection cirRegularTypeProjection = argument instanceof CirRegularTypeProjection ? (CirRegularTypeProjection)argument : null;
                        CirType cirType = cirRegularTypeProjection == null ? null : cirRegularTypeProjection.getType();
                        CirClassOrTypeAliasType cirClassOrTypeAliasType4 = argumentType = cirType instanceof CirClassOrTypeAliasType ? (CirClassOrTypeAliasType)cirType : null;
                        if (argumentType == null) {
                            cirTypeProjection = argument;
                        } else {
                            CirRegularTypeProjection cirRegularTypeProjection3;
                            CirClassOrTypeAliasType argumentType2 = argumentType;
                            CirClassType unabbreviatedArgumentType = UtilsKt.unabbreviate(argumentType2);
                            if (Intrinsics.areEqual((Object)argumentType2, (Object)unabbreviatedArgumentType)) {
                                cirRegularTypeProjection3 = (CirRegularTypeProjection)argument;
                            } else {
                                hasAbbreviationsInArguments = true;
                                cirRegularTypeProjection3 = new CirRegularTypeProjection(((CirRegularTypeProjection)argument).getProjectionKind(), unabbreviatedArgumentType);
                            }
                            cirTypeProjection = cirRegularTypeProjection3;
                        }
                        void var19_27 = cirTypeProjection;
                        collection.add(var19_27);
                    }
                    list = (List)destination$iv$iv;
                }
            }
            List<CirTypeProjection> unabbreviatedArguments = list;
            CirClassType outerType = ((CirClassType)$this$unabbreviate).getOuterType();
            CirClassType cirClassType2 = outerType;
            CirClassType cirClassType3 = unabbreviatedOuterType = cirClassType2 == null ? null : UtilsKt.unabbreviate(cirClassType2);
            cirClassType = !hasAbbreviationsInArguments && Intrinsics.areEqual((Object)outerType, (Object)unabbreviatedOuterType) ? (CirClassType)$this$unabbreviate : CirClassType.Companion.createInterned($this$unabbreviate.getClassifierId(), unabbreviatedOuterType, ((CirClassType)$this$unabbreviate).getVisibility(), (List<? extends CirTypeProjection>)unabbreviatedArguments, $this$unabbreviate.isMarkedNullable());
        } else if (cirClassOrTypeAliasType instanceof CirTypeAliasType) {
            cirClassType = UtilsKt.unabbreviate(UtilsKt.computeExpandedType($this$unabbreviate));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return cirClassType;
    }

    @NotNull
    public static final CirClassType computeExpandedType(@NotNull CirClassOrTypeAliasType underlyingType) {
        CirClassOrTypeAliasType cirClassOrTypeAliasType;
        CirClassOrTypeAliasType cirClassOrTypeAliasType2;
        Intrinsics.checkNotNullParameter((Object)underlyingType, (String)"underlyingType");
        CirClassOrTypeAliasType cirClassOrTypeAliasType3 = underlyingType;
        while (!((cirClassOrTypeAliasType2 = (cirClassOrTypeAliasType = cirClassOrTypeAliasType3)) instanceof CirClassType)) {
            if (cirClassOrTypeAliasType2 instanceof CirTypeAliasType) {
                cirClassOrTypeAliasType3 = ((CirTypeAliasType)cirClassOrTypeAliasType).getUnderlyingType();
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return (CirClassType)cirClassOrTypeAliasType;
    }

    @NotNull
    public static final Void unsupported(@NotNull CirDeclaration $this$unsupported) {
        Intrinsics.checkNotNullParameter((Object)$this$unsupported, (String)"<this>");
        boolean $i$f$unsupported = false;
        String string2 = "This method should never be called on " + $this$unsupported.getClass() + ", " + $this$unsupported;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }
}

