/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.cir.CirClassifier;
import org.jetbrains.kotlin.commonizer.cir.CirTypeAlias;
import org.jetbrains.kotlin.commonizer.core.AbstractStandardCommonizer;
import org.jetbrains.kotlin.commonizer.core.TypeAliasExpectClassCommonizer;
import org.jetbrains.kotlin.commonizer.core.TypeAliasLiftingUpCommonizer;
import org.jetbrains.kotlin.commonizer.core.TypeAliasShortCircuitingCommonizer;
import org.jetbrains.kotlin.commonizer.mergedtree.CirKnownClassifiers;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u0003H\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/TypeAliasCommonizer;", "Lorg/jetbrains/kotlin/commonizer/core/AbstractStandardCommonizer;", "Lorg/jetbrains/kotlin/commonizer/cir/CirTypeAlias;", "Lorg/jetbrains/kotlin/commonizer/cir/CirClassifier;", "classifiers", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;", "(Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;)V", "primary", "Lorg/jetbrains/kotlin/commonizer/core/TypeAliasShortCircuitingCommonizer;", "secondary", "Lorg/jetbrains/kotlin/commonizer/core/TypeAliasLiftingUpCommonizer;", "tertiary", "Lorg/jetbrains/kotlin/commonizer/core/TypeAliasExpectClassCommonizer;", "commonizationResult", "doCommonizeWith", "", "next", "initialize", "", "first", "kotlin-klib-commonizer"})
public final class TypeAliasCommonizer
extends AbstractStandardCommonizer<CirTypeAlias, CirClassifier> {
    @NotNull
    private final TypeAliasShortCircuitingCommonizer primary;
    @NotNull
    private final TypeAliasLiftingUpCommonizer secondary;
    @NotNull
    private final TypeAliasExpectClassCommonizer tertiary;

    public TypeAliasCommonizer(@NotNull CirKnownClassifiers classifiers) {
        Intrinsics.checkNotNullParameter((Object)classifiers, (String)"classifiers");
        this.primary = new TypeAliasShortCircuitingCommonizer(classifiers);
        this.secondary = new TypeAliasLiftingUpCommonizer(classifiers);
        this.tertiary = new TypeAliasExpectClassCommonizer();
    }

    @Override
    @NotNull
    protected CirClassifier commonizationResult() {
        CirTypeAlias cirTypeAlias;
        CirTypeAlias cirTypeAlias2 = this.primary.getResultOrNull();
        return cirTypeAlias2 == null ? ((cirTypeAlias = this.secondary.getResultOrNull()) == null ? (CirClassifier)this.tertiary.getResult() : (CirClassifier)cirTypeAlias) : (CirClassifier)cirTypeAlias2;
    }

    @Override
    protected void initialize(@NotNull CirTypeAlias first) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
    }

    @Override
    protected boolean doCommonizeWith(@NotNull CirTypeAlias next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        boolean primaryResult = this.primary.commonizeWith(next);
        boolean secondaryResult = this.secondary.commonizeWith(next);
        boolean tertiaryResult = this.tertiary.commonizeWith(next);
        return primaryResult || secondaryResult || tertiaryResult;
    }
}

