/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.CommonizerLogLevel;
import org.jetbrains.kotlin.commonizer.cli.CliLoggerAdapter;
import org.jetbrains.kotlin.commonizer.utils.ResettableClockMark;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0096\u0001J\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u000bH\u0096\u0001J\u0006\u0010\u0011\u001a\u00020\u0000J\u0011\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0096\u0001J\u0006\u0010\u0013\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0011\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0096\u0001R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/commonizer/utils/ProgressLogger;", "Lorg/jetbrains/kotlin/util/Logger;", "wrapped", "indent", "", "(Lorg/jetbrains/kotlin/util/Logger;I)V", "clockMark", "Lorg/jetbrains/kotlin/commonizer/utils/ResettableClockMark;", "finished", "", "prefix", "", "error", "", "message", "fatal", "", "fork", "log", "logTotal", "progress", "warning", "kotlin-klib-commonizer"})
public final class ProgressLogger
implements Logger {
    @NotNull
    private final Logger wrapped;
    private final int indent;
    @NotNull
    private final ResettableClockMark clockMark;
    private boolean finished;
    @NotNull
    private final String prefix;

    public ProgressLogger(@NotNull Logger wrapped, int indent) {
        Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
        this.wrapped = wrapped;
        this.indent = indent;
        this.clockMark = new ResettableClockMark();
        this.prefix = Intrinsics.stringPlus((String)StringsKt.repeat((CharSequence)"  ", (int)this.indent), (Object)" * ");
        this.clockMark.reset();
        boolean bl = this.indent >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Required indent >= 1";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ ProgressLogger(Logger logger, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            logger = new CliLoggerAdapter(CommonizerLogLevel.Info, 0);
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(logger, n);
    }

    public void error(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.wrapped.error(message);
    }

    @NotNull
    public Void fatal(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.wrapped.fatal(message);
        return null;
    }

    public void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.wrapped.log(message);
    }

    public void warning(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.wrapped.warning(message);
    }

    public final void progress(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean bl = !this.finished;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Check failed.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this.wrapped.log(this.prefix + message + " in " + this.clockMark.elapsedSinceLast());
    }

    public final void logTotal() {
        boolean bl = !this.finished;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Check failed.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this.wrapped.log(Intrinsics.stringPlus((String)"TOTAL: ", (Object)this.clockMark.elapsedSinceStart()));
        this.finished = true;
    }

    @NotNull
    public final ProgressLogger fork() {
        return new ProgressLogger(this, this.indent + 1);
    }

    public ProgressLogger() {
        this(null, 0, 3, null);
    }
}

