/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.konan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataMetadataVersionKt;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataVersion;
import org.jetbrains.kotlin.descriptors.commonizer.CommonizerParameters;
import org.jetbrains.kotlin.descriptors.commonizer.FacadeKt;
import org.jetbrains.kotlin.descriptors.commonizer.LeafTarget;
import org.jetbrains.kotlin.descriptors.commonizer.TargetProvider;
import org.jetbrains.kotlin.descriptors.commonizer.konan.AllNativeLibraries;
import org.jetbrains.kotlin.descriptors.commonizer.konan.NativeDistributionModulesProvider;
import org.jetbrains.kotlin.descriptors.commonizer.konan.NativeDistributionResultsConsumer;
import org.jetbrains.kotlin.descriptors.commonizer.konan.NativeDistributionStdlibProvider;
import org.jetbrains.kotlin.descriptors.commonizer.konan.NativeLibrariesToCommonize;
import org.jetbrains.kotlin.descriptors.commonizer.konan.NativeLibrary;
import org.jetbrains.kotlin.descriptors.commonizer.stats.AggregatedStatsCollector;
import org.jetbrains.kotlin.descriptors.commonizer.stats.FileStatsOutput;
import org.jetbrains.kotlin.descriptors.commonizer.stats.RawStatsCollector;
import org.jetbrains.kotlin.descriptors.commonizer.stats.StatsCollector;
import org.jetbrains.kotlin.descriptors.commonizer.utils.ResettableClockMark;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.library.NativeLibraryConstantsKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.SingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.SingleFileResolveKt;
import org.jetbrains.kotlin.library.ToolingSingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001$BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u0017H\u0002J\u0006\u0010#\u001a\u00020\u0017R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u00020\u0003*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeDistributionCommonizer;", "", "repository", "Ljava/io/File;", "targets", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "destination", "copyStdlib", "", "copyEndorsedLibs", "statsType", "Lorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeDistributionCommonizer$StatsType;", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "(Ljava/io/File;Ljava/util/List;Ljava/io/File;ZZLorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeDistributionCommonizer$StatsType;Lorg/jetbrains/kotlin/util/Logger;)V", "clockMark", "Lorg/jetbrains/kotlin/descriptors/commonizer/utils/ResettableClockMark;", "platformLibrariesSource", "Lorg/jetbrains/kotlin/descriptors/commonizer/LeafTarget;", "getPlatformLibrariesSource", "(Lorg/jetbrains/kotlin/descriptors/commonizer/LeafTarget;)Ljava/io/File;", "checkPreconditions", "", "commonizeAndSaveResults", "allLibraries", "Lorg/jetbrains/kotlin/descriptors/commonizer/konan/AllNativeLibraries;", "loadLibraries", "loadLibrary", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "location", "logProgress", "message", "", "logTotal", "run", "StatsType", "kotlin-klib-commonizer"})
public final class NativeDistributionCommonizer {
    @NotNull
    private final java.io.File repository;
    @NotNull
    private final List<KonanTarget> targets;
    @NotNull
    private final java.io.File destination;
    private final boolean copyStdlib;
    private final boolean copyEndorsedLibs;
    @NotNull
    private final StatsType statsType;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ResettableClockMark clockMark;

    public NativeDistributionCommonizer(@NotNull java.io.File repository, @NotNull List<? extends KonanTarget> targets, @NotNull java.io.File destination, boolean copyStdlib, boolean copyEndorsedLibs, @NotNull StatsType statsType, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)((Object)statsType), (String)"statsType");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.repository = repository;
        this.targets = targets;
        this.destination = destination;
        this.copyStdlib = copyStdlib;
        this.copyEndorsedLibs = copyEndorsedLibs;
        this.statsType = statsType;
        this.logger = logger;
        this.clockMark = new ResettableClockMark();
    }

    public final void run() {
        this.checkPreconditions();
        this.clockMark.reset();
        AllNativeLibraries allLibraries = this.loadLibraries();
        this.commonizeAndSaveResults(allLibraries);
        this.logTotal();
    }

    private final void checkPreconditions() {
        if (!this.repository.isDirectory()) {
            this.logger.fatal(Intrinsics.stringPlus((String)"Repository does not exist: ", (Object)this.repository));
            throw null;
        }
        int n = this.targets.size();
        switch (n) {
            case 0: {
                this.logger.fatal("No targets specified");
                throw null;
            }
            case 1: {
                this.logger.fatal(Intrinsics.stringPlus((String)"Too few targets specified: ", this.targets));
                throw null;
            }
        }
        if (!this.destination.exists()) {
            this.destination.mkdirs();
        } else {
            boolean bl;
            block10: {
                if (!this.destination.isDirectory()) {
                    this.logger.fatal(Intrinsics.stringPlus((String)"Output already exists: ", (Object)this.destination));
                    throw null;
                }
                Sequence $this$any$iv = (Sequence)FilesKt.walkTopDown((java.io.File)this.destination);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    java.io.File it = (java.io.File)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)this.destination))) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
            if (bl) {
                this.logger.fatal(Intrinsics.stringPlus((String)"Output is not empty: ", (Object)this.destination));
                throw null;
            }
        }
    }

    private final void logProgress(String message) {
        this.logger.log("* " + message + " in " + this.clockMark.elapsedSinceLast());
    }

    private final void logTotal() {
        this.logger.log(Intrinsics.stringPlus((String)"TOTAL: ", (Object)this.clockMark.elapsedSinceStart()));
    }

    /*
     * WARNING - void declaration
     */
    private final AllNativeLibraries loadLibraries() {
        void $this$associateTo$iv$iv;
        java.io.File stdlibPath = FilesKt.resolve((java.io.File)this.repository, (java.io.File)NativeLibraryConstantsKt.konanCommonLibraryPath((String)"stdlib"));
        NativeLibrary stdlib = new NativeLibrary(this.loadLibrary(stdlibPath));
        Iterable $this$associate$iv = this.targets;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            java.io.File[] platformLibs;
            List list;
            java.io.File[] fileArray;
            Map map = destination$iv$iv;
            KonanTarget target = (KonanTarget)element$iv$iv;
            boolean bl = false;
            LeafTarget leafTarget = new LeafTarget(target.getName(), target);
            java.io.File[] fileArray2 = this.getPlatformLibrariesSource(leafTarget);
            boolean bl2 = false;
            boolean bl3 = false;
            java.io.File[] it = fileArray2;
            boolean bl4 = false;
            java.io.File[] fileArray3 = it.isDirectory() ? fileArray2 : null;
            java.io.File[] fileArray4 = fileArray = fileArray3 == null ? null : fileArray3.listFiles();
            if (fileArray == null) {
                list = null;
            } else {
                fileArray2 = fileArray;
                bl2 = false;
                bl3 = false;
                it = fileArray2;
                boolean bl5 = false;
                java.io.File[] fileArray5 = it;
                int n = 0;
                java.io.File[] fileArray6 = fileArray5;
                boolean bl6 = false;
                Object object = fileArray3 = !(fileArray6.length == 0) ? fileArray2 : null;
                if (fileArray3 == null) {
                    list = null;
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    fileArray2 = fileArray3;
                    boolean $i$f$map = false;
                    void var18_18 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    fileArray5 = $this$mapTo$iv$iv;
                    n = fileArray5.length;
                    for (int i = 0; i < n; ++i) {
                        void it2;
                        java.io.File item$iv$iv;
                        java.io.File file2 = item$iv$iv = fileArray5[i];
                        Collection collection = destination$iv$iv2;
                        boolean bl7 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                        NativeLibrary nativeLibrary = new NativeLibrary(this.loadLibrary((java.io.File)it2));
                        collection.add(nativeLibrary);
                    }
                    list = (List)destination$iv$iv2;
                }
            }
            fileArray = list;
            boolean bl8 = false;
            Object object = fileArray;
            if (fileArray == null) {
                object = platformLibs = CollectionsKt.emptyList();
            }
            if (platformLibs.isEmpty()) {
                this.logger.warning("No platform libraries found for target " + target + ". This target will be excluded from commonization.");
            }
            Pair pair = TuplesKt.to((Object)leafTarget, (Object)new NativeLibrariesToCommonize((List<NativeLibrary>)platformLibs));
            boolean bl9 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map librariesByTargets = destination$iv$iv;
        this.logProgress("Read lazy (uninitialized) libraries");
        return new AllNativeLibraries(stdlib, librariesByTargets);
    }

    private final KotlinLibrary loadLibrary(java.io.File location) {
        if (!location.isDirectory()) {
            this.logger.fatal(Intrinsics.stringPlus((String)"Library not found: ", (Object)location));
            throw null;
        }
        String string2 = location.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"location.path");
        KotlinLibrary library = SingleFileResolveKt.resolveSingleFileKlib((File)new File(string2), (Logger)this.logger, (SingleFileKlibResolveStrategy)((SingleFileKlibResolveStrategy)ToolingSingleFileKlibResolveStrategy.INSTANCE));
        if (library.getVersions().getMetadataVersion() == null) {
            this.logger.fatal(Intrinsics.stringPlus((String)"Library does not have metadata version specified in manifest: ", (Object)location));
            throw null;
        }
        KlibMetadataVersion metadataVersion = KlibMetadataMetadataVersionKt.getMetadataVersion((KotlinLibrary)library);
        KlibMetadataVersion klibMetadataVersion = metadataVersion;
        if (!Intrinsics.areEqual((Object)(klibMetadataVersion == null ? null : Boolean.valueOf(klibMetadataVersion.isCompatible())), (Object)true)) {
            this.logger.fatal(StringsKt.trimIndent((String)("\n                Library has incompatible metadata version " + ((klibMetadataVersion = metadataVersion) == null ? "\"unknown\"" : klibMetadataVersion) + ": " + location + "\n                Please make sure that all libraries passed to commonizer compatible metadata version " + KlibMetadataVersion.INSTANCE + "\n                ")));
            throw null;
        }
        return library;
    }

    private final void commonizeAndSaveResults(AllNativeLibraries allLibraries) {
        StatsCollector statsCollector;
        StatsType statsType = this.statsType;
        int n = WhenMappings.$EnumSwitchMapping$0[statsType.ordinal()];
        switch (n) {
            case 1: {
                statsCollector = new RawStatsCollector(this.targets);
                break;
            }
            case 2: {
                statsCollector = new AggregatedStatsCollector(this.targets);
                break;
            }
            case 3: {
                statsCollector = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        StatsCollector statsCollector2 = statsCollector;
        Object object = new CommonizerParameters(statsCollector2, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){

            public final void invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                NativeDistributionCommonizer.access$logProgress((NativeDistributionCommonizer)this.receiver, p0);
            }

            @NotNull
            public final String getSignature() {
                return "logProgress(Ljava/lang/String;)V";
            }

            @NotNull
            public final String getName() {
                return "logProgress";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(NativeDistributionCommonizer.class);
            }
        }));
        boolean bl = false;
        boolean bl2 = false;
        CommonizerParameters $this$commonizeAndSaveResults_u24lambda_u2d6 = object;
        boolean bl3 = false;
        LockBasedStorageManager storageManager = new LockBasedStorageManager("Commonized modules");
        $this$commonizeAndSaveResults_u24lambda_u2d6.setResultsConsumer(new NativeDistributionResultsConsumer(this.repository, allLibraries, this.destination, this.copyStdlib, this.copyEndorsedLibs, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){

            public final void invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                NativeDistributionCommonizer.access$logProgress((NativeDistributionCommonizer)this.receiver, p0);
            }

            @NotNull
            public final String getSignature() {
                return "logProgress(Ljava/lang/String;)V";
            }

            @NotNull
            public final String getName() {
                return "logProgress";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(NativeDistributionCommonizer.class);
            }
        })));
        $this$commonizeAndSaveResults_u24lambda_u2d6.setDependeeModulesProvider(new NativeDistributionStdlibProvider((StorageManager)storageManager, allLibraries.getStdlib()));
        Map<LeafTarget, NativeLibrariesToCommonize> $this$forEach$iv = allLibraries.getLibrariesByTargets();
        boolean $i$f$forEach = false;
        Map<LeafTarget, NativeLibrariesToCommonize> map = $this$forEach$iv;
        boolean bl4 = false;
        Iterator<Map.Entry<LeafTarget, NativeLibrariesToCommonize>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<LeafTarget, NativeLibrariesToCommonize> element$iv;
            Map.Entry<LeafTarget, NativeLibrariesToCommonize> $dstr$target$librariesToCommonize = element$iv = iterator2.next();
            boolean bl5 = false;
            Map.Entry<LeafTarget, NativeLibrariesToCommonize> entry = $dstr$target$librariesToCommonize;
            boolean bl6 = false;
            LeafTarget target = entry.getKey();
            Map.Entry<LeafTarget, NativeLibrariesToCommonize> entry2 = $dstr$target$librariesToCommonize;
            boolean bl7 = false;
            NativeLibrariesToCommonize librariesToCommonize = entry2.getValue();
            if (librariesToCommonize.getLibraries().isEmpty()) continue;
            NativeDistributionModulesProvider modulesProvider = new NativeDistributionModulesProvider((StorageManager)storageManager, librariesToCommonize);
            $this$commonizeAndSaveResults_u24lambda_u2d6.addTarget(new TargetProvider(target, modulesProvider, null));
        }
        CommonizerParameters parameters2 = object;
        FacadeKt.runCommonization(parameters2);
        object = statsCollector2;
        if (object != null) {
            String string2 = this.statsType.name();
            bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            object.writeTo(new FileStatsOutput(this.destination, string4));
        }
    }

    private final java.io.File getPlatformLibrariesSource(LeafTarget $this$platformLibrariesSource) {
        return FilesKt.resolve((java.io.File)FilesKt.resolve((java.io.File)FilesKt.resolve((java.io.File)this.repository, (String)"klib"), (String)"platform"), (String)$this$platformLibrariesSource.getName());
    }

    public static final /* synthetic */ void access$logProgress(NativeDistributionCommonizer $this, String message) {
        $this.logProgress(message);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeDistributionCommonizer$StatsType;", "", "(Ljava/lang/String;I)V", "RAW", "AGGREGATED", "NONE", "kotlin-klib-commonizer"})
    public static final class StatsType
    extends Enum<StatsType> {
        public static final /* enum */ StatsType RAW = new StatsType();
        public static final /* enum */ StatsType AGGREGATED = new StatsType();
        public static final /* enum */ StatsType NONE = new StatsType();
        private static final /* synthetic */ StatsType[] $VALUES;

        public static StatsType[] values() {
            StatsType[] statsTypeArray = $VALUES;
            StatsType[] statsTypeArray2 = new StatsType[statsTypeArray.length];
            System.arraycopy(statsTypeArray, 0, statsTypeArray2, 0, statsTypeArray.length);
            return statsTypeArray2;
        }

        public static StatsType valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(StatsType.class, value);
        }

        static {
            $VALUES = statsTypeArray = new StatsType[]{StatsType.RAW, StatsType.AGGREGATED, StatsType.NONE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StatsType.values().length];
            nArray[StatsType.RAW.ordinal()] = 1;
            nArray[StatsType.AGGREGATED.ordinal()] = 2;
            nArray[StatsType.NONE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

