/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.core;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirFunctionOrProperty;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirHasVisibility;
import org.jetbrains.kotlin.descriptors.commonizer.core.VisibilityCommonizer;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\nH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/core/LoweringVisibilityCommonizer;", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/VisibilityCommonizer;", "()V", "atLeastOneVirtualCallableMet", "", "atLeastTwoVisibilitiesMet", "canBeCommonized", "next", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirHasVisibility;", "getNext", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "current", "kotlin-klib-commonizer"})
final class LoweringVisibilityCommonizer
extends VisibilityCommonizer {
    private boolean atLeastOneVirtualCallableMet;
    private boolean atLeastTwoVisibilitiesMet;

    @Override
    protected boolean canBeCommonized(@NotNull CirHasVisibility next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        if (!this.atLeastOneVirtualCallableMet) {
            CirFunctionOrProperty cirFunctionOrProperty = next instanceof CirFunctionOrProperty ? (CirFunctionOrProperty)next : null;
            this.atLeastOneVirtualCallableMet = Intrinsics.areEqual((Object)(cirFunctionOrProperty == null ? null : Boolean.valueOf(cirFunctionOrProperty.isVirtual())), (Object)true);
        }
        return !this.atLeastOneVirtualCallableMet || !this.atLeastTwoVisibilitiesMet;
    }

    @Override
    @NotNull
    protected DescriptorVisibility getNext(@NotNull DescriptorVisibility current, @NotNull DescriptorVisibility next) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        Integer n = DescriptorVisibilities.compare((DescriptorVisibility)current, (DescriptorVisibility)next);
        if (n == null) {
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"UNKNOWN");
            return descriptorVisibility;
        }
        int comparisonResult = n;
        if (!this.atLeastTwoVisibilitiesMet) {
            boolean bl = this.atLeastTwoVisibilitiesMet = comparisonResult != 0;
        }
        if (this.atLeastOneVirtualCallableMet && this.atLeastTwoVisibilitiesMet) {
            n = DescriptorVisibilities.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"UNKNOWN");
            return n;
        }
        return comparisonResult <= 0 ? current : next;
    }
}

