/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.metadata.internal.library.impl;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.metadata.internal.konan.file.File;
import kotlinx.metadata.internal.konan.file.ZipUtilKt;
import kotlinx.metadata.internal.konan.properties.PropertiesKt;
import kotlinx.metadata.internal.library.BaseWriter;
import kotlinx.metadata.internal.library.KotlinLibrary;
import kotlinx.metadata.internal.library.KotlinLibraryKt;
import kotlinx.metadata.internal.library.KotlinLibraryVersioning;
import kotlinx.metadata.internal.library.KotlinLibraryVersioningKt;
import kotlinx.metadata.internal.library.impl.BaseWriterImpl;
import kotlinx.metadata.internal.library.impl.BuiltInsPlatform;
import kotlinx.metadata.internal.library.impl.KotlinLibraryLayoutForWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u000bH\u0016J\u0014\u0010&\u001a\u00020#2\n\u0010'\u001a\u00060\u0017j\u0002`\u0018H\u0016J\b\u0010(\u001a\u00020#H\u0016R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0015\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006)"}, d2={"Lkotlinx/metadata/internal/library/impl/BaseWriterImpl;", "Lkotlinx/metadata/internal/library/BaseWriter;", "libraryLayout", "Lkotlinx/metadata/internal/library/impl/KotlinLibraryLayoutForWriter;", "moduleName", "", "_versions", "Lkotlinx/metadata/internal/library/KotlinLibraryVersioning;", "builtInsPlatform", "Lkotlinx/metadata/internal/library/impl/BuiltInsPlatform;", "nativeTargets", "", "nopack", "", "shortName", "(Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutForWriter;Ljava/lang/String;Lorg/jetbrains/kotlin/library/KotlinLibraryVersioning;Lorg/jetbrains/kotlin/library/impl/BuiltInsPlatform;Ljava/util/List;ZLjava/lang/String;)V", "klibFile", "Lkotlinx/metadata/internal/konan/file/File;", "getKlibFile", "()Lorg/jetbrains/kotlin/konan/file/File;", "getLibraryLayout", "()Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutForWriter;", "manifestProperties", "Ljava/util/Properties;", "Lkotlinx/metadata/internal/konan/properties/Properties;", "getManifestProperties", "()Ljava/util/Properties;", "getNopack", "()Z", "getShortName", "()Ljava/lang/String;", "versions", "getVersions", "()Lorg/jetbrains/kotlin/library/KotlinLibraryVersioning;", "addLinkDependencies", "", "libraries", "Lkotlinx/metadata/internal/library/KotlinLibrary;", "addManifestAddend", "properties", "commit", "kotlin-util-klib"})
public class BaseWriterImpl
implements BaseWriter {
    @NotNull
    private final KotlinLibraryLayoutForWriter libraryLayout;
    private final boolean nopack;
    @Nullable
    private final String shortName;
    @NotNull
    private final File klibFile;
    @NotNull
    private final Properties manifestProperties;
    @NotNull
    private final KotlinLibraryVersioning versions;

    public BaseWriterImpl(@NotNull KotlinLibraryLayoutForWriter libraryLayout, @NotNull String moduleName, @NotNull KotlinLibraryVersioning _versions, @NotNull BuiltInsPlatform builtInsPlatform, @NotNull List<String> nativeTargets, boolean nopack, @Nullable String shortName) {
        Intrinsics.checkNotNullParameter((Object)libraryLayout, (String)"libraryLayout");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)_versions, (String)"_versions");
        Intrinsics.checkNotNullParameter((Object)((Object)builtInsPlatform), (String)"builtInsPlatform");
        Intrinsics.checkNotNullParameter(nativeTargets, (String)"nativeTargets");
        this.libraryLayout = libraryLayout;
        this.nopack = nopack;
        this.shortName = shortName;
        this.klibFile = this.libraryLayout.getLibFile().getCanonicalFile();
        this.manifestProperties = new Properties();
        this.versions = _versions;
        this.klibFile.deleteRecursively();
        Object object = this.klibFile.getParentFile();
        boolean bl = false;
        boolean bl2 = false;
        File $this$_init__u24lambda_u2d0 = object;
        boolean bl3 = false;
        if (!$this$_init__u24lambda_u2d0.getExists()) {
            $this$_init__u24lambda_u2d0.mkdirs();
        }
        this.libraryLayout.getResourcesDir().mkdirs();
        this.manifestProperties.setProperty("unique_name", moduleName);
        KotlinLibraryVersioningKt.writeKonanLibraryVersioning(this.manifestProperties, _versions);
        if (builtInsPlatform != BuiltInsPlatform.COMMON) {
            this.manifestProperties.setProperty("builtins_platform", builtInsPlatform.name());
            if (builtInsPlatform == BuiltInsPlatform.NATIVE) {
                this.manifestProperties.setProperty("native_targets", CollectionsKt.joinToString$default((Iterable)nativeTargets, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            }
        }
        if ((object = this.shortName) != null) {
            Object object2 = object;
            bl2 = false;
            boolean bl4 = false;
            Object it = object2;
            boolean bl5 = false;
            this.getManifestProperties().setProperty("short_name", (String)it);
        }
    }

    public /* synthetic */ BaseWriterImpl(KotlinLibraryLayoutForWriter kotlinLibraryLayoutForWriter, String string2, KotlinLibraryVersioning kotlinLibraryVersioning, BuiltInsPlatform builtInsPlatform, List list, boolean bl, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            string3 = null;
        }
        this(kotlinLibraryLayoutForWriter, string2, kotlinLibraryVersioning, builtInsPlatform, list, bl, string3);
    }

    @NotNull
    public final KotlinLibraryLayoutForWriter getLibraryLayout() {
        return this.libraryLayout;
    }

    public final boolean getNopack() {
        return this.nopack;
    }

    @Nullable
    public final String getShortName() {
        return this.shortName;
    }

    @NotNull
    public final File getKlibFile() {
        return this.klibFile;
    }

    @NotNull
    public final Properties getManifestProperties() {
        return this.manifestProperties;
    }

    @Override
    @NotNull
    public KotlinLibraryVersioning getVersions() {
        return this.versions;
    }

    @Override
    public void addLinkDependencies(@NotNull List<? extends KotlinLibrary> libraries) {
        Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
        if (libraries.isEmpty()) {
            this.manifestProperties.remove("depends");
            return;
        }
        String newValue2 = CollectionsKt.joinToString$default((Iterable)libraries, (CharSequence)" ", null, null, (int)0, null, (Function1)addLinkDependencies.newValue.1.INSTANCE, (int)30, null);
        this.manifestProperties.setProperty("depends", newValue2);
        Iterable $this$forEach$iv = libraries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinLibrary it = (KotlinLibrary)element$iv;
            boolean bl = false;
            if (it.getVersions().getLibraryVersion() == null) continue;
            this.getManifestProperties().setProperty(Intrinsics.stringPlus((String)"dependency_version_", (Object)KotlinLibraryKt.getUniqueName(it)), it.getVersions().getLibraryVersion());
        }
    }

    @Override
    public void addManifestAddend(@NotNull Properties properties2) {
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        this.manifestProperties.putAll((Map<?, ?>)properties2);
    }

    @Override
    public void commit() {
        PropertiesKt.saveToFile((Properties)this.manifestProperties, (File)this.libraryLayout.getManifestFile());
        if (!this.nopack) {
            ZipUtilKt.zipDirAs((File)this.libraryLayout.getUnzippedDir(), (File)this.klibFile);
            this.libraryLayout.getUnzippedDir().deleteRecursively();
        }
    }
}

