/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.core;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirType;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirValueParameter;
import org.jetbrains.kotlin.descriptors.commonizer.cir.factory.CirValueParameterFactory;
import org.jetbrains.kotlin.descriptors.commonizer.core.AbstractStandardCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.core.TypeCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.CirKnownClassifiers;
import org.jetbrains.kotlin.descriptors.commonizer.utils.MiscKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0002H\u0014J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0014J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/core/ValueParameterCommonizer;", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/AbstractStandardCommonizer;", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirValueParameter;", "classifiers", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirKnownClassifiers;", "(Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirKnownClassifiers;)V", "isCrossinline", "", "isNoinline", "name", "Lorg/jetbrains/kotlin/name/Name;", "returnType", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/TypeCommonizer;", "varargElementType", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirType;", "commonizationResult", "doCommonizeWith", "next", "initialize", "", "first", "overwriteName", "kotlin-klib-commonizer"})
public final class ValueParameterCommonizer
extends AbstractStandardCommonizer<CirValueParameter, CirValueParameter> {
    private Name name;
    @NotNull
    private final TypeCommonizer returnType;
    @Nullable
    private CirType varargElementType;
    private boolean isCrossinline;
    private boolean isNoinline;

    public ValueParameterCommonizer(@NotNull CirKnownClassifiers classifiers2) {
        Intrinsics.checkNotNullParameter((Object)classifiers2, (String)"classifiers");
        this.returnType = new TypeCommonizer(classifiers2);
        this.isCrossinline = true;
        this.isNoinline = true;
    }

    @Override
    @NotNull
    protected CirValueParameter commonizationResult() {
        Name name2 = this.name;
        if (name2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"name");
            throw null;
        }
        return CirValueParameterFactory.INSTANCE.create(CollectionsKt.emptyList(), name2, (CirType)this.returnType.getResult(), this.varargElementType, false, this.isCrossinline, this.isNoinline);
    }

    @Override
    protected void initialize(@NotNull CirValueParameter first) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        this.name = first.getName();
        this.varargElementType = first.getVarargElementType();
        this.isCrossinline = first.isCrossinline();
        this.isNoinline = first.isNoinline();
    }

    @Override
    protected boolean doCommonizeWith(@NotNull CirValueParameter next) {
        boolean result;
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        boolean bl = result = !next.getDeclaresDefaultValue() && MiscKt.isNull(this.varargElementType) == MiscKt.isNull(next.getVarargElementType()) && this.returnType.commonizeWith(next.getReturnType());
        if (result) {
            this.isCrossinline = this.isCrossinline && next.isCrossinline();
            this.isNoinline = this.isNoinline && next.isNoinline();
        }
        return result;
    }

    public final void overwriteName(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.name = name2;
    }
}

