/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.mergedtree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.commonizer.utils.InternersKt;
import org.jetbrains.kotlin.descriptors.commonizer.utils.TypeKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u000b\u001a\u00020\u0006H\u00c2\u0003J\u0011\u0010\f\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tH\u00c2\u0003J%\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tH\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\bH\u00d6\u0001R\u0016\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/PropertyApproximationKey;", "", "property", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;)V", "name", "Lorg/jetbrains/kotlin/name/Name;", "extensionReceiverParameterType", "", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirTypeSignature;", "(Lorg/jetbrains/kotlin/name/Name;Ljava/lang/String;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin-klib-commonizer"})
public final class PropertyApproximationKey {
    @NotNull
    private final Name name;
    @Nullable
    private final String extensionReceiverParameterType;

    public PropertyApproximationKey(@NotNull Name name, @Nullable String extensionReceiverParameterType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.extensionReceiverParameterType = extensionReceiverParameterType;
    }

    public PropertyApproximationKey(@NotNull PropertyDescriptor property) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Name name = property.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"property.name");
        Name name2 = InternersKt.intern(name);
        name = property.getExtensionReceiverParameter();
        this(name2, name == null ? null : ((kotlinType = name.getType()) == null ? null : TypeKt.getSignature(kotlinType)));
    }

    private final Name component1() {
        return this.name;
    }

    private final String component2() {
        return this.extensionReceiverParameterType;
    }

    @NotNull
    public final PropertyApproximationKey copy(@NotNull Name name, @Nullable String extensionReceiverParameterType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new PropertyApproximationKey(name, extensionReceiverParameterType);
    }

    public static /* synthetic */ PropertyApproximationKey copy$default(PropertyApproximationKey propertyApproximationKey, Name name, String string, int n, Object object) {
        if ((n & 1) != 0) {
            name = propertyApproximationKey.name;
        }
        if ((n & 2) != 0) {
            string = propertyApproximationKey.extensionReceiverParameterType;
        }
        return propertyApproximationKey.copy(name, string);
    }

    @NotNull
    public String toString() {
        return "PropertyApproximationKey(name=" + this.name + ", extensionReceiverParameterType=" + this.extensionReceiverParameterType + ')';
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + (this.extensionReceiverParameterType == null ? 0 : this.extensionReceiverParameterType.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PropertyApproximationKey)) {
            return false;
        }
        PropertyApproximationKey propertyApproximationKey = (PropertyApproximationKey)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)propertyApproximationKey.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.extensionReceiverParameterType, (Object)propertyApproximationKey.extensionReceiverParameterType);
    }
}

