/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.commonizer.utils.FqNameKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0002H\u0000\u00a8\u0006\u0005"}, d2={"isDeprecatedTopLevelFunction", "", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "isIgnoredDarwinFunction", "isKniBridgeFunction", "kotlin-klib-commonizer"})
public final class ExcludesKt {
    public static final boolean isKniBridgeFunction(@NotNull SimpleFunctionDescriptor $this$isKniBridgeFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isKniBridgeFunction, (String)"<this>");
        String string = $this$isKniBridgeFunction.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name.asString()");
        return StringsKt.startsWith$default((String)string, (String)"kniBridge", (boolean)false, (int)2, null);
    }

    public static final boolean isDeprecatedTopLevelFunction(@NotNull SimpleFunctionDescriptor $this$isDeprecatedTopLevelFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isDeprecatedTopLevelFunction, (String)"<this>");
        return $this$isDeprecatedTopLevelFunction.getContainingDeclaration() instanceof PackageFragmentDescriptor && $this$isDeprecatedTopLevelFunction.getAnnotations().hasAnnotation(FqNameKt.getDEPRECATED_ANNOTATION_FQN());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIgnoredDarwinFunction(@NotNull SimpleFunctionDescriptor $this$isIgnoredDarwinFunction) {
        boolean bl;
        FqName fqName;
        PackageFragmentDescriptor packageFragmentDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$isIgnoredDarwinFunction, (String)"<this>");
        DeclarationDescriptor declarationDescriptor = $this$isIgnoredDarwinFunction.getContainingDeclaration();
        PackageFragmentDescriptor packageFragmentDescriptor2 = packageFragmentDescriptor = declarationDescriptor instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null;
        if (!Intrinsics.areEqual(packageFragmentDescriptor == null ? null : ((fqName = packageFragmentDescriptor.getFqName()) == null ? null : Boolean.valueOf(FqNameKt.isUnderDarwinPackage(fqName))), (Object)true)) {
            return false;
        }
        String string = $this$isIgnoredDarwinFunction.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name.asString()");
        String string2 = string;
        if (!StringsKt.startsWith$default((String)string2, (String)"simd_", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)string2, (String)"__", (boolean)false, (int)2, null)) {
            return false;
        }
        List list = $this$isIgnoredDarwinFunction.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"valueParameters");
        Iterable iterable = list;
        boolean $i$f$any = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return false;
        }
        Iterator iterator = iterable.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)element$iv;
            boolean bl2 = false;
            KotlinType kotlinType = parameter.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"parameter.type");
            KotlinType type2 = kotlinType;
            SimpleType abbreviationType = SpecialTypesKt.getAbbreviation((KotlinType)type2);
            if (abbreviationType != null) {
                KotlinType $this$declarationDescriptor$iv = (KotlinType)abbreviationType;
                boolean $i$f$getDeclarationDescriptor = false;
                Object object = $this$declarationDescriptor$iv.getConstructor().getDeclarationDescriptor();
                if (object == null) {
                    String string3 = Intrinsics.stringPlus((String)"No declaration descriptor found for ", (Object)$this$declarationDescriptor$iv.getConstructor());
                    boolean bl3 = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                String string4 = object.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"abbreviationType.declarationDescriptor.name.asString()");
                if (StringsKt.startsWith$default((String)string4, (String)"simd_", (boolean)false, (int)2, null)) {
                    KotlinType $this$declarationDescriptor$iv2 = type2;
                    boolean $i$f$getDeclarationDescriptor2 = false;
                    ClassifierDescriptor classifierDescriptor = $this$declarationDescriptor$iv2.getConstructor().getDeclarationDescriptor();
                    if (classifierDescriptor == null) {
                        object = Intrinsics.stringPlus((String)"No declaration descriptor found for ", (Object)$this$declarationDescriptor$iv2.getConstructor());
                        boolean bl4 = false;
                        throw (Throwable)new IllegalStateException(object.toString());
                    }
                    if (Intrinsics.areEqual((Object)classifierDescriptor.getName().asString(), (Object)"Vector128")) {
                        return true;
                    }
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }
}

