/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.stats;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.commonizer.stats.AggregatingOutput;
import org.jetbrains.kotlin.descriptors.commonizer.stats.DeclarationType;
import org.jetbrains.kotlin.descriptors.commonizer.stats.RawStatsCollector;
import org.jetbrains.kotlin.descriptors.commonizer.stats.StatsCollector;
import org.jetbrains.kotlin.descriptors.commonizer.stats.StatsOutput;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\r2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0003H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/stats/AggregatedStatsCollector;", "Lorg/jetbrains/kotlin/descriptors/commonizer/stats/StatsCollector;", "targets", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "output", "Lorg/jetbrains/kotlin/descriptors/commonizer/stats/StatsOutput;", "(Ljava/util/List;Lorg/jetbrains/kotlin/descriptors/commonizer/stats/StatsOutput;)V", "aggregatingOutput", "Lorg/jetbrains/kotlin/descriptors/commonizer/stats/AggregatingOutput;", "wrappedCollector", "Lorg/jetbrains/kotlin/descriptors/commonizer/stats/RawStatsCollector;", "close", "", "logStats", "result", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "AggregatedStatsHeader", "AggregatedStatsRow", "kotlin-klib-commonizer"})
public final class AggregatedStatsCollector
implements StatsCollector {
    @NotNull
    private final StatsOutput output;
    @NotNull
    private final AggregatingOutput aggregatingOutput;
    @NotNull
    private final RawStatsCollector wrappedCollector;

    public AggregatedStatsCollector(@NotNull List<? extends KonanTarget> targets, @NotNull StatsOutput output) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.output = output;
        this.aggregatingOutput = new AggregatingOutput();
        this.wrappedCollector = new RawStatsCollector(targets, this.aggregatingOutput);
    }

    @Override
    public void logStats(@NotNull List<? extends DeclarationDescriptor> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        this.wrappedCollector.logStats(result);
    }

    @Override
    public void close() {
        this.output.writeHeader(AggregatedStatsHeader.INSTANCE);
        Set<DeclarationType> set = this.aggregatingOutput.getAggregatedStats().keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"aggregatingOutput.aggregatedStats.keys");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                DeclarationType it = (DeclarationType)((Object)a);
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it);
                it = (DeclarationType)((Object)b);
                Comparable comparable2 = comparable;
                bl2 = false;
                DeclarationType declarationType = it;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)declarationType)));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeclarationType key = (DeclarationType)((Object)element$iv);
            boolean bl2 = false;
            Map map = this.aggregatingOutput.getAggregatedStats();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)key), (String)"key");
            AggregatedStatsRow row = (AggregatedStatsRow)MapsKt.getValue((Map)map, (Object)((Object)key));
            this.output.writeRow(row);
        }
        this.output.close();
        this.wrappedCollector.close();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/stats/AggregatedStatsCollector$AggregatedStatsHeader;", "Lorg/jetbrains/kotlin/descriptors/commonizer/stats/StatsOutput$StatsHeader;", "()V", "headerItems", "", "", "toList", "kotlin-klib-commonizer"})
    public static final class AggregatedStatsHeader
    implements StatsOutput.StatsHeader {
        @NotNull
        public static final AggregatedStatsHeader INSTANCE = new AggregatedStatsHeader();
        @NotNull
        private static final List<String> headerItems;

        private AggregatedStatsHeader() {
        }

        @Override
        @NotNull
        public List<String> toList() {
            return headerItems;
        }

        static {
            Object[] objectArray = new String[]{"Declaration Type", "Lifted Up", "Lifted Up, %%", "Commonized", "Commonized, %%", "Missing in s. targets", "Missing in s. targets, %%", "Failed: Other", "Failed: Other, %%", "Total"};
            headerItems = CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/stats/AggregatedStatsCollector$AggregatedStatsRow;", "Lorg/jetbrains/kotlin/descriptors/commonizer/stats/StatsOutput$StatsRow;", "declarationType", "Lorg/jetbrains/kotlin/descriptors/commonizer/stats/DeclarationType;", "(Lorg/jetbrains/kotlin/descriptors/commonizer/stats/DeclarationType;)V", "failedBecauseAbsent", "", "getFailedBecauseAbsent", "()I", "setFailedBecauseAbsent", "(I)V", "failedOther", "getFailedOther", "setFailedOther", "liftedUp", "getLiftedUp", "setLiftedUp", "successfullyCommonized", "getSuccessfullyCommonized", "setSuccessfullyCommonized", "toList", "", "", "kotlin-klib-commonizer"})
    public static final class AggregatedStatsRow
    implements StatsOutput.StatsRow {
        @NotNull
        private final DeclarationType declarationType;
        private int liftedUp;
        private int successfullyCommonized;
        private int failedBecauseAbsent;
        private int failedOther;

        public AggregatedStatsRow(@NotNull DeclarationType declarationType) {
            Intrinsics.checkNotNullParameter((Object)((Object)declarationType), (String)"declarationType");
            this.declarationType = declarationType;
        }

        public final int getLiftedUp() {
            return this.liftedUp;
        }

        public final void setLiftedUp(int n) {
            this.liftedUp = n;
        }

        public final int getSuccessfullyCommonized() {
            return this.successfullyCommonized;
        }

        public final void setSuccessfullyCommonized(int n) {
            this.successfullyCommonized = n;
        }

        public final int getFailedBecauseAbsent() {
            return this.failedBecauseAbsent;
        }

        public final void setFailedBecauseAbsent(int n) {
            this.failedBecauseAbsent = n;
        }

        public final int getFailedOther() {
            return this.failedOther;
        }

        public final void setFailedOther(int n) {
            this.failedOther = n;
        }

        @Override
        @NotNull
        public List<String> toList() {
            int total = this.liftedUp + this.successfullyCommonized + this.failedBecauseAbsent + this.failedOther;
            Object[] objectArray = new String[]{this.declarationType.getAlias(), String.valueOf(this.liftedUp), String.valueOf(AggregatedStatsRow.toList$fraction(total, this.liftedUp)), String.valueOf(this.successfullyCommonized), String.valueOf(AggregatedStatsRow.toList$fraction(total, this.successfullyCommonized)), String.valueOf(this.failedBecauseAbsent), String.valueOf(AggregatedStatsRow.toList$fraction(total, this.failedBecauseAbsent)), String.valueOf(this.failedOther), String.valueOf(AggregatedStatsRow.toList$fraction(total, this.failedOther)), String.valueOf(total)};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        private static final double toList$fraction(int $total, int amount) {
            return $total > 0 ? (double)amount / (double)$total : 0.0;
        }
    }
}

