/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.core;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirClassType;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirTypeProjection;
import org.jetbrains.kotlin.descriptors.commonizer.cir.factory.CirTypeFactory;
import org.jetbrains.kotlin.descriptors.commonizer.core.AbstractStandardCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.core.OuterClassTypeCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.core.TypeArgumentListCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.core.TypeCommonizerKt;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.CirClassifiersCache;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0002H\u0014J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/core/ClassTypeCommonizer;", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/AbstractStandardCommonizer;", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirClassType;", "cache", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirClassifiersCache;", "(Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirClassifiersCache;)V", "anyVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "arguments", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/TypeArgumentListCommonizer;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "isMarkedNullable", "", "outerType", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/OuterClassTypeCommonizer;", "commonizationResult", "doCommonizeWith", "next", "initialize", "", "first", "kotlin-klib-commonizer"})
final class ClassTypeCommonizer
extends AbstractStandardCommonizer<CirClassType, CirClassType> {
    private ClassId classId;
    private final OuterClassTypeCommonizer outerType;
    private DescriptorVisibility anyVisibility;
    private final TypeArgumentListCommonizer arguments;
    private boolean isMarkedNullable;
    private final CirClassifiersCache cache;

    @Override
    @NotNull
    protected CirClassType commonizationResult() {
        ClassId classId = this.classId;
        if (classId == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classId");
        }
        CirClassType cirClassType = (CirClassType)this.outerType.getResult();
        DescriptorVisibility descriptorVisibility = this.anyVisibility;
        if (descriptorVisibility == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"anyVisibility");
        }
        return CirTypeFactory.INSTANCE.createClassType(classId, cirClassType, descriptorVisibility, (List<? extends CirTypeProjection>)this.arguments.getResult(), this.isMarkedNullable);
    }

    @Override
    protected void initialize(@NotNull CirClassType first) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        this.classId = first.getClassifierId();
        this.anyVisibility = first.getVisibility();
        this.isMarkedNullable = first.isMarkedNullable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean doCommonizeWith(@NotNull CirClassType next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        if (this.isMarkedNullable != next.isMarkedNullable()) return false;
        ClassId classId = this.classId;
        if (classId == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classId");
        }
        if (!Intrinsics.areEqual((Object)classId, (Object)next.getClassifierId())) return false;
        if (!this.outerType.commonizeWith(next.getOuterType())) return false;
        ClassId classId2 = this.classId;
        if (classId2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classId");
        }
        if (!TypeCommonizerKt.access$commonizeClass(classId2, this.cache)) return false;
        if (!this.arguments.commonizeWith(next.getArguments())) return false;
        return true;
    }

    public ClassTypeCommonizer(@NotNull CirClassifiersCache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.cache = cache;
        this.outerType = new OuterClassTypeCommonizer(this.cache);
        this.arguments = new TypeArgumentListCommonizer(this.cache);
    }
}

