/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kotlin.js.internal

private object DoubleCompanionObject : FloatingPointConstants<Double> {
    override val POSITIVE_INFINITY: Double = js("Number.POSITIVE_INFINITY")
    override val NEGATIVE_INFINITY: Double = js("Number.NEGATIVE_INFINITY")
    override val NaN: Double = js("Number.NaN")
}

private object FloatCompanionObject : FloatingPointConstants<Float> {
    override val POSITIVE_INFINITY : Float = js("Number.POSITIVE_INFINITY")
    override val NEGATIVE_INFINITY : Float = js("Number.NEGATIVE_INFINITY")
    override val NaN : Float = js("Number.NaN")
}

private object IntCompanionObject {}
private object LongCompanionObject {}
private object ShortCompanionObject {}
private object ByteCompanionObject {}

private object StringCompanionObject {}
private object EnumCompanionObject {}
