/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks.publishing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.signing.Sign;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.signatory.Signatory;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.tasks.publishing.CheckPomTask;
import org.jetbrains.kotlin.gradle.tasks.publishing.CheckSigningTask;
import org.jetbrains.kotlin.gradle.tasks.publishing.GeneratePgpKeys;
import org.jetbrains.kotlin.gradle.tasks.publishing.HelpersKt;
import org.jetbrains.kotlin.gradle.tasks.publishing.UploadPgpKeyTask;
import org.jetbrains.kotlin.gradle.utils.ConfigurationsKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0005*\u00020\u0006H\u0000\u001a\f\u0010\b\u001a\u00020\u0005*\u00020\u0006H\u0000\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"keyIdToHex", "", "keyId", "", "addPgpSignatureHelpers", "", "Lorg/gradle/api/Project;", "addPomValidationHelpers", "addSigningValidationHelpers", "maybeCreateBcConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "kotlin-gradle-plugin_common"})
public final class HelpersKt {
    public static final void addPgpSignatureHelpers(@NotNull Project $this$addPgpSignatureHelpers) {
        Intrinsics.checkNotNullParameter((Object)$this$addPgpSignatureHelpers, (String)"<this>");
        $this$addPgpSignatureHelpers.getProject().getPluginManager().withPlugin("signing", new Action($this$addPgpSignatureHelpers){
            final /* synthetic */ Project $this_addPgpSignatureHelpers;
            {
                this.$this_addPgpSignatureHelpers = $receiver;
            }

            public final void execute(AppliedPlugin it) {
                Configuration bcConfiguration = HelpersKt.access$maybeCreateBcConfiguration(this.$this_addPgpSignatureHelpers);
                Provider pgpDirectory = this.$this_addPgpSignatureHelpers.getProject().getLayout().getBuildDirectory().dir("pgp");
                this.$this_addPgpSignatureHelpers.getProject().getTasks().register("generatePgpKeys", GeneratePgpKeys.class, new Action((Provider<Directory>)pgpDirectory, this.$this_addPgpSignatureHelpers, bcConfiguration){
                    final /* synthetic */ Provider<Directory> $pgpDirectory;
                    final /* synthetic */ Project $this_addPgpSignatureHelpers;
                    final /* synthetic */ Configuration $bcConfiguration;
                    {
                        this.$pgpDirectory = $pgpDirectory;
                        this.$this_addPgpSignatureHelpers = $receiver;
                        this.$bcConfiguration = $bcConfiguration;
                    }

                    public final void execute(GeneratePgpKeys it) {
                        it.notCompatibleWithConfigurationCache("Do not cache password.");
                        it.getOutputDirectory().set(this.$pgpDirectory);
                        it.getPassword().set(this.$this_addPgpSignatureHelpers.getProject().getProviders().gradleProperty("signing.password"));
                        Object[] objectArray = new Object[]{this.$bcConfiguration};
                        it.getBouncyCastleClasspath().from(objectArray);
                        it.getGradleHomePath().set((Object)this.$this_addPgpSignatureHelpers.getProject().getGradle().getGradleUserHomeDir().getAbsolutePath());
                        it.setGroup("signing");
                        it.setDescription(StringsKt.trimIndent((String)"\n            Generates a new PGP keypair.\n            \n            Usage: \n            gradlew generatePgpKeys --name \"Jane Doe <janedoe@example.com>\" --password YOUR_PASSWORD\n        "));
                    }
                });
                if (!this.$this_addPgpSignatureHelpers.getGradle().getStartParameter().isOffline()) {
                    this.$this_addPgpSignatureHelpers.getProject().getTasks().register("uploadPublicPgpKey", UploadPgpKeyTask.class, (Action)addPgpSignatureHelpers.2.INSTANCE);
                }
            }
        });
    }

    public static final void addSigningValidationHelpers(@NotNull Project $this$addSigningValidationHelpers) {
        Intrinsics.checkNotNullParameter((Object)$this$addSigningValidationHelpers, (String)"<this>");
        $this$addSigningValidationHelpers.getProject().getPluginManager().withPlugin("signing", new Action($this$addSigningValidationHelpers){
            final /* synthetic */ Project $this_addSigningValidationHelpers;
            {
                this.$this_addSigningValidationHelpers = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(AppliedPlugin it) {
                void $this$getExtension$iv;
                Project name$iv;
                void $this$register$iv;
                Configuration bcConfiguration = HelpersKt.access$maybeCreateBcConfiguration(this.$this_addSigningValidationHelpers);
                TaskContainer taskContainer = this.$this_addSigningValidationHelpers.getProject().getTasks();
                Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                TaskContainer taskContainer2 = taskContainer;
                String string = "checkSigningConfiguration";
                Function1 configuration$iv = (Function1)new Function1<CheckSigningTask, Unit>(bcConfiguration, this.$this_addSigningValidationHelpers){
                    final /* synthetic */ Configuration $bcConfiguration;
                    final /* synthetic */ Project $this_addSigningValidationHelpers;
                    {
                        this.$bcConfiguration = $bcConfiguration;
                        this.$this_addSigningValidationHelpers = $receiver;
                        super(1);
                    }

                    public final void invoke(CheckSigningTask $this$register) {
                        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                        $this$register.setGroup("validation");
                        $this$register.setDescription("Checks that a signing configuration is set up correctly.");
                        $this$register.getGradleHomePath().set((Object)$this$register.getProject().getGradle().getGradleUserHomeDir().getAbsolutePath());
                        Object[] objectArray = new Object[]{this.$bcConfiguration};
                        $this$register.getBouncyCastleClasspath().from(objectArray);
                        $this$register.getOfflineMode().set((Object)this.$this_addSigningValidationHelpers.getGradle().getStartParameter().isOffline());
                        objectArray = new String[]{"https://keys.openpgp.org", "https://keyserver.ubuntu.com"};
                        $this$register.getKeyservers().convention((Iterable)CollectionsKt.listOf((Object[])objectArray));
                    }
                };
                boolean $i$f$register = false;
                TaskProvider taskProvider2 = $this$register$iv.register((String)name$iv, CheckSigningTask.class, new Action(configuration$iv){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ void execute(Object t) {
                        this.function.invoke(t);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"register(...)");
                TaskProvider signingTask2 = taskProvider2;
                Project project = this.$this_addSigningValidationHelpers.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                name$iv = project;
                String name$iv2 = "signing";
                boolean $i$f$getExtension = false;
                SigningExtension signingExtension = (SigningExtension)((ExtensionAware)$this$getExtension$iv).getExtensions().getByName(name$iv2);
                if (signingExtension != null) {
                    string = signingExtension;
                    Project project2 = this.$this_addSigningValidationHelpers;
                    String signing = string;
                    boolean bl = false;
                    signingTask2.configure(new Action((SigningExtension)signing, project2){
                        final /* synthetic */ SigningExtension $signing;
                        final /* synthetic */ Project $this_addSigningValidationHelpers;
                        {
                            this.$signing = $signing;
                            this.$this_addSigningValidationHelpers = $receiver;
                        }

                        public final void execute(CheckSigningTask task2) {
                            block4: {
                                Signatory signatory;
                                try {
                                    signatory = this.$signing.getSignatory();
                                }
                                catch (Exception e) {
                                    this.$this_addSigningValidationHelpers.getLogger().warn("Failed to create signatory: " + e.getMessage());
                                    signatory = null;
                                }
                                Signatory signatory2 = signatory;
                                if (signatory2 != null) {
                                    task2.getSignatory().set((Object)signatory2);
                                }
                                if (GradleVersion.current().compareTo(GradleVersion.version((String)"8.1")) < 0) {
                                    task2.notCompatibleWithConfigurationCache("checkSigningConfiguration task is not compatible with configuration cache on Gradle versions < 8.1.");
                                }
                                task2.getKeyId().set(this.$this_addSigningValidationHelpers.getProviders().gradleProperty("signing.keyId"));
                                task2.getKeyringPath().set(this.$this_addSigningValidationHelpers.getLayout().file(this.$this_addSigningValidationHelpers.getProviders().gradleProperty("signing.secretKeyRingFile").map((Transformer)addSigningValidationHelpers.1.1.INSTANCE)));
                                task2.getHasKeyPassword().set(this.$this_addSigningValidationHelpers.getProviders().gradleProperty("signing.password").map((Transformer)addSigningValidationHelpers.1.2.INSTANCE));
                                Object object = signatory2;
                                if (object == null || (object = object.getKeyId()) == null) break block4;
                                Object it = object;
                                boolean bl = false;
                                task2.getSignatoryKeyId().set(it);
                            }
                        }
                    });
                }
                this.$this_addSigningValidationHelpers.getProject().getPluginManager().withPlugin("maven-publish", new Action(this.$this_addSigningValidationHelpers, (TaskProvider<CheckSigningTask>)signingTask2){
                    final /* synthetic */ Project $this_addSigningValidationHelpers;
                    final /* synthetic */ TaskProvider<CheckSigningTask> $signingTask;
                    {
                        this.$this_addSigningValidationHelpers = $receiver;
                        this.$signingTask = $signingTask;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void execute(AppliedPlugin it) {
                        block0: {
                            void $this$getExtension$iv;
                            Project project = this.$this_addSigningValidationHelpers.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                            Project project2 = project;
                            String name$iv = "publishing";
                            boolean $i$f$getExtension = false;
                            PublishingExtension publishingExtension = (PublishingExtension)((ExtensionAware)$this$getExtension$iv).getExtensions().getByName(name$iv);
                            if (publishingExtension == null) break block0;
                            project2 = publishingExtension;
                            Project project3 = this.$this_addSigningValidationHelpers;
                            TaskProvider<CheckSigningTask> taskProvider2 = this.$signingTask;
                            Project publishing = project2;
                            boolean bl = false;
                            project3.afterEvaluate(new Action((PublishingExtension)publishing, taskProvider2, project3){
                                final /* synthetic */ PublishingExtension $publishing;
                                final /* synthetic */ TaskProvider<CheckSigningTask> $signingTask;
                                final /* synthetic */ Project $this_addSigningValidationHelpers;
                                {
                                    this.$publishing = $publishing;
                                    this.$signingTask = $signingTask;
                                    this.$this_addSigningValidationHelpers = $receiver;
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void execute(Project it) {
                                    void $this$associateTo$iv$iv;
                                    void $this$associate$iv;
                                    void $this$filterIsInstanceTo$iv$iv;
                                    PublicationContainer publicationContainer = this.$publishing.getPublications();
                                    Intrinsics.checkNotNullExpressionValue((Object)publicationContainer, (String)"publishing.publications");
                                    Iterable $this$filterIsInstance$iv = (Iterable)publicationContainer;
                                    boolean $i$f$filterIsInstance = false;
                                    Iterable iterable = $this$filterIsInstance$iv;
                                    Collection destination$iv$iv = new ArrayList<E>();
                                    boolean $i$f$filterIsInstanceTo22 = false;
                                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                        if (!(element$iv$iv instanceof MavenPublication)) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                                    Project project = this.$this_addSigningValidationHelpers;
                                    boolean $i$f$associate = false;
                                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                                    void $i$f$filterIsInstanceTo22 = $this$associate$iv;
                                    Map destination$iv$iv2 = new LinkedHashMap<K, V>(capacity$iv);
                                    boolean $i$f$associateTo = false;
                                    for (T element$iv$iv : $this$associateTo$iv$iv) {
                                        Map map = destination$iv$iv2;
                                        MavenPublication it2 = (MavenPublication)element$iv$iv;
                                        boolean bl = false;
                                        String string = it2.getName();
                                        TaskContainer taskContainer = project.getTasks();
                                        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"tasks");
                                        TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
                                        boolean $i$f$withType = false;
                                        TaskCollection taskCollection = $this$withType$iv.withType(Sign.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"withType(...)");
                                        StringBuilder stringBuilder = new StringBuilder().append("sign");
                                        String string2 = it2.getName();
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                                        Pair pair = TuplesKt.to((Object)string, (Object)(taskCollection.findByName(stringBuilder.append(CapitalizeDecapitalizeKt.capitalizeAsciiOnly(string2)).append("Publication").toString()) != null ? 1 : 0));
                                        map.put(pair.getFirst(), pair.getSecond());
                                    }
                                    Map publicationSigning = destination$iv$iv2;
                                    this.$signingTask.configure(new Action(publicationSigning){
                                        final /* synthetic */ Map<String, Boolean> $publicationSigning;
                                        {
                                            this.$publicationSigning = $publicationSigning;
                                        }

                                        public final void execute(CheckSigningTask it) {
                                            it.getPublicationNamesWithSigning().set(this.$publicationSigning);
                                        }
                                    });
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    public static final void addPomValidationHelpers(@NotNull Project $this$addPomValidationHelpers) {
        Intrinsics.checkNotNullParameter((Object)$this$addPomValidationHelpers, (String)"<this>");
        $this$addPomValidationHelpers.getProject().getPluginManager().withPlugin("maven-publish", new Action($this$addPomValidationHelpers){
            final /* synthetic */ Project $this_addPomValidationHelpers;
            {
                this.$this_addPomValidationHelpers = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(AppliedPlugin it) {
                block0: {
                    void $this$getExtension$iv;
                    Project project = this.$this_addPomValidationHelpers.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                    Project project2 = project;
                    String name$iv = "publishing";
                    boolean $i$f$getExtension = false;
                    PublishingExtension publishingExtension = (PublishingExtension)((ExtensionAware)$this$getExtension$iv).getExtensions().getByName(name$iv);
                    if (publishingExtension == null) break block0;
                    project2 = publishingExtension;
                    Project project3 = this.$this_addPomValidationHelpers;
                    Project publishing = project2;
                    boolean bl = false;
                    PublicationContainer publicationContainer = publishing.getPublications();
                    Intrinsics.checkNotNullExpressionValue((Object)publicationContainer, (String)"publishing.publications");
                    NamedDomainObjectCollection $this$withType$iv = (NamedDomainObjectCollection)publicationContainer;
                    boolean $i$f$withType = false;
                    NamedDomainObjectCollection namedDomainObjectCollection = $this$withType$iv.withType(MavenPublication.class);
                    Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectCollection, (String)"withType(...)");
                    namedDomainObjectCollection.configureEach(new Action(project3){
                        final /* synthetic */ Project $this_addPomValidationHelpers;
                        {
                            this.$this_addPomValidationHelpers = $receiver;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void execute(MavenPublication publication) {
                            void name$iv;
                            void $this$register$iv;
                            StringBuilder stringBuilder = new StringBuilder();
                            String string = publication.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"publication.name");
                            String capitalizedPublicationName = stringBuilder.append(CapitalizeDecapitalizeKt.capitalizeAsciiOnly(string)).append("Publication").toString();
                            String generatePomTaskName = "generatePomFileFor" + capitalizedPublicationName;
                            TaskContainer taskContainer = this.$this_addPomValidationHelpers.getTasks();
                            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"tasks");
                            TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
                            boolean $i$f$withType22 = false;
                            TaskCollection taskCollection = $this$withType$iv.withType(GenerateMavenPom.class);
                            Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"withType(...)");
                            TaskProvider generatePomTask = taskCollection.named(generatePomTaskName);
                            TaskContainer taskContainer2 = this.$this_addPomValidationHelpers.getProject().getTasks();
                            Intrinsics.checkNotNullExpressionValue((Object)taskContainer2, (String)"project.tasks");
                            $this$withType$iv = taskContainer2;
                            StringBuilder stringBuilder2 = new StringBuilder().append("checkPomFileFor");
                            String string2 = publication.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"publication.name");
                            String $i$f$withType22 = stringBuilder2.append(CapitalizeDecapitalizeKt.capitalizeAsciiOnly(string2)).append("Publication").toString();
                            Function1 configuration$iv = (Function1)new Function1<CheckPomTask, Unit>((TaskProvider<GenerateMavenPom>)generatePomTask){
                                final /* synthetic */ TaskProvider<GenerateMavenPom> $generatePomTask;
                                {
                                    this.$generatePomTask = $generatePomTask;
                                    super(1);
                                }

                                public final void invoke(CheckPomTask $this$register) {
                                    Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                                    Object[] objectArray = new Object[]{this.$generatePomTask};
                                    $this$register.dependsOn(objectArray);
                                    $this$register.setGroup("validation");
                                    $this$register.getPom().set(this.$generatePomTask.map((Transformer)addPomValidationHelpers.1.1.INSTANCE));
                                }
                            };
                            boolean $i$f$register = false;
                            Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register((String)name$iv, CheckPomTask.class, new Action(configuration$iv){
                                private final /* synthetic */ Function1 function;
                                {
                                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                                    this.function = function;
                                }

                                public final /* synthetic */ void execute(Object t) {
                                    this.function.invoke(t);
                                }
                            }), (String)"register(...)");
                        }
                    });
                }
            }
        });
    }

    @NotNull
    public static final String keyIdToHex(long keyId) {
        String string = UStringsKt.toString-JSWoG40((long)ULong.constructor-impl((long)keyId), (int)16).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return StringsKt.padStart((String)string, (int)16, (char)'0');
    }

    private static final Configuration maybeCreateBcConfiguration(Project $this$maybeCreateBcConfiguration) {
        ConfigurationContainer configurationContainer = $this$maybeCreateBcConfiguration.getProject().getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
        return ConfigurationsKt.maybeCreateResolvable(configurationContainer, "kotlinBouncyCastleConfiguration", (Function1<? super Configuration, Unit>)((Function1)new Function1<Configuration, Unit>($this$maybeCreateBcConfiguration){
            final /* synthetic */ Project $this_maybeCreateBcConfiguration;
            {
                this.$this_maybeCreateBcConfiguration = $receiver;
                super(1);
            }

            public final void invoke(Configuration $this$maybeCreateResolvable) {
                ObjectFactory $this$named$iv;
                Intrinsics.checkNotNullParameter((Object)$this$maybeCreateResolvable, (String)"$this$maybeCreateResolvable");
                AttributeContainer attributeContainer = $this$maybeCreateResolvable.getAttributes();
                ObjectFactory objectFactory = this.$this_maybeCreateBcConfiguration.getProject().getObjects();
                Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
                ObjectFactory objectFactory2 = objectFactory;
                String name$iv = "library";
                boolean $i$f$named = false;
                Named named = $this$named$iv.named(Category.class, name$iv);
                Intrinsics.checkNotNullExpressionValue((Object)named, (String)"named(T::class.java, name)");
                attributeContainer.attribute(Category.CATEGORY_ATTRIBUTE, (Object)named);
                AttributeContainer attributeContainer2 = $this$maybeCreateResolvable.getAttributes();
                ObjectFactory objectFactory3 = this.$this_maybeCreateBcConfiguration.getProject().getObjects();
                Intrinsics.checkNotNullExpressionValue((Object)objectFactory3, (String)"project.objects");
                $this$named$iv = objectFactory3;
                name$iv = "java-runtime";
                $i$f$named = false;
                Named named2 = $this$named$iv.named(Usage.class, name$iv);
                Intrinsics.checkNotNullExpressionValue((Object)named2, (String)"named(T::class.java, name)");
                attributeContainer2.attribute(Usage.USAGE_ATTRIBUTE, (Object)named2);
                AttributeContainer attributeContainer3 = $this$maybeCreateResolvable.getAttributes();
                ObjectFactory objectFactory4 = this.$this_maybeCreateBcConfiguration.getProject().getObjects();
                Intrinsics.checkNotNullExpressionValue((Object)objectFactory4, (String)"project.objects");
                $this$named$iv = objectFactory4;
                name$iv = "jar";
                $i$f$named = false;
                Named named3 = $this$named$iv.named(LibraryElements.class, name$iv);
                Intrinsics.checkNotNullExpressionValue((Object)named3, (String)"named(T::class.java, name)");
                attributeContainer3.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)named3);
                $this$maybeCreateResolvable.setDescription("Bouncy Castle dependencies used internally for library publishing validation tasks. Not used during compilation.");
                $this$maybeCreateResolvable.defaultDependencies(new Action(this.$this_maybeCreateBcConfiguration){
                    final /* synthetic */ Project $this_maybeCreateBcConfiguration;
                    {
                        this.$this_maybeCreateBcConfiguration = $receiver;
                    }

                    public final void execute(DependencySet it) {
                        it.add((Object)this.$this_maybeCreateBcConfiguration.getProject().getDependencies().create((Object)"org.bouncycastle:bcpkix-jdk18on:1.80"));
                        it.add((Object)this.$this_maybeCreateBcConfiguration.getProject().getDependencies().create((Object)"org.bouncycastle:bcpg-jdk18on:1.80"));
                    }
                });
            }
        }));
    }

    public static final /* synthetic */ Configuration access$maybeCreateBcConfiguration(Project $receiver) {
        return HelpersKt.maybeCreateBcConfiguration($receiver);
    }
}

