/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks.publishing;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.UsesKotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.tasks.publishing.CheckPomTask;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@CacheableTask
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u000b2\u00020\u00012\u00020\u0002:\u0001\u000bB\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0005R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/publishing/CheckPomTask;", "Lorg/gradle/api/DefaultTask;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/UsesKotlinToolingDiagnostics;", "()V", "pom", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getPom", "()Lorg/gradle/api/provider/Property;", "execute", "", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nCheckPomTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckPomTask.kt\norg/jetbrains/kotlin/gradle/tasks/publishing/CheckPomTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1851#2,2:97\n1851#2,2:99\n*S KotlinDebug\n*F\n+ 1 CheckPomTask.kt\norg/jetbrains/kotlin/gradle/tasks/publishing/CheckPomTask\n*L\n48#1:97,2\n59#1:99,2\n*E\n"})
public abstract class CheckPomTask
extends DefaultTask
implements UsesKotlinToolingDiagnostics {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> requiredPomTags;

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract Property<File> getPom();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    protected final void execute() {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse((File)this.getPom().get());
        doc.getDocumentElement().normalize();
        Node projectTag = doc.getElementsByTagName("project").item(0);
        if (projectTag == null) {
            this.reportDiagnostic(KotlinToolingDiagnostics.PomMisconfigured.INSTANCE.invoke("Couldn't parse pom.xml - <project> tag not found!", "Please double check your publication configuration.", "https://kotl.in/gradle-maven-publish-modifying-pom"));
            return;
        }
        Set missingTags = CollectionsKt.toMutableSet((Iterable)requiredPomTags);
        XPath xPath = XPathFactory.newInstance().newXPath();
        Iterable $this$forEach$iv = requiredPomTags;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String requiredTag = (String)element$iv;
            boolean bl = false;
            Object node2 = xPath.compile("./" + requiredTag).evaluate(projectTag, XPathConstants.NODE);
            if (node2 == null) continue;
            ((Collection)missingTags).remove(requiredTag);
        }
        if (!((Collection)missingTags).isEmpty()) {
            void $this$execute_u24lambda_u242;
            StringBuilder stringBuilder;
            StringBuilder $i$f$forEach2 = stringBuilder = new StringBuilder();
            KotlinToolingDiagnostics.PomMisconfigured pomMisconfigured = KotlinToolingDiagnostics.PomMisconfigured.INSTANCE;
            CheckPomTask checkPomTask = this;
            boolean bl = false;
            StringBuilder stringBuilder2 = $this$execute_u24lambda_u242.append("Missing tags in POM:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            Iterable $this$forEach$iv2 = missingTags;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String missingTag = (String)element$iv;
                boolean bl2 = false;
                void var15_21 = $this$execute_u24lambda_u242;
                String[] stringArray = new String[]{"/"};
                StringBuilder stringBuilder3 = var15_21.append("* " + CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)missingTag, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)" - ", null, null, (int)0, null, (Function1)execute.2.1.1.INSTANCE, (int)30, null));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            }
            StringBuilder stringBuilder4 = $this$execute_u24lambda_u242.append("These tags are required for publication to the Maven Central Repository as described here: https://kotl.in/sonatype-required-pom-metadata");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            Unit unit = Unit.INSTANCE;
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            checkPomTask.reportDiagnostic(pomMisconfigured.invoke(string, "If you're using the 'maven-publish' plugin please refer to the documentation on how to set the required POM values.", "https://kotl.in/gradle-maven-publish-modifying-pom"));
            return;
        }
    }

    @Override
    public void reportDiagnostic(@NotNull ToolingDiagnostic diagnostic) {
        UsesKotlinToolingDiagnostics.DefaultImpls.reportDiagnostic(this, diagnostic);
    }

    static {
        Object[] objectArray = new String[]{"groupId", "artifactId", "version", "name", "description", "url", "licenses", "licenses/license[1]", "licenses/license[1]/name", "licenses/license[1]/url", "developers", "developers/developer[1]", "developers/developer[1]/name", "developers/developer[1]/email", "developers/developer[1]/organization", "developers/developer[1]/organizationUrl", "scm", "scm/connection", "scm/developerConnection", "scm/url"};
        requiredPomTags = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/publishing/CheckPomTask$Companion;", "", "()V", "requiredPomTags", "", "", "getRequiredPomTags", "()Ljava/util/List;", "kotlin-gradle-plugin_common"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getRequiredPomTags() {
            return requiredPomTags;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

