/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.btapi.BuildSessionService;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.fus.BuildUidService;
import org.jetbrains.kotlin.gradle.internal.attributes.KlibPackagingKt;
import org.jetbrains.kotlin.gradle.internal.diagnostics.AgpCompatibilityCheck;
import org.jetbrains.kotlin.gradle.internal.diagnostics.GradleCompatibilityCheck;
import org.jetbrains.kotlin.gradle.internal.diagnostics.KotlinCompilerEmbeddableCheck;
import org.jetbrains.kotlin.gradle.internal.properties.PropertiesBuildService;
import org.jetbrains.kotlin.gradle.plugin.BuildFinishedListenerService;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePlugin;
import org.jetbrains.kotlin.gradle.plugin.KotlinGradleBuildServices;
import org.jetbrains.kotlin.gradle.plugin.KotlinPlatformType;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.gradle.plugin.ProjectLocalConfigurations;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.VariantImplementationFactories;
import org.jetbrains.kotlin.gradle.plugin.VariantImplementationFactoriesConfigurator;
import org.jetbrains.kotlin.gradle.plugin.attributes.KlibPackaging;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.DefaultProblemsReporter;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ProblemsReporter;
import org.jetbrains.kotlin.gradle.plugin.internal.BuildIdentifierAccessor;
import org.jetbrains.kotlin.gradle.plugin.internal.CompatibilityConventionRegistrar;
import org.jetbrains.kotlin.gradle.plugin.internal.ConfigurationCacheStartParameterAccessor;
import org.jetbrains.kotlin.gradle.plugin.internal.CopySpecAccessor;
import org.jetbrains.kotlin.gradle.plugin.internal.DefaultBuildIdentifierAccessor;
import org.jetbrains.kotlin.gradle.plugin.internal.DefaultCompatibilityConventionRegistrar;
import org.jetbrains.kotlin.gradle.plugin.internal.DefaultConfigurationCacheStartParameterAccessorVariantFactory;
import org.jetbrains.kotlin.gradle.plugin.internal.DefaultCopySpecAccessor;
import org.jetbrains.kotlin.gradle.plugin.internal.DefaultJavaExecTaskParametersCompatibility;
import org.jetbrains.kotlin.gradle.plugin.internal.DefaultMavenPublicationComponentAccessorFactory;
import org.jetbrains.kotlin.gradle.plugin.internal.DefaultProjectDependencyAccessor;
import org.jetbrains.kotlin.gradle.plugin.internal.DefaultProjectIsolationStartParameterAccessor;
import org.jetbrains.kotlin.gradle.plugin.internal.JavaExecTaskParametersCompatibility;
import org.jetbrains.kotlin.gradle.plugin.internal.MavenPublicationComponentAccessor;
import org.jetbrains.kotlin.gradle.plugin.internal.ProjectDependencyAccessor;
import org.jetbrains.kotlin.gradle.plugin.internal.ProjectIsolationStartParameterAccessor;
import org.jetbrains.kotlin.gradle.plugin.internal.ProjectIsolationStartParameterAccessorKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinUsages;
import org.jetbrains.kotlin.gradle.plugin.statistics.BuildFinishBuildService;
import org.jetbrains.kotlin.gradle.plugin.statistics.BuildFusService;
import org.jetbrains.kotlin.gradle.report.BuildMetricsService;
import org.jetbrains.kotlin.gradle.targets.js.KotlinJsCompilerAttribute;
import org.jetbrains.kotlin.gradle.targets.js.KotlinWasmTargetAttribute;
import org.jetbrains.kotlin.gradle.targets.native.internal.CInteropCommonizerArtifactTypeAttribute;
import org.jetbrains.kotlin.gradle.targets.native.internal.CInteropKlibLibraryElements;
import org.jetbrains.kotlin.gradle.targets.native.internal.CommonizerTargetAttribute;
import org.jetbrains.kotlin.gradle.targets.native.toolchain.KotlinNativeBundleBuildService;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompileTool;
import org.jetbrains.kotlin.gradle.utils.ConfigurationsKt;
import org.jetbrains.kotlin.gradle.utils.GradleConfigurationUtilsKt;
import org.jetbrains.kotlin.gradle.utils.WhenPluginEnabledKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0004J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u0011\u001a\u00020\u000b*\u00020\rH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/DefaultKotlinBasePlugin;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinBasePlugin;", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "pluginVersion", "", "getPluginVersion", "()Ljava/lang/String;", "addKotlinCompilerConfiguration", "", "project", "Lorg/gradle/api/Project;", "apply", "setupAttributeMatchingStrategy", "whenBuildEvaluated", "registerDefaultVariantImplementations", "kotlin-gradle-plugin_common"})
public abstract class DefaultKotlinBasePlugin
implements KotlinBasePlugin {
    private final Logger logger;
    @NotNull
    private final String pluginVersion;

    public DefaultKotlinBasePlugin() {
        Logger logger2 = this.logger = Logging.getLogger(DefaultKotlinBasePlugin.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
        this.pluginVersion = KotlinPluginWrapperKt.getKotlinPluginVersion(logger2);
    }

    @NotNull
    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public void apply(@NotNull Project project) {
        Configuration configuration2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KotlinCompilerEmbeddableCheck.INSTANCE.checkCompilerEmbeddableInClasspath(project);
        this.registerDefaultVariantImplementations(project);
        GradleCompatibilityCheck.runGradleCompatibilityCheck$default(GradleCompatibilityCheck.INSTANCE, project, null, 1, null);
        AgpCompatibilityCheck.runAgpCompatibilityCheckIfAgpIsApplied$default(AgpCompatibilityCheck.INSTANCE, project, null, 1, null);
        BuildFinishedListenerService.Companion.registerIfAbsent(project);
        BuildSessionService.Companion.registerIfAbsent(project);
        Gradle gradle = project.getGradle();
        Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
        Provider buildUidService = BuildUidService.Companion.registerIfAbsent(gradle);
        Provider<BuildFinishBuildService> buildFinishBuildService = BuildFinishBuildService.Companion.registerIfAbsent(project, (Provider<BuildUidService>)buildUidService, this.getPluginVersion());
        BuildFusService.Companion.registerIfAbsent$kotlin_gradle_plugin_common(project, this.getPluginVersion(), (Provider<BuildUidService>)buildUidService, buildFinishBuildService);
        PropertiesBuildService.Companion.registerIfAbsent(project);
        project.getGradle().projectsEvaluated(new Action(this, project){
            final /* synthetic */ DefaultKotlinBasePlugin this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public final void execute(Gradle it) {
                this.this$0.whenBuildEvaluated(this.$project);
            }
        });
        this.addKotlinCompilerConfiguration(project);
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
        Configuration $this$apply_u24lambda_u240 = configuration2 = ConfigurationsKt.maybeCreateResolvable$default(configurationContainer, "kotlinCompilerPluginClasspath", null, 2, null);
        boolean bl = false;
        $this$apply_u24lambda_u240.setVisible(false);
        GradleConfigurationUtilsKt.addGradlePluginMetadataAttributes($this$apply_u24lambda_u240, project);
        KotlinGradleBuildServices kotlinGradleBuildServices = (KotlinGradleBuildServices)KotlinGradleBuildServices.Companion.registerIfAbsent(project).get();
        if (!ProjectIsolationStartParameterAccessorKt.isProjectIsolationEnabled(project)) {
            kotlinGradleBuildServices.detectKotlinPluginLoadedInMultipleProjects$kotlin_gradle_plugin_common(project, this.getPluginVersion());
        }
        BuildMetricsService.Companion.registerIfAbsent(project);
        KotlinNativeBundleBuildService.Companion.registerIfAbsent(project);
    }

    private final void addKotlinCompilerConfiguration(Project project) {
        Configuration configuration2;
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project\n            .configurations");
        ConfigurationsKt.maybeCreateResolvable$default(configurationContainer, "kotlinCompilerClasspath", null, 2, null).defaultDependencies(new Action(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ DefaultKotlinBasePlugin this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public final void execute(DependencySet it) {
                Object object = PropertiesProvider.Companion.getKotlinPropertiesProvider$kotlin_gradle_plugin_common(this.$project).getRunKotlinCompilerViaBuildToolsApi().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.kotlinProperties\u2026lerViaBuildToolsApi.get()");
                if (((Boolean)object).booleanValue()) {
                    it.add((Object)this.$project.getDependencies().create((Object)("org.jetbrains.kotlin:kotlin-build-tools-compat:" + this.this$0.getPluginVersion())));
                    it.add((Object)this.$project.getDependencies().create((Object)("org.jetbrains.kotlin:kotlin-build-tools-impl:" + this.this$0.getPluginVersion())));
                } else {
                    it.add((Object)this.$project.getDependencies().create((Object)("org.jetbrains.kotlin:kotlin-compiler-embeddable:" + KotlinPluginWrapperKt.getKotlinPluginVersion(this.$project))));
                }
            }
        });
        ConfigurationContainer configurationContainer2 = project.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer2, (String)"project\n            .configurations");
        Configuration it = configuration2 = ConfigurationsKt.maybeCreateResolvable$default(configurationContainer2, "kotlinBuildToolsApiClasspath", null, 2, null);
        boolean bl = false;
        project.getDependencies().add(it.getName(), (Object)("org.jetbrains.kotlin:kotlin-build-tools-compat:" + this.getPluginVersion()));
        project.getDependencies().add(it.getName(), (Object)"org.jetbrains.kotlin:kotlin-build-tools-impl");
        it.withDependencies(new Action(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ DefaultKotlinBasePlugin this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public final void execute(DependencySet dependencies2) {
                Intrinsics.checkNotNullExpressionValue((Object)dependencies2, (String)"dependencies");
                DomainObjectCollection $this$withType$iv = (DomainObjectCollection)dependencies2;
                boolean $i$f$withType = false;
                DomainObjectCollection domainObjectCollection = $this$withType$iv.withType(ExternalDependency.class);
                Intrinsics.checkNotNullExpressionValue((Object)domainObjectCollection, (String)"withType(S::class.java)");
                domainObjectCollection.configureEach(new Action(this.$project, this.this$0){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ DefaultKotlinBasePlugin this$0;
                    {
                        this.$project = $project;
                        this.this$0 = $receiver;
                    }

                    public final void execute(ExternalDependency dependency) {
                        if (Intrinsics.areEqual((Object)dependency.getName(), (Object)"kotlin-build-tools-compat")) {
                            return;
                        }
                        dependency.version(new Action(this.$project, this.this$0){
                            final /* synthetic */ Project $project;
                            final /* synthetic */ DefaultKotlinBasePlugin this$0;
                            {
                                this.$project = $project;
                                this.this$0 = $receiver;
                            }

                            public final void execute(MutableVersionConstraint versionConstraint) {
                                String string;
                                Property<String> property2 = KotlinProjectExtensionKt.getKotlinExtensionOrNull(this.$project);
                                if ((property2 != null && (property2 = property2.getCompilerVersion()) != null ? (String)property2.get() : (string = null)) == null) {
                                    string = this.this$0.getPluginVersion();
                                }
                                versionConstraint.strictly(string);
                            }
                        });
                    }
                });
            }
        });
        project.getTasks().withType(AbstractKotlinCompileTool.class).configureEach(new Action(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final void execute(AbstractKotlinCompileTool<?> task2) {
                Object[] objectArray = new Object[]{new Function0<NamedDomainObjectProvider<Configuration>>(task2, this.$project){
                    final /* synthetic */ AbstractKotlinCompileTool<?> $task;
                    final /* synthetic */ Project $project;
                    {
                        this.$task = $task;
                        this.$project = $project;
                        super(0);
                    }

                    public final NamedDomainObjectProvider<Configuration> invoke() {
                        String string;
                        Boolean bl = (Boolean)this.$task.getRunViaBuildToolsApi$kotlin_gradle_plugin_common().get();
                        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
                            string = "kotlinBuildToolsApiClasspath";
                        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
                            string = "kotlinCompilerClasspath";
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        String classpathConfiguration2 = string;
                        return this.$project.getConfigurations().named(classpathConfiguration2);
                    }
                }};
                task2.getDefaultCompilerClasspath$kotlin_gradle_plugin_common().setFrom(objectArray);
            }
        });
    }

    private final void registerDefaultVariantImplementations(Project $this$registerDefaultVariantImplementations) {
        Gradle gradle = $this$registerDefaultVariantImplementations.getProject().getGradle();
        Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
        VariantImplementationFactoriesConfigurator factories = VariantImplementationFactoriesConfigurator.Companion.get(gradle);
        factories.putIfAbsent(Reflection.getOrCreateKotlinClass(ProblemsReporter.Factory.class), (VariantImplementationFactories.VariantImplementationFactory)new DefaultProblemsReporter.Factory());
        factories.putIfAbsent(Reflection.getOrCreateKotlinClass(ProjectIsolationStartParameterAccessor.Factory.class), (VariantImplementationFactories.VariantImplementationFactory)new DefaultProjectIsolationStartParameterAccessor.Factory());
        factories.putIfAbsent(Reflection.getOrCreateKotlinClass(CompatibilityConventionRegistrar.Factory.class), (VariantImplementationFactories.VariantImplementationFactory)new DefaultCompatibilityConventionRegistrar.Factory());
        factories.putIfAbsent(Reflection.getOrCreateKotlinClass(ConfigurationCacheStartParameterAccessor.Factory.class), (VariantImplementationFactories.VariantImplementationFactory)new DefaultConfigurationCacheStartParameterAccessorVariantFactory());
        factories.putIfAbsent(Reflection.getOrCreateKotlinClass(MavenPublicationComponentAccessor.Factory.class), (VariantImplementationFactories.VariantImplementationFactory)new DefaultMavenPublicationComponentAccessorFactory());
        factories.putIfAbsent(Reflection.getOrCreateKotlinClass(JavaExecTaskParametersCompatibility.Factory.class), (VariantImplementationFactories.VariantImplementationFactory)new DefaultJavaExecTaskParametersCompatibility.Factory());
        factories.putIfAbsent(Reflection.getOrCreateKotlinClass(CopySpecAccessor.Factory.class), (VariantImplementationFactories.VariantImplementationFactory)new DefaultCopySpecAccessor.Factory());
        factories.putIfAbsent(Reflection.getOrCreateKotlinClass(BuildIdentifierAccessor.Factory.class), (VariantImplementationFactories.VariantImplementationFactory)new DefaultBuildIdentifierAccessor.Factory());
        factories.putIfAbsent(Reflection.getOrCreateKotlinClass(ProjectDependencyAccessor.Factory.class), (VariantImplementationFactories.VariantImplementationFactory)new DefaultProjectDependencyAccessor.Factory());
    }

    protected final void setupAttributeMatchingStrategy(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AttributesSchema $this$setupAttributeMatchingStrategy_u24lambda_u242 = project.getDependencies().getAttributesSchema();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$setupAttributeMatchingStrategy_u24lambda_u242, (String)"this");
        KotlinPlatformType.Companion.setupAttributesMatchingStrategy($this$setupAttributeMatchingStrategy_u24lambda_u242);
        KotlinUsages.INSTANCE.setupAttributesMatchingStrategy$kotlin_gradle_plugin_common($this$setupAttributeMatchingStrategy_u24lambda_u242);
        ProjectLocalConfigurations.INSTANCE.setupAttributesMatchingStrategy($this$setupAttributeMatchingStrategy_u24lambda_u242);
        WhenPluginEnabledKt.whenJsOrMppEnabled(project, (Function0<Unit>)((Function0)new Function0<Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                AttributesSchema attributesSchema = this.$project.getDependencies().getAttributesSchema();
                Intrinsics.checkNotNullExpressionValue((Object)attributesSchema, (String)"project.dependencies.attributesSchema");
                KotlinJsCompilerAttribute.Companion.setupAttributesMatchingStrategy(attributesSchema);
                AttributesSchema attributesSchema2 = this.$project.getDependencies().getAttributesSchema();
                Intrinsics.checkNotNullExpressionValue((Object)attributesSchema2, (String)"project.dependencies.attributesSchema");
                KotlinWasmTargetAttribute.Companion.setupAttributesMatchingStrategy(attributesSchema2);
                if (PropertiesProvider.Companion.getKotlinPropertiesProvider$kotlin_gradle_plugin_common(this.$project).getUseNonPackedKlibs()) {
                    AttributesSchema attributesSchema3 = this.$project.getDependencies().getAttributesSchema();
                    Intrinsics.checkNotNullExpressionValue((Object)attributesSchema3, (String)"project.dependencies.attributesSchema");
                    KlibPackagingKt.setupAttributesMatchingStrategy(KlibPackaging.Companion, attributesSchema3);
                }
            }
        }));
        WhenPluginEnabledKt.whenMppEnabled(project, (Function0<Unit>)((Function0)new Function0<Unit>($this$setupAttributeMatchingStrategy_u24lambda_u242, project){
            final /* synthetic */ AttributesSchema $this_with;
            final /* synthetic */ Project $project;
            {
                this.$this_with = $receiver;
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                AttributesSchema attributesSchema = this.$this_with;
                Intrinsics.checkNotNullExpressionValue((Object)attributesSchema, (String)"this");
                CInteropKlibLibraryElements.INSTANCE.setupAttributesMatchingStrategy(attributesSchema);
                AttributesSchema attributesSchema2 = this.$this_with;
                Intrinsics.checkNotNullExpressionValue((Object)attributesSchema2, (String)"this");
                CommonizerTargetAttribute.INSTANCE.setupAttributesMatchingStrategy(attributesSchema2);
                CInteropCommonizerArtifactTypeAttribute.INSTANCE.setupTransform(this.$project);
            }
        }));
    }

    public void whenBuildEvaluated(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }
}

