/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.logging;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.GradleStyleMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.gradle.logging.GradleKotlinLogger;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\"\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/logging/GradlePrintingMessageCollector;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "logger", "Lorg/gradle/api/logging/Logger;", "allWarningsAsErrors", "", "(Lorg/gradle/api/logging/Logger;Z)V", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "(Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;Z)V", "hasErrors", "getLogger", "()Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "messageRenderer", "Lorg/jetbrains/kotlin/cli/common/messages/GradleStyleMessageRenderer;", "clear", "", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "kotlin-gradle-plugin_common"})
public final class GradlePrintingMessageCollector
implements MessageCollector {
    @NotNull
    private final KotlinLogger logger;
    private final boolean allWarningsAsErrors;
    private boolean hasErrors;
    @NotNull
    private final GradleStyleMessageRenderer messageRenderer;

    public GradlePrintingMessageCollector(@NotNull KotlinLogger logger2, boolean allWarningsAsErrors) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.logger = logger2;
        this.allWarningsAsErrors = allWarningsAsErrors;
        this.messageRenderer = new GradleStyleMessageRenderer();
    }

    @NotNull
    public final KotlinLogger getLogger() {
        return this.logger;
    }

    public GradlePrintingMessageCollector(@NotNull Logger logger2, boolean allWarningsAsErrors) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this(new GradleKotlinLogger(logger2, null, false, 6, null), allWarningsAsErrors);
    }

    @Override
    public boolean hasErrors() {
        return this.hasErrors;
    }

    @Override
    public void clear() {
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        String renderedMessage = this.messageRenderer.render(severity, message2, location);
        switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1: 
            case 2: {
                this.hasErrors = true;
                KotlinLogger.error$default((KotlinLogger)this.logger, (String)renderedMessage, null, (int)2, null);
                break;
            }
            case 3: 
            case 4: {
                if (this.allWarningsAsErrors) {
                    KotlinLogger.error$default((KotlinLogger)this.logger, (String)renderedMessage, null, (int)2, null);
                    break;
                }
                this.logger.warn(renderedMessage);
                break;
            }
            case 5: {
                this.logger.warn(renderedMessage);
                break;
            }
            case 6: {
                this.logger.info(renderedMessage);
                break;
            }
            case 7: 
            case 8: {
                this.logger.debug(renderedMessage);
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompilerMessageSeverity.values().length];
            try {
                nArray[CompilerMessageSeverity.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.EXCEPTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.STRONG_WARNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.FIXED_WARNING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.INFO.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.LOGGING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.OUTPUT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

