/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.graph;

import java.util.Map;
import javax.annotation.CheckForNull;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.graph.MapIteratorCache;

@ElementTypesAreNonnullByDefault
final class MapRetrievalCache<K, V>
extends MapIteratorCache<K, V> {
    @CheckForNull
    private volatile transient CacheEntry<K, V> cacheEntry1;
    @CheckForNull
    private volatile transient CacheEntry<K, V> cacheEntry2;

    MapRetrievalCache(Map<K, V> backingMap) {
        super(backingMap);
    }

    @Override
    @CheckForNull
    V get(Object key) {
        Preconditions.checkNotNull(key);
        V value2 = this.getIfCached(key);
        if (value2 != null) {
            return value2;
        }
        value2 = this.getWithoutCaching(key);
        if (value2 != null) {
            this.addToCache(key, value2);
        }
        return value2;
    }

    @Override
    @CheckForNull
    V getIfCached(@CheckForNull Object key) {
        Object value2 = super.getIfCached(key);
        if (value2 != null) {
            return value2;
        }
        CacheEntry<K, V> entry2 = this.cacheEntry1;
        if (entry2 != null && entry2.key == key) {
            return entry2.value;
        }
        entry2 = this.cacheEntry2;
        if (entry2 != null && entry2.key == key) {
            this.addToCache(entry2);
            return entry2.value;
        }
        return null;
    }

    @Override
    void clearCache() {
        super.clearCache();
        this.cacheEntry1 = null;
        this.cacheEntry2 = null;
    }

    private void addToCache(K key, V value2) {
        this.addToCache(new CacheEntry<K, V>(key, value2));
    }

    private void addToCache(CacheEntry<K, V> entry2) {
        this.cacheEntry2 = this.cacheEntry1;
        this.cacheEntry1 = entry2;
    }

    private static final class CacheEntry<K, V> {
        final K key;
        final V value;

        CacheEntry(K key, V value2) {
            this.key = key;
            this.value = value2;
        }
    }
}

