/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.descriptors.java;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.gradle.internal.descriptors.Visibilities;
import org.jetbrains.kotlin.gradle.internal.descriptors.Visibility;
import org.jetbrains.kotlin.gradle.internal.name.FqName;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/descriptors/java/JavaVisibilities;", "", "<init>", "()V", "PackageVisibility", "ProtectedStaticVisibility", "ProtectedAndPackage", "compiler.common.jvm"})
public final class JavaVisibilities {
    @NotNull
    public static final JavaVisibilities INSTANCE = new JavaVisibilities();

    private JavaVisibilities() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0016\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u0001H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/descriptors/java/JavaVisibilities$PackageVisibility;", "Lorg/jetbrains/kotlin/gradle/internal/descriptors/Visibility;", "<init>", "()V", "mustCheckInImports", "", "compareTo", "", "visibility", "(Lorg/jetbrains/kotlin/descriptors/Visibility;)Ljava/lang/Integer;", "normalize", "internalDisplayName", "", "getInternalDisplayName", "()Ljava/lang/String;", "externalDisplayName", "getExternalDisplayName", "customEffectiveVisibility", "Lorg/jetbrains/kotlin/gradle/internal/descriptors/EffectiveVisibility;", "visibleFromPackage", "fromPackage", "Lorg/jetbrains/kotlin/gradle/internal/name/FqName;", "myPackage", "compiler.common.jvm"})
    public static final class PackageVisibility
    extends Visibility {
        @NotNull
        public static final PackageVisibility INSTANCE = new PackageVisibility();

        private PackageVisibility() {
            super("package", false);
        }

        @Override
        public boolean mustCheckInImports() {
            return true;
        }

        @Override
        @Nullable
        public Integer compareTo(@NotNull Visibility visibility) {
            Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
            if (this == visibility) {
                return 0;
            }
            if (Visibilities.INSTANCE.isPrivate(visibility)) {
                return 1;
            }
            return -1;
        }

        @Override
        @NotNull
        public Visibility normalize() {
            return Visibilities.Protected.INSTANCE;
        }

        @Override
        @NotNull
        public String getInternalDisplayName() {
            return "public/*package*/";
        }

        @Override
        @NotNull
        public String getExternalDisplayName() {
            return "package-private";
        }

        @Override
        @Nullable
        public EffectiveVisibility customEffectiveVisibility() {
            return EffectiveVisibility.PackagePrivate.INSTANCE;
        }

        @Override
        public boolean visibleFromPackage(@NotNull FqName fromPackage, @NotNull FqName myPackage) {
            Intrinsics.checkNotNullParameter((Object)fromPackage, (String)"fromPackage");
            Intrinsics.checkNotNullParameter((Object)myPackage, (String)"myPackage");
            return Intrinsics.areEqual((Object)fromPackage, (Object)myPackage);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0016\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0001H\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/descriptors/java/JavaVisibilities$ProtectedAndPackage;", "Lorg/jetbrains/kotlin/gradle/internal/descriptors/Visibility;", "<init>", "()V", "compareTo", "", "visibility", "(Lorg/jetbrains/kotlin/descriptors/Visibility;)Ljava/lang/Integer;", "normalize", "mustCheckInImports", "", "internalDisplayName", "", "getInternalDisplayName", "()Ljava/lang/String;", "externalDisplayName", "getExternalDisplayName", "compiler.common.jvm"})
    public static final class ProtectedAndPackage
    extends Visibility {
        @NotNull
        public static final ProtectedAndPackage INSTANCE = new ProtectedAndPackage();

        private ProtectedAndPackage() {
            super("protected_and_package", true);
        }

        @Override
        @Nullable
        public Integer compareTo(@NotNull Visibility visibility) {
            Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
            if (Intrinsics.areEqual((Object)this, (Object)visibility)) {
                return 0;
            }
            if (visibility == Visibilities.Internal.INSTANCE) {
                return null;
            }
            return Visibilities.INSTANCE.isPrivate(visibility) ? Integer.valueOf(1) : Integer.valueOf(-1);
        }

        @Override
        @NotNull
        public Visibility normalize() {
            return Visibilities.Protected.INSTANCE;
        }

        @Override
        public boolean mustCheckInImports() {
            return false;
        }

        @Override
        @NotNull
        public String getInternalDisplayName() {
            return "protected/*protected and package*/";
        }

        @Override
        @NotNull
        public String getExternalDisplayName() {
            return "protected";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0001H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/descriptors/java/JavaVisibilities$ProtectedStaticVisibility;", "Lorg/jetbrains/kotlin/gradle/internal/descriptors/Visibility;", "<init>", "()V", "mustCheckInImports", "", "normalize", "internalDisplayName", "", "getInternalDisplayName", "()Ljava/lang/String;", "externalDisplayName", "getExternalDisplayName", "compiler.common.jvm"})
    public static final class ProtectedStaticVisibility
    extends Visibility {
        @NotNull
        public static final ProtectedStaticVisibility INSTANCE = new ProtectedStaticVisibility();

        private ProtectedStaticVisibility() {
            super("protected_static", true);
        }

        @Override
        public boolean mustCheckInImports() {
            return false;
        }

        @Override
        @NotNull
        public Visibility normalize() {
            return Visibilities.Protected.INSTANCE;
        }

        @Override
        @NotNull
        public String getInternalDisplayName() {
            return "protected/*protected static*/";
        }

        @Override
        @NotNull
        public String getExternalDisplayName() {
            return "protected";
        }
    }
}

