/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.DefaultDiagnosticReporter;
import org.jetbrains.kotlin.cli.common.messages.DiagnosticMessageReporter;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.GenericDiagnostics;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.fir.builder.FirSyntaxErrors;
import org.jetbrains.kotlin.gradle.internal.analyzer.AbstractAnalyzerWithCompilerReport;
import org.jetbrains.kotlin.gradle.internal.analyzer.AnalysisResult;
import org.jetbrains.kotlin.gradle.internal.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.gradle.internal.config.CompilerConfiguration;
import org.jetbrains.kotlin.gradle.internal.config.LanguageVersionSettings;
import org.jetbrains.kotlin.gradle.internal.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.gradle.internal.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.gradle.internal.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.gradle.internal.load.java.components.TraceBasedErrorReporter;
import org.jetbrains.kotlin.gradle.internal.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.gradle.internal.resolve.BindingContext;
import org.jetbrains.kotlin.gradle.internal.resolve.CompilerEnvironment;
import org.jetbrains.kotlin.gradle.internal.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.gradle.internal.resolve.DescriptorUtils;
import org.jetbrains.kotlin.gradle.internal.resolve.TargetEnvironment;
import org.jetbrains.kotlin.gradle.internal.resolve.checkers.OptInUsageChecker;
import org.jetbrains.kotlin.gradle.internal.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.gradle.internal.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.gradle.internal.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(k=1, mv={2, 2, 0}, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 *2\u00020\u0001:\u0003+,*B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u001d\u0010\u0014\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J+\u0010\u001b\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001eR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001fR\u0014\u0010#\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\"\u0010$\u001a\u00020\u00198\u0016@\u0016X\u0096.\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport;", "Lorg/jetbrains/kotlin/gradle/internal/analyzer/AbstractAnalyzerWithCompilerReport;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "messageCollector", "Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersionSettings;", "languageVersionSettings", "", "renderDiagnosticName", "<init>", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Z)V", "Lorg/jetbrains/kotlin/gradle/internal/config/CompilerConfiguration;", "configuration", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "", "reportIncompleteHierarchies", "()V", "reportAlternativeSignatureErrors", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "files", "reportSyntaxErrors", "(Ljava/util/Collection;)V", "hasErrors", "()Z", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/gradle/internal/analyzer/AnalysisResult;", "analyze", "analyzeAndReport", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function0;)V", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersionSettings;", "Z", "Lorg/jetbrains/kotlin/gradle/internal/resolve/TargetEnvironment;", "getTargetEnvironment", "()Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "targetEnvironment", "analysisResult", "Lorg/jetbrains/kotlin/gradle/internal/analyzer/AnalysisResult;", "getAnalysisResult", "()Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "setAnalysisResult", "(Lorg/jetbrains/kotlin/analyzer/AnalysisResult;)V", "Companion", "SyntaxErrorReport", "MyDiagnostic", "cli"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
public final class AnalyzerWithCompilerReport
implements AbstractAnalyzerWithCompilerReport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageCollector messageCollector;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    private final boolean renderDiagnosticName;
    public AnalysisResult analysisResult;
    @NotNull
    private static final DiagnosticFactory0<PsiErrorElement> SYNTAX_ERROR_FACTORY;

    public AnalyzerWithCompilerReport(@NotNull MessageCollector messageCollector, @NotNull LanguageVersionSettings languageVersionSettings, boolean renderDiagnosticName) {
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.messageCollector = messageCollector;
        this.languageVersionSettings = languageVersionSettings;
        this.renderDiagnosticName = renderDiagnosticName;
    }

    @NotNull
    public TargetEnvironment getTargetEnvironment() {
        return (TargetEnvironment)CompilerEnvironment.INSTANCE;
    }

    @NotNull
    public AnalysisResult getAnalysisResult() {
        AnalysisResult analysisResult = this.analysisResult;
        if (analysisResult != null) {
            return analysisResult;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"analysisResult");
        return null;
    }

    public void setAnalysisResult(@NotNull AnalysisResult analysisResult) {
        Intrinsics.checkNotNullParameter((Object)analysisResult, (String)"<set-?>");
        this.analysisResult = analysisResult;
    }

    public AnalyzerWithCompilerReport(@NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        this(CommonConfigurationKeysKt.getMessageCollector(configuration2), CommonConfigurationKeysKt.getLanguageVersionSettings(configuration2), configuration2.getBoolean(CLIConfigurationKeys.RENDER_DIAGNOSTIC_INTERNAL_NAME));
    }

    private final void reportIncompleteHierarchies() {
        BindingContext bindingContext = this.getAnalysisResult().getBindingContext();
        Collection collection = bindingContext.getKeys(TraceBasedErrorReporter.INCOMPLETE_HIERARCHY);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getKeys(...)");
        Collection classes = collection;
        if (!classes.isEmpty()) {
            StringBuilder message2 = new StringBuilder("Supertypes of the following classes cannot be resolved. Please make sure you have the required dependencies in the classpath:\n");
            for (ClassDescriptor descriptor2 : classes) {
                boolean bl;
                String fqName = DescriptorUtils.getFqName(descriptor2).asString();
                List unresolved = (List)bindingContext.get((ReadOnlySlice)TraceBasedErrorReporter.INCOMPLETE_HIERARCHY, (Object)descriptor2);
                boolean bl2 = bl = unresolved != null && !unresolved.isEmpty();
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "Incomplete hierarchy should be reported with names of unresolved superclasses: " + fqName;
                    throw new AssertionError((Object)string);
                }
                StringBuilder stringBuilder = message2.append("    class ").append(fqName).append(", unresolved supertypes: ");
                List list = unresolved;
                Intrinsics.checkNotNull((Object)list);
                stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null)).append("\n");
            }
            String string = message2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            MessageCollector.report$default(this.messageCollector, CompilerMessageSeverity.ERROR, string, null, 4, null);
        }
    }

    private final void reportAlternativeSignatureErrors() {
        BindingContext bc = this.getAnalysisResult().getBindingContext();
        Collection collection = bc.getKeys(JvmBindingContextSlices.LOAD_FROM_JAVA_SIGNATURE_ERRORS);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getKeys(...)");
        Collection descriptorsWithErrors = collection;
        if (!descriptorsWithErrors.isEmpty()) {
            StringBuilder message2 = new StringBuilder("The following Java entities have annotations with wrong Kotlin signatures:\n");
            for (DeclarationDescriptor descriptor2 : descriptorsWithErrors) {
                boolean bl;
                Intrinsics.checkNotNull((Object)descriptor2);
                PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)descriptor2);
                boolean bl2 = declaration instanceof PsiModifierListOwner;
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                List errors = (List)bc.get((ReadOnlySlice)JvmBindingContextSlices.LOAD_FROM_JAVA_SIGNATURE_ERRORS, (Object)descriptor2);
                boolean bl3 = bl = errors != null && !errors.isEmpty();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                Intrinsics.checkNotNull((Object)declaration, (String)"null cannot be cast to non-null type com.intellij.psi.PsiModifierListOwner");
                String externalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)((PsiModifierListOwner)declaration));
                message2.append(externalName).append(":\n");
                List list = errors;
                Intrinsics.checkNotNull((Object)list);
                for (String error : list) {
                    message2.append("    ").append(error).append("\n");
                }
            }
            String string = message2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            MessageCollector.report$default(this.messageCollector, CompilerMessageSeverity.ERROR, string, null, 4, null);
        }
    }

    private final void reportSyntaxErrors(Collection<? extends KtFile> files2) {
        for (KtFile ktFile : files2) {
            Companion.reportSyntaxErrors((PsiElement)ktFile, this.messageCollector);
        }
    }

    public boolean hasErrors() {
        return this.messageCollector.hasErrors();
    }

    public void analyzeAndReport(@NotNull Collection<? extends KtFile> files2, @NotNull Function0<? extends AnalysisResult> analyze2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter(analyze2, (String)"analyze");
        this.setAnalysisResult((AnalysisResult)analyze2.invoke());
        if (!this.getAnalysisResult().isError()) {
            OptInUsageChecker.Companion.checkCompilerArguments(this.getAnalysisResult().getModuleDescriptor(), this.languageVersionSettings, arg_0 -> AnalyzerWithCompilerReport.analyzeAndReport$lambda$0(this, arg_0), arg_0 -> AnalyzerWithCompilerReport.analyzeAndReport$lambda$1(this, arg_0));
        }
        this.reportSyntaxErrors(files2);
        Diagnostics diagnostics2 = this.getAnalysisResult().getBindingContext().getDiagnostics();
        Intrinsics.checkNotNullExpressionValue((Object)diagnostics2, (String)"getDiagnostics(...)");
        Companion.reportDiagnostics((GenericDiagnostics)diagnostics2, this.messageCollector, this.renderDiagnosticName);
        this.reportIncompleteHierarchies();
        this.reportAlternativeSignatureErrors();
    }

    private static final Unit analyzeAndReport$lambda$0(AnalyzerWithCompilerReport this$0, String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        MessageCollector.report$default(this$0.messageCollector, CompilerMessageSeverity.ERROR, message2, null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit analyzeAndReport$lambda$1(AnalyzerWithCompilerReport this$0, String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        MessageCollector.report$default(this$0.messageCollector, CompilerMessageSeverity.WARNING, message2, null, 4, null);
        return Unit.INSTANCE;
    }

    static {
        DiagnosticFactory0 diagnosticFactory0 = DiagnosticFactory0.create((Severity)Severity.ERROR);
        Intrinsics.checkNotNullExpressionValue((Object)diagnosticFactory0, (String)"create(...)");
        SYNTAX_ERROR_FACTORY = diagnosticFactory0;
    }

    @Metadata(k=1, mv={2, 2, 0}, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J)\u0010\u0013\u001a\u00020\r2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0014J)\u0010\u0013\u001a\u00020\r2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0019J-\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001d\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020 2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b#\u0010$J\u001d\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020 2\u0006\u0010&\u001a\u00020%\u00a2\u0006\u0004\b#\u0010'J@\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020 2'\u0010.\u001a#\u0012\u0004\u0012\u00020)\u0012\u0013\u0012\u00110*\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(-\u0012\u0004\u0012\u00020\u001d0(H\u0002\u00a2\u0006\u0004\b#\u0010/J\u001d\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b#\u00100R\"\u00103\u001a\u0010\u0012\f\u0012\n 2*\u0004\u0018\u00010)0)018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "convertSeverity", "(Lorg/jetbrains/kotlin/diagnostics/Severity;)Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "diagnostic", "Lorg/jetbrains/kotlin/cli/common/messages/DiagnosticMessageReporter;", "reporter", "", "renderDiagnosticName", "reportDiagnostic", "(Lorg/jetbrains/kotlin/diagnostics/Diagnostic;Lorg/jetbrains/kotlin/cli/common/messages/DiagnosticMessageReporter;Z)Z", "Lorg/jetbrains/kotlin/diagnostics/GenericDiagnostics;", "unsortedDiagnostics", "reportDiagnostics", "(Lorg/jetbrains/kotlin/diagnostics/GenericDiagnostics;Lorg/jetbrains/kotlin/cli/common/messages/DiagnosticMessageReporter;Z)Z", "diagnostics", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "messageCollector", "renderInternalDiagnosticName", "(Lorg/jetbrains/kotlin/diagnostics/GenericDiagnostics;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Z)Z", "hasIncompatibleClasses", "hasPrereleaseClasses", "hasUnstableClasses", "", "reportSpecialErrors", "(ZZZLorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$SyntaxErrorReport;", "reportSyntaxErrors", "(Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/cli/common/messages/DiagnosticMessageReporter;)Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$SyntaxErrorReport;", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;", "diagnosticCollector", "(Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;)Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$SyntaxErrorReport;", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiErrorElement;", "", "Lkotlin/ParameterName;", "name", "message", "createAndReportSyntaxError", "(Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$SyntaxErrorReport;", "(Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$SyntaxErrorReport;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "kotlin.jvm.PlatformType", "SYNTAX_ERROR_FACTORY", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "cli"}, xi=48)
    @Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
    @SourceDebugExtension(value={"SMAP\nAnalyzerWithCompilerReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzerWithCompilerReport.kt\norg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,296:1\n811#2,12:297\n1806#2,3:309\n1806#2,3:312\n1806#2,3:315\n*S KotlinDebug\n*F\n+ 1 AnalyzerWithCompilerReport.kt\norg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion\n*L\n168#1:297,12\n182#1:309,3\n183#1:312,3\n184#1:315,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CompilerMessageSeverity convertSeverity(@NotNull Severity severity) {
            CompilerMessageSeverity compilerMessageSeverity;
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                case 1: {
                    compilerMessageSeverity = CompilerMessageSeverity.INFO;
                    break;
                }
                case 2: {
                    compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                    break;
                }
                case 3: {
                    compilerMessageSeverity = CompilerMessageSeverity.WARNING;
                    break;
                }
                case 4: {
                    compilerMessageSeverity = CompilerMessageSeverity.FIXED_WARNING;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return compilerMessageSeverity;
        }

        private final boolean reportDiagnostic(Diagnostic diagnostic, DiagnosticMessageReporter reporter, boolean renderDiagnosticName) {
            Object object;
            if (!diagnostic.isValid()) {
                return false;
            }
            Object object2 = diagnostic instanceof MyDiagnostic ? (MyDiagnostic)diagnostic : null;
            if (object2 == null || (object2 = object2.getMessage()) == null) {
                String string = DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)diagnostic));
                object2 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render(...)");
            }
            Object message2 = object2;
            boolean bl = renderDiagnosticName;
            if (bl) {
                object = '[' + diagnostic.getFactoryName() + "] " + (String)message2;
            } else if (!bl) {
                object = message2;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Object textToRender = object;
            reporter.report(diagnostic, diagnostic.getPsiFile(), (String)textToRender);
            return diagnostic.getSeverity() == Severity.ERROR;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean reportDiagnostics(@NotNull GenericDiagnostics<?> unsortedDiagnostics, @NotNull DiagnosticMessageReporter reporter, boolean renderDiagnosticName) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter(unsortedDiagnostics, (String)"unsortedDiagnostics");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            boolean hasErrors = false;
            Iterable $this$filterIsInstance$iv = unsortedDiagnostics.all();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Diagnostic)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = DiagnosticUtils.sortedDiagnostics((Collection)((List)destination$iv$iv));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sortedDiagnostics(...)");
            List diagnostics2 = list;
            for (Diagnostic diagnostic : diagnostics2) {
                Intrinsics.checkNotNull((Object)diagnostic);
                hasErrors |= this.reportDiagnostic(diagnostic, reporter, renderDiagnosticName);
            }
            return hasErrors;
        }

        public final boolean reportDiagnostics(@NotNull GenericDiagnostics<?> diagnostics2, @NotNull MessageCollector messageCollector, boolean renderInternalDiagnosticName) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            Companion companion;
            boolean bl4;
            block11: {
                boolean bl5;
                UnboundDiagnostic it;
                Iterable $this$any$iv;
                boolean $i$f$any;
                block10: {
                    boolean bl6;
                    block9: {
                        Intrinsics.checkNotNullParameter(diagnostics2, (String)"diagnostics");
                        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
                        boolean it2 = bl4 = this.reportDiagnostics(diagnostics2, new DefaultDiagnosticReporter(messageCollector), renderInternalDiagnosticName);
                        boolean bl7 = false;
                        Iterable iterable = (Iterable)diagnostics2;
                        companion = Companion;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl6 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (UnboundDiagnostic)element$iv;
                                boolean bl8 = false;
                                if (!Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.INCOMPATIBLE_CLASS)) continue;
                                bl6 = true;
                                break block9;
                            }
                            bl6 = false;
                        }
                    }
                    bl3 = bl6;
                    $this$any$iv = (Iterable)diagnostics2;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl5 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (UnboundDiagnostic)element$iv;
                            boolean bl9 = false;
                            if (!Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.PRE_RELEASE_CLASS)) continue;
                            bl5 = true;
                            break block10;
                        }
                        bl5 = false;
                    }
                }
                bl2 = bl5;
                $this$any$iv = (Iterable)diagnostics2;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (UnboundDiagnostic)element$iv;
                        boolean bl10 = false;
                        if (!Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.IR_WITH_UNSTABLE_ABI_COMPILED_CLASS)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            boolean bl11 = bl;
            companion.reportSpecialErrors(bl3, bl2, bl11, messageCollector);
            return bl4;
        }

        public final void reportSpecialErrors(boolean hasIncompatibleClasses, boolean hasPrereleaseClasses, boolean hasUnstableClasses, @NotNull MessageCollector messageCollector) {
            Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
            if (hasIncompatibleClasses) {
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Incompatible classes were found in dependencies. Remove them from the classpath or use '-Xskip-metadata-version-check' to suppress errors", null, 4, null);
            }
            if (hasPrereleaseClasses) {
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Pre-release declarations were found in dependencies. Please exclude the dependencies with such declarations and recompile with a release compiler, or use '-Xskip-prerelease-check' to suppress errors. Note that in the latter case the compiled declarations will also be marked as pre-release.", null, 4, null);
            }
            if (hasUnstableClasses) {
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Classes compiled by an unstable version of the Kotlin compiler were found in dependencies. Remove them from the classpath or use '-Xallow-unstable-dependencies' to suppress errors", null, 4, null);
            }
        }

        @NotNull
        public final SyntaxErrorReport reportSyntaxErrors(@NotNull PsiElement file2, @NotNull DiagnosticMessageReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            return this.reportSyntaxErrors(file2, (Function2<? super PsiErrorElement, ? super String, Unit>)((Function2)(arg_0, arg_1) -> Companion.reportSyntaxErrors$lambda$0(reporter, arg_0, arg_1)));
        }

        @NotNull
        public final SyntaxErrorReport reportSyntaxErrors(@NotNull PsiElement file2, @NotNull BaseDiagnosticsCollector diagnosticCollector) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)diagnosticCollector, (String)"diagnosticCollector");
            return this.reportSyntaxErrors(file2, (Function2<? super PsiErrorElement, ? super String, Unit>)((Function2)(arg_0, arg_1) -> Companion.reportSyntaxErrors$lambda$1(diagnosticCollector, file2, arg_0, arg_1)));
        }

        private final SyntaxErrorReport reportSyntaxErrors(PsiElement file2, Function2<? super PsiErrorElement, ? super String, Unit> createAndReportSyntaxError) {
            @Metadata(k=1, mv={2, 2, 0}, d1={"\u0000'\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f*\u0001\u0000\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\u00020\u0005*\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012\u00a8\u0006\u0016"}, d2={"org/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$Companion$reportSyntaxErrors$ErrorReportingVisitor", "Lorg/jetbrains/kotlin/gradle/internal/resolve/AnalyzingUtils$PsiErrorElementVisitor;", "<init>", "(Lkotlin/jvm/functions/Function2;)V", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "", "isAtEof", "(Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;)Z", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiErrorElement;", "element", "", "visitErrorElement", "(Lorg/jetbrains/kotlin/com/intellij/psi/PsiErrorElement;)V", "hasErrors", "Z", "getHasErrors", "()Z", "setHasErrors", "(Z)V", "allErrorsAtEof", "getAllErrorsAtEof", "setAllErrorsAtEof", "cli"}, xi=48)
            @Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
            public final class ErrorReportingVisitor
            extends AnalyzingUtils.PsiErrorElementVisitor {
                private boolean hasErrors;
                private boolean allErrorsAtEof;
                final /* synthetic */ Function2<PsiErrorElement, String, Unit> $createAndReportSyntaxError;

                public ErrorReportingVisitor(Function2<? super PsiErrorElement, ? super String, Unit> $createAndReportSyntaxError) {
                    this.$createAndReportSyntaxError = $createAndReportSyntaxError;
                    this.allErrorsAtEof = true;
                }

                public final boolean getHasErrors() {
                    return this.hasErrors;
                }

                public final void setHasErrors(boolean bl) {
                    this.hasErrors = bl;
                }

                public final boolean getAllErrorsAtEof() {
                    return this.allErrorsAtEof;
                }

                public final void setAllErrorsAtEof(boolean bl) {
                    this.allErrorsAtEof = bl;
                }

                private final boolean isAtEof(PsiElement $this$isAtEof) {
                    PsiElement element = $this$isAtEof;
                    do {
                        if (element.getNextSibling() != null) continue;
                        return true;
                    } while (element instanceof PsiWhiteSpace && element instanceof PsiComment);
                    return false;
                }

                public void visitErrorElement(PsiErrorElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    String string = element.getErrorDescription();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getErrorDescription(...)");
                    String description2 = string;
                    if (this.allErrorsAtEof && !this.isAtEof((PsiElement)element)) {
                        this.allErrorsAtEof = false;
                    }
                    this.hasErrors = true;
                    this.$createAndReportSyntaxError.invoke((Object)element, (Object)(StringUtil.isEmpty((String)description2) ? "Syntax error" : description2));
                }
            }
            ErrorReportingVisitor visitor2 = new ErrorReportingVisitor(createAndReportSyntaxError);
            file2.accept((PsiElementVisitor)visitor2);
            return new SyntaxErrorReport(visitor2.getHasErrors(), visitor2.getAllErrorsAtEof());
        }

        @NotNull
        public final SyntaxErrorReport reportSyntaxErrors(@NotNull PsiElement file2, @NotNull MessageCollector messageCollector) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
            return this.reportSyntaxErrors(file2, new DefaultDiagnosticReporter(messageCollector));
        }

        private static final Unit reportSyntaxErrors$lambda$0(DiagnosticMessageReporter $reporter, PsiErrorElement element, String message2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            MyDiagnostic<PsiElement> diagnostic = new MyDiagnostic<PsiElement>((PsiElement)element, SYNTAX_ERROR_FACTORY, message2);
            Companion.reportDiagnostic((Diagnostic)diagnostic, $reporter, false);
            return Unit.INSTANCE;
        }

        private static final Unit reportSyntaxErrors$lambda$1(BaseDiagnosticsCollector $diagnosticCollector, PsiElement $file, PsiErrorElement element, String message2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            KtDiagnosticWithParameters1 diagnostic = FirSyntaxErrors.INSTANCE.getSYNTAX().on((AbstractKtSourceElement)new KtRealPsiSourceElement((PsiElement)element), (Object)message2, null, (LanguageVersionSettings)LanguageVersionSettingsImpl.DEFAULT);
            DiagnosticContext context2 = new DiagnosticContext($file){
                final /* synthetic */ PsiElement $file;
                {
                    this.$file = $file;
                }

                public String getContainingFilePath() {
                    VirtualFile virtualFile = this.$file.getContainingFile().getVirtualFile();
                    return virtualFile != null ? virtualFile.getPath() : null;
                }

                public boolean isDiagnosticSuppressed(KtDiagnostic diagnostic) {
                    Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                    return false;
                }

                public LanguageVersionSettings getLanguageVersionSettings() {
                    return LanguageVersionSettingsImpl.DEFAULT;
                }
            };
            $diagnosticCollector.report((KtDiagnostic)diagnostic, context2);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(k=3, mv={2, 2, 0}, d1={}, d2={}, xi=48)
        @Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Severity.values().length];
                try {
                    nArray[Severity.INFO.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Severity.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Severity.WARNING.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Severity.FIXED_WARNING.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(k=1, mv={2, 2, 0}, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B%\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u00020\u000e8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$MyDiagnostic;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "E", "Lorg/jetbrains/kotlin/diagnostics/SimpleDiagnostic;", "psiElement", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "factory", "", "message", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;Ljava/lang/String;)V", "Ljava/lang/String;", "getMessage", "()Ljava/lang/String;", "", "isValid", "Z", "()Z", "cli"}, xi=48)
    @Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
    private static final class MyDiagnostic<E extends PsiElement>
    extends SimpleDiagnostic<E> {
        @NotNull
        private final String message;
        private final boolean isValid;

        public MyDiagnostic(@NotNull E psiElement, @NotNull DiagnosticFactory0<E> factory2, @NotNull String message2) {
            Intrinsics.checkNotNullParameter(psiElement, (String)"psiElement");
            Intrinsics.checkNotNullParameter(factory2, (String)"factory");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super(psiElement, factory2, Severity.ERROR);
            this.message = message2;
            this.isValid = true;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public boolean isValid() {
            return this.isValid;
        }
    }

    @Metadata(k=1, mv={2, 2, 0}, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0007\u001a\u0004\b\u0003\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0007\u001a\u0004\b\u0004\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/AnalyzerWithCompilerReport$SyntaxErrorReport;", "", "", "isHasErrors", "isAllErrorsAtEof", "<init>", "(ZZ)V", "Z", "()Z", "cli"}, xi=48)
    @Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
    public static final class SyntaxErrorReport {
        private final boolean isHasErrors;
        private final boolean isAllErrorsAtEof;

        public SyntaxErrorReport(boolean isHasErrors, boolean isAllErrorsAtEof) {
            this.isHasErrors = isHasErrors;
            this.isAllErrorsAtEof = isAllErrorsAtEof;
        }

        public final boolean isHasErrors() {
            return this.isHasErrors;
        }

        public final boolean isAllErrorsAtEof() {
            return this.isAllErrorsAtEof;
        }
    }
}

