/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.jetbrains.kotlin.org.apache.commons.io.file.NoopPathVisitor;
import org.jetbrains.kotlin.org.apache.commons.io.file.PathUtils;
import org.jetbrains.kotlin.org.apache.commons.io.file.PathVisitor;
import org.jetbrains.kotlin.org.apache.commons.io.filefilter.AbstractFileFilter;

public class PathVisitorFileFilter
extends AbstractFileFilter {
    private final PathVisitor pathVisitor;

    public PathVisitorFileFilter(PathVisitor pathVisitor) {
        this.pathVisitor = pathVisitor == null ? NoopPathVisitor.INSTANCE : pathVisitor;
    }

    @Override
    public boolean accept(File file2) {
        try {
            Path path = file2.toPath();
            return this.visitFile(path, file2.exists() ? PathUtils.readBasicFileAttributes(path) : null) == FileVisitResult.CONTINUE;
        }
        catch (IOException e) {
            return this.handle(e) == FileVisitResult.CONTINUE;
        }
    }

    @Override
    public boolean accept(File dir2, String name2) {
        try {
            Path path = dir2.toPath().resolve(name2);
            return this.accept(path, PathUtils.readBasicFileAttributes(path)) == FileVisitResult.CONTINUE;
        }
        catch (IOException e) {
            return this.handle(e) == FileVisitResult.CONTINUE;
        }
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes attributes2) {
        return this.get(() -> Files.isDirectory(path, new LinkOption[0]) ? this.pathVisitor.postVisitDirectory(path, null) : this.visitFile(path, attributes2));
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attributes2) throws IOException {
        return this.pathVisitor.visitFile(path, attributes2);
    }
}

