/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.utils.CommandFallback;
import org.jetbrains.kotlin.gradle.utils.ProcessUtilsKt;
import org.jetbrains.kotlin.gradle.utils.RunProcessResult;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a=\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0019\b\u0002\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000bH\u0002\u001a\u001e\u0010\f\u001a\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001af\u0010\u000e\u001a\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062'\b\u0002\u0010\u000f\u001a!\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\b2\u0019\b\u0002\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000bH\u0000\u001a`\u0010\u0013\u001a\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062!\u0010\u0014\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00150\b2\u0019\b\u0002\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000bH\u0000\u00a8\u0006\u0016"}, d2={"assembleAndRunProcess", "Lorg/jetbrains/kotlin/gradle/utils/RunProcessResult;", "command", "", "", "logger", "Lorg/gradle/api/logging/Logger;", "processConfiguration", "Lkotlin/Function1;", "Ljava/lang/ProcessBuilder;", "", "Lkotlin/ExtensionFunctionType;", "createErrorMessage", "runResult", "runCommand", "errorHandler", "Lkotlin/ParameterName;", "name", "result", "runCommandWithFallback", "fallback", "Lorg/jetbrains/kotlin/gradle/utils/CommandFallback;", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nProcessUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessUtils.kt\norg/jetbrains/kotlin/gradle/utils/ProcessUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1851#2,2:133\n*S KotlinDebug\n*F\n+ 1 ProcessUtils.kt\norg/jetbrains/kotlin/gradle/utils/ProcessUtilsKt\n*L\n116#1:133,2\n*E\n"})
public final class ProcessUtilsKt {
    @NotNull
    public static final String runCommand(@NotNull List<String> command, @Nullable Logger logger2, @Nullable Function1<? super RunProcessResult, String> errorHandler, @NotNull Function1<? super ProcessBuilder, Unit> processConfiguration) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter(processConfiguration, (String)"processConfiguration");
        RunProcessResult runResult = ProcessUtilsKt.assembleAndRunProcess(command, logger2, processConfiguration);
        if (!(runResult.getRetCode() == 0)) {
            boolean bl = false;
            Object object = errorHandler;
            if (object == null || (object = (String)object.invoke((Object)runResult)) == null) {
                object = ProcessUtilsKt.createErrorMessage(command, runResult);
            }
            Object object2 = object;
            throw new IllegalStateException(object2.toString());
        }
        return runResult.getStdOut();
    }

    public static /* synthetic */ String runCommand$default(List list, Logger logger2, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            logger2 = null;
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        if ((n & 8) != 0) {
            function12 = runCommand.1.INSTANCE;
        }
        return ProcessUtilsKt.runCommand(list, logger2, (Function1<? super RunProcessResult, String>)function1, (Function1<? super ProcessBuilder, Unit>)function12);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final String runCommandWithFallback(@NotNull List<String> command, @Nullable Logger logger2, @NotNull Function1<? super RunProcessResult, ? extends CommandFallback> fallback, @NotNull Function1<? super ProcessBuilder, Unit> processConfiguration) {
        String string;
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter(fallback, (String)"fallback");
        Intrinsics.checkNotNullParameter(processConfiguration, (String)"processConfiguration");
        RunProcessResult runResult = ProcessUtilsKt.assembleAndRunProcess(command, logger2, processConfiguration);
        if (runResult.getRetCode() == 0) {
            string = runResult.getStdOut();
            return string;
        }
        CommandFallback fallbackOption = (CommandFallback)fallback.invoke((Object)runResult);
        if (fallbackOption instanceof CommandFallback.Action) {
            string = ((CommandFallback.Action)fallbackOption).getFallback();
            return string;
        }
        if (!(fallbackOption instanceof CommandFallback.Error)) throw new NoWhenBranchMatchedException();
        String string2 = ((CommandFallback.Error)fallbackOption).getError();
        if (string2 == null) {
            string2 = ProcessUtilsKt.createErrorMessage(command, runResult);
        }
        String string3 = string2;
        throw new IllegalStateException(string3.toString());
    }

    public static /* synthetic */ String runCommandWithFallback$default(List list, Logger logger2, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            logger2 = null;
        }
        if ((n & 8) != 0) {
            function12 = runCommandWithFallback.1.INSTANCE;
        }
        return ProcessUtilsKt.runCommandWithFallback(list, logger2, (Function1<? super RunProcessResult, ? extends CommandFallback>)function1, (Function1<? super ProcessBuilder, Unit>)function12);
    }

    private static final RunProcessResult assembleAndRunProcess(List<String> command, Logger logger2, Function1<? super ProcessBuilder, Unit> processConfiguration) {
        ProcessBuilder processBuilder;
        ProcessBuilder $this$assembleAndRunProcess_u24lambda_u241 = processBuilder = new ProcessBuilder(command);
        boolean bl = false;
        processConfiguration.invoke((Object)$this$assembleAndRunProcess_u24lambda_u241);
        Process process = processBuilder.start();
        Ref.ObjectRef inputText = new Ref.ObjectRef();
        inputText.element = "";
        Ref.ObjectRef errorText = new Ref.ObjectRef();
        errorText.element = "";
        Thread inputThread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>((Ref.ObjectRef<String>)inputText, process){
            final /* synthetic */ Ref.ObjectRef<String> $inputText;
            final /* synthetic */ Process $process;
            {
                this.$inputText = $inputText;
                this.$process = $process;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                Object it;
                void $this$use$iv;
                AutoCloseable autoCloseable = this.$process.getInputStream();
                Ref.ObjectRef<String> objectRef = this.$inputText;
                boolean $i$f$use = false;
                boolean closed$iv = false;
                try {
                    it = (InputStream)$this$use$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    InputStream inputStream = it;
                    Charset charset = Charsets.UTF_8;
                    it = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
                }
                catch (Exception e$iv) {
                    try {
                        closed$iv = true;
                        try {
                            void v1 = $this$use$iv;
                            if (v1 != null) {
                                v1.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw e$iv;
                    }
                    catch (Throwable throwable) {
                        if (!closed$iv) {
                            void v2 = $this$use$iv;
                            if (v2 != null) {
                                v2.close();
                            }
                        }
                        throw throwable;
                    }
                }
                void v0 = $this$use$iv;
                if (v0 != null) {
                    v0.close();
                }
                objectRef.element = it;
            }
        }), (int)31, null);
        Thread errorThread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>((Ref.ObjectRef<String>)errorText, process){
            final /* synthetic */ Ref.ObjectRef<String> $errorText;
            final /* synthetic */ Process $process;
            {
                this.$errorText = $errorText;
                this.$process = $process;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                Object it;
                void $this$use$iv;
                AutoCloseable autoCloseable = this.$process.getErrorStream();
                Ref.ObjectRef<String> objectRef = this.$errorText;
                boolean $i$f$use = false;
                boolean closed$iv = false;
                try {
                    it = (InputStream)$this$use$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    InputStream inputStream = it;
                    Charset charset = Charsets.UTF_8;
                    it = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
                }
                catch (Exception e$iv) {
                    try {
                        closed$iv = true;
                        try {
                            void v1 = $this$use$iv;
                            if (v1 != null) {
                                v1.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw e$iv;
                    }
                    catch (Throwable throwable) {
                        if (!closed$iv) {
                            void v2 = $this$use$iv;
                            if (v2 != null) {
                                v2.close();
                            }
                        }
                        throw throwable;
                    }
                }
                void v0 = $this$use$iv;
                if (v0 != null) {
                    v0.close();
                }
                objectRef.element = it;
            }
        }), (int)31, null);
        inputThread2.join();
        errorThread2.join();
        int retCode = process.waitFor();
        Iterable $this$forEach$iv = StringsKt.lines((CharSequence)StringsKt.trimMargin$default((String)("\n        |Information about \"" + CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "\" call:\n        |\n        |" + (String)inputText.element + "\n    "), null, (int)1, null));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl2 = false;
            Logger logger3 = logger2;
            if (logger3 == null) continue;
            logger3.info(line);
        }
        String string = (String)inputText.element;
        String string2 = (String)errorText.element;
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"process");
        return new RunProcessResult(string, string2, retCode, process);
    }

    static /* synthetic */ RunProcessResult assembleAndRunProcess$default(List list, Logger logger2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            logger2 = null;
        }
        if ((n & 4) != 0) {
            function1 = assembleAndRunProcess.1.INSTANCE;
        }
        return ProcessUtilsKt.assembleAndRunProcess(list, logger2, (Function1<? super ProcessBuilder, Unit>)function1);
    }

    private static final String createErrorMessage(List<String> command, RunProcessResult runResult) {
        return StringsKt.trimMargin$default((String)("\n           |Executing of '" + CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "' failed with code " + runResult.getRetCode() + " and message: \n           |\n           |" + runResult.getStdOut() + "\n           |\n           |" + runResult.getStdErr() + "\n           |\n           "), null, (int)1, null);
    }
}

