/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.diagnostics;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.plugin.AndroidGradlePluginVersion;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnosticsCollectorKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\b*\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/diagnostics/AgpWithBuiltInKotlinAppliedCheck;", "", "()V", "minimalBuiltInKotlinSupportedAgpVersion", "Lorg/jetbrains/kotlin/gradle/plugin/AndroidGradlePluginVersion;", "getMinimalBuiltInKotlinSupportedAgpVersion", "()Lorg/jetbrains/kotlin/gradle/plugin/AndroidGradlePluginVersion;", "runAgpWithBuiltInKotlinIfAppliedCheck", "", "Lorg/gradle/api/Project;", "agpVersionProvider", "Lorg/jetbrains/kotlin/gradle/internal/diagnostics/AgpWithBuiltInKotlinAppliedCheck$AndroidGradlePluginVersionProvider;", "AndroidGradlePluginVersionProvider", "kotlin-gradle-plugin_common"})
public final class AgpWithBuiltInKotlinAppliedCheck {
    @NotNull
    public static final AgpWithBuiltInKotlinAppliedCheck INSTANCE = new AgpWithBuiltInKotlinAppliedCheck();
    @NotNull
    private static final AndroidGradlePluginVersion minimalBuiltInKotlinSupportedAgpVersion = new AndroidGradlePluginVersion(9, 0, 0, "alpha01");

    private AgpWithBuiltInKotlinAppliedCheck() {
    }

    @NotNull
    public final AndroidGradlePluginVersion getMinimalBuiltInKotlinSupportedAgpVersion() {
        return minimalBuiltInKotlinSupportedAgpVersion;
    }

    public final void runAgpWithBuiltInKotlinIfAppliedCheck(@NotNull Project $this$runAgpWithBuiltInKotlinIfAppliedCheck, @NotNull AndroidGradlePluginVersionProvider agpVersionProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$runAgpWithBuiltInKotlinIfAppliedCheck, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)agpVersionProvider, (String)"agpVersionProvider");
        boolean isKotlinAndroidExtensionExists = KotlinProjectExtensionKt.getKotlinAndroidExtensionOrNull($this$runAgpWithBuiltInKotlinIfAppliedCheck) != null;
        AndroidGradlePluginVersion agpVersion = agpVersionProvider.get();
        if (isKotlinAndroidExtensionExists && agpVersion != null && agpVersion.compareTo(minimalBuiltInKotlinSupportedAgpVersion) >= 0) {
            Project project = $this$runAgpWithBuiltInKotlinIfAppliedCheck.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            File file2 = $this$runAgpWithBuiltInKotlinIfAppliedCheck.getProject().getBuildFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.buildFile");
            File file3 = $this$runAgpWithBuiltInKotlinIfAppliedCheck.getProject().getRootDir();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"project.rootDir");
            KotlinToolingDiagnosticsCollectorKt.reportDiagnostic(project, KotlinToolingDiagnostics.AgpWithBuiltInKotlinIsAlreadyApplied.INSTANCE.invoke(FilesKt.relativeTo((File)file2, (File)file3), new Throwable()));
        }
    }

    public static /* synthetic */ void runAgpWithBuiltInKotlinIfAppliedCheck$default(AgpWithBuiltInKotlinAppliedCheck agpWithBuiltInKotlinAppliedCheck, Project project, AndroidGradlePluginVersionProvider androidGradlePluginVersionProvider, int n, Object object) {
        if ((n & 1) != 0) {
            androidGradlePluginVersionProvider = AndroidGradlePluginVersionProvider.Default.INSTANCE;
        }
        agpWithBuiltInKotlinAppliedCheck.runAgpWithBuiltInKotlinIfAppliedCheck(project, androidGradlePluginVersionProvider);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\u0004J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/diagnostics/AgpWithBuiltInKotlinAppliedCheck$AndroidGradlePluginVersionProvider;", "", "get", "Lorg/jetbrains/kotlin/gradle/plugin/AndroidGradlePluginVersion;", "Default", "kotlin-gradle-plugin_common"})
    public static interface AndroidGradlePluginVersionProvider {
        @Nullable
        public AndroidGradlePluginVersion get();

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/diagnostics/AgpWithBuiltInKotlinAppliedCheck$AndroidGradlePluginVersionProvider$Default;", "Lorg/jetbrains/kotlin/gradle/internal/diagnostics/AgpWithBuiltInKotlinAppliedCheck$AndroidGradlePluginVersionProvider;", "()V", "get", "Lorg/jetbrains/kotlin/gradle/plugin/AndroidGradlePluginVersion;", "kotlin-gradle-plugin_common"})
        public static final class Default
        implements AndroidGradlePluginVersionProvider {
            @NotNull
            public static final Default INSTANCE = new Default();

            private Default() {
            }

            @Override
            @Nullable
            public AndroidGradlePluginVersion get() {
                return AndroidGradlePluginVersion.Companion.getCurrentOrNull();
            }
        }
    }
}

