/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.statistics;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.statistics.BuildSession;
import org.jetbrains.kotlin.statistics.fileloggers.MetricsContainer;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;
import org.jetbrains.kotlin.statistics.metrics.StatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0010J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0006\u0010\u0014\u001a\u00020\tJ1\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u001bJ1\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u001dJ1\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0013J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0013H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/statistics/BuildSessionLogger;", "Lorg/jetbrains/kotlin/statistics/metrics/StatisticsValuesConsumer;", "statisticsFolder", "Ljava/io/File;", "maxProfileFiles", "", "maxFileAge", "", "forceValuesValidation", "", "(Ljava/io/File;IJZ)V", "buildSession", "Lorg/jetbrains/kotlin/statistics/BuildSession;", "metricsContainer", "Lorg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer;", "clearOldFiles", "", "finishBuildSession", "getActiveBuildId", "", "isBuildSessionStarted", "report", "metric", "Lorg/jetbrains/kotlin/statistics/metrics/BooleanMetrics;", "value", "subprojectName", "weight", "(Lorg/jetbrains/kotlin/statistics/metrics/BooleanMetrics;ZLjava/lang/String;Ljava/lang/Long;)Z", "Lorg/jetbrains/kotlin/statistics/metrics/NumericalMetrics;", "(Lorg/jetbrains/kotlin/statistics/metrics/NumericalMetrics;JLjava/lang/String;Ljava/lang/Long;)Z", "Lorg/jetbrains/kotlin/statistics/metrics/StringMetrics;", "(Lorg/jetbrains/kotlin/statistics/metrics/StringMetrics;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;)Z", "startBuildSession", "buildUid", "storeMetricsIntoFile", "buildId", "Companion", "kotlin-gradle-statistics"})
public final class BuildSessionLogger
implements StatisticsValuesConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File statisticsFolder;
    private final int maxProfileFiles;
    private final long maxFileAge;
    @Nullable
    private BuildSession buildSession;
    @NotNull
    private final MetricsContainer metricsContainer;
    @NotNull
    public static final String FUS_KOTLIN_FILE_NAME_SUFFIX = ".kotlin-profile";
    @NotNull
    private static final String FILE_NAME_BUILD_ID_PREFIX_SEPARATOR = "-";
    @NotNull
    public static final String STATISTICS_FOLDER_NAME = "kotlin-profile";
    @NotNull
    private static final Regex STATISTICS_FILE_NAME_PATTERN = new Regex("[\\w-]*.kotlin-profile");
    private static final int DEFAULT_MAX_PROFILE_FILES = 1000;
    private static final long DEFAULT_MAX_FILE_AGE = 2592000000L;

    public BuildSessionLogger(@NotNull File statisticsFolder, int maxProfileFiles, long maxFileAge, boolean forceValuesValidation) {
        Intrinsics.checkNotNullParameter((Object)statisticsFolder, (String)"statisticsFolder");
        this.statisticsFolder = statisticsFolder;
        this.maxProfileFiles = maxProfileFiles;
        this.maxFileAge = maxFileAge;
        this.statisticsFolder.mkdirs();
        this.metricsContainer = new MetricsContainer(forceValuesValidation);
    }

    public /* synthetic */ BuildSessionLogger(File file2, int n, long l, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1000;
        }
        if ((n2 & 4) != 0) {
            l = 2592000000L;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        this(file2, n, l, bl);
    }

    public final synchronized void startBuildSession(@NotNull String buildUid) {
        Intrinsics.checkNotNullParameter((Object)buildUid, (String)"buildUid");
        this.buildSession = new BuildSession(buildUid);
    }

    public final synchronized boolean isBuildSessionStarted() {
        return this.buildSession != null;
    }

    @Nullable
    public final synchronized String getActiveBuildId() {
        BuildSession buildSession = this.buildSession;
        return buildSession != null ? buildSession.getBuildUid() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void storeMetricsIntoFile(String buildId) {
        try {
            File file2 = FilesKt.resolve((File)this.statisticsFolder, (String)(this.getActiveBuildId() + '-' + UUID.randomUUID() + FUS_KOTLIN_FILE_NAME_SUFFIX));
            Closeable closeable = new FileWriter(file2);
            int n = 8192;
            closeable = closeable instanceof BufferedWriter ? (BufferedWriter)closeable : new BufferedWriter((Writer)closeable, n);
            Throwable throwable = null;
            try {
                BufferedWriter writer = (BufferedWriter)closeable;
                boolean bl = false;
                writer.write("Build: " + buildId);
                this.metricsContainer.flush(writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final void clearOldFiles() {
        List<File> fileCandidates = Companion.listProfileFiles(this.statisticsFolder);
        Iterator iterator2 = ((Iterable)fileCandidates).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            long lastModified;
            int index = n++;
            File file2 = (File)iterator2.next();
            boolean toDelete = index < fileCandidates.size() - this.maxProfileFiles ? true : (lastModified = file2.lastModified()) > 0L && System.currentTimeMillis() - this.maxFileAge > lastModified;
            if (!toDelete) continue;
            file2.delete();
        }
    }

    public final synchronized void finishBuildSession() {
        BuildSession buildSession = this.buildSession;
        if (buildSession != null) {
            BuildSession buildSession2;
            BuildSession it = buildSession2 = buildSession;
            boolean bl = false;
            this.storeMetricsIntoFile(it.getBuildUid());
        }
        this.buildSession = null;
        this.clearOldFiles();
    }

    @Override
    public boolean report(@NotNull BooleanMetrics metric, boolean value2, @Nullable String subprojectName, @Nullable Long weight) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        return this.metricsContainer.report(metric, value2, subprojectName, weight);
    }

    @Override
    public boolean report(@NotNull NumericalMetrics metric, long value2, @Nullable String subprojectName, @Nullable Long weight) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        return this.metricsContainer.report(metric, value2, subprojectName, weight);
    }

    @Override
    public boolean report(@NotNull StringMetrics metric, @NotNull String value2, @Nullable String subprojectName, @Nullable Long weight) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.metricsContainer.report(metric, value2, subprojectName, weight);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/statistics/BuildSessionLogger$Companion;", "", "()V", "DEFAULT_MAX_FILE_AGE", "", "DEFAULT_MAX_PROFILE_FILES", "", "FILE_NAME_BUILD_ID_PREFIX_SEPARATOR", "", "FUS_KOTLIN_FILE_NAME_SUFFIX", "STATISTICS_FILE_NAME_PATTERN", "Lkotlin/text/Regex;", "getSTATISTICS_FILE_NAME_PATTERN", "()Lkotlin/text/Regex;", "STATISTICS_FOLDER_NAME", "listProfileFiles", "", "Ljava/io/File;", "statisticsFolder", "kotlin-gradle-statistics"})
    @SourceDebugExtension(value={"SMAP\nBuildSessionLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildSessionLogger.kt\norg/jetbrains/kotlin/statistics/BuildSessionLogger$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1557#2:120\n1628#2,3:121\n774#2:124\n865#2,2:125\n774#2:127\n865#2,2:128\n1053#2:130\n*S KotlinDebug\n*F\n+ 1 BuildSessionLogger.kt\norg/jetbrains/kotlin/statistics/BuildSessionLogger$Companion\n*L\n35#1:120\n35#1:121,3\n36#1:124\n36#1:125,2\n37#1:127\n37#1:128,2\n38#1:130\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getSTATISTICS_FILE_NAME_PATTERN() {
            return STATISTICS_FILE_NAME_PATTERN;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final List<File> listProfileFiles(@NotNull File statisticsFolder) {
            List list;
            Intrinsics.checkNotNullParameter((Object)statisticsFolder, (String)"statisticsFolder");
            if (!statisticsFolder.isDirectory()) {
                return CollectionsKt.emptyList();
            }
            Closeable closeable = Files.newDirectoryStream(statisticsFolder.toPath());
            Throwable throwable = null;
            try {
                void $this$sortedBy$iv;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                File it;
                void $this$mapTo$iv$iv;
                DirectoryStream dirStream = (DirectoryStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)dirStream, (String)"dirStream");
                Iterable $this$map$iv = dirStream;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.toFile());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (File)element$iv$iv;
                    boolean bl3 = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    CharSequence charSequence = string;
                    if (!Companion.getSTATISTICS_FILE_NAME_PATTERN().matches(charSequence)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (File)element$iv$iv;
                    boolean bl4 = false;
                    if (!it.isFile()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$sortedBy = false;
                list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        File it = (File)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.lastModified());
                        it = (File)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.lastModified()));
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

