/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.util.AbstractArrayMapOwner;
import org.jetbrains.kotlin.gradle.internal.util.ArrayMap;
import org.jetbrains.kotlin.gradle.internal.util.ArrayMapImpl;
import org.jetbrains.kotlin.gradle.internal.util.EmptyArrayMap;
import org.jetbrains.kotlin.gradle.internal.util.OneElementArrayMap;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u0017\b\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\tJ\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u0011J&\u0010\u0012\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0019H\u0004R*\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/util/AttributeArrayOwner;", "K", "", "T", "Lorg/jetbrains/kotlin/gradle/internal/util/AbstractArrayMapOwner;", "arrayMap", "Lorg/jetbrains/kotlin/gradle/internal/util/ArrayMap;", "<init>", "(Lorg/jetbrains/kotlin/util/ArrayMap;)V", "()V", "value", "getArrayMap", "()Lorg/jetbrains/kotlin/util/ArrayMap;", "registerComponent", "", "keyQualifiedName", "", "(Ljava/lang/String;Ljava/lang/Object;)V", "buildDiagnosticMessage", "map", "expectedSize", "", "expectedImplementation", "removeComponent", "tClass", "Lkotlin/reflect/KClass;", "compiler.common"})
@SourceDebugExtension(value={"SMAP\nAttributeArrayOwner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttributeArrayOwner.kt\norg/jetbrains/kotlin/util/AttributeArrayOwner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1573#2:104\n1604#2,3:105\n295#2,2:108\n1607#2:110\n*S KotlinDebug\n*F\n+ 1 AttributeArrayOwner.kt\norg/jetbrains/kotlin/util/AttributeArrayOwner\n*L\n76#1:104\n76#1:105,3\n77#1:108,2\n76#1:110\n*E\n"})
public abstract class AttributeArrayOwner<K, T>
extends AbstractArrayMapOwner<K, T> {
    @NotNull
    private ArrayMap<T> arrayMap;

    protected AttributeArrayOwner(@NotNull ArrayMap<T> arrayMap) {
        Intrinsics.checkNotNullParameter(arrayMap, (String)"arrayMap");
        this.arrayMap = arrayMap;
    }

    @Override
    @NotNull
    protected final ArrayMap<T> getArrayMap() {
        return this.arrayMap;
    }

    public AttributeArrayOwner() {
        EmptyArrayMap emptyArrayMap = EmptyArrayMap.INSTANCE;
        Intrinsics.checkNotNull((Object)emptyArrayMap, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.util.ArrayMap<T of org.jetbrains.kotlin.util.AttributeArrayOwner>");
        this(emptyArrayMap);
    }

    @Override
    protected final void registerComponent(@NotNull String keyQualifiedName, @NotNull T value2) {
        Intrinsics.checkNotNullParameter((Object)keyQualifiedName, (String)"keyQualifiedName");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        int id = this.getTypeRegistry().getId(keyQualifiedName);
        switch (this.arrayMap.getSize()) {
            case 0: {
                ArrayMap<T> map = this.arrayMap;
                if (!(map instanceof EmptyArrayMap)) {
                    throw new IllegalStateException(this.buildDiagnosticMessage(map, 0, "EmptyArrayMap"));
                }
                this.arrayMap = new OneElementArrayMap<T>(value2, id);
                return;
            }
            case 1: {
                OneElementArrayMap oneElementArrayMap;
                ArrayMap<T> mapSnapshot = this.arrayMap;
                try {
                    Intrinsics.checkNotNull(mapSnapshot, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.util.OneElementArrayMap<T of org.jetbrains.kotlin.util.AttributeArrayOwner>");
                    oneElementArrayMap = (OneElementArrayMap)mapSnapshot;
                }
                catch (ClassCastException e) {
                    throw new IllegalStateException(this.buildDiagnosticMessage(mapSnapshot, 1, "OneElementArrayMap"), e);
                }
                OneElementArrayMap map = oneElementArrayMap;
                if (map.getIndex() == id) {
                    this.arrayMap = new OneElementArrayMap<T>(value2, id);
                    return;
                }
                ArrayMapImpl newMap2 = new ArrayMapImpl();
                newMap2.set(map.getIndex(), map.getValue());
                this.arrayMap = newMap2;
            }
        }
        this.arrayMap.set(id, value2);
    }

    /*
     * WARNING - void declaration
     */
    private final String buildDiagnosticMessage(ArrayMap<T> map, int expectedSize, String expectedImplementation) {
        void $this$mapIndexedTo$iv$iv;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder $this$buildDiagnosticMessage_u24lambda_u240 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$buildDiagnosticMessage_u24lambda_u240.append("Race condition happened, the size of ArrayMap is " + expectedSize + " but it isn't an `" + expectedImplementation + '`').append('\n');
        $this$buildDiagnosticMessage_u24lambda_u240.append("Type: " + map.getClass()).append('\n');
        StringBuilder $this$buildDiagnosticMessage_u24lambda_u240_u240 = stringBuilder = new StringBuilder();
        boolean bl2 = false;
        Map<String, Integer> services = this.getTypeRegistry().allValuesThreadUnsafeForRendering();
        $this$buildDiagnosticMessage_u24lambda_u240_u240.append("[").append('\n');
        Iterable $this$mapIndexed$iv = map;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void value2;
            Object v0;
            void index;
            Collection collection;
            block3: {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv;
                boolean bl3 = false;
                Iterable $this$firstOrNull$iv = services.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl4 = false;
                    if (!(((Number)it.getValue()).intValue() == index)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            Map.Entry service = v0;
            collection.add($this$buildDiagnosticMessage_u24lambda_u240_u240.append("  " + service + '[' + (int)index + "]: " + value2).append('\n'));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        $this$buildDiagnosticMessage_u24lambda_u240_u240.append("]").append('\n');
        String content = stringBuilder.toString();
        $this$buildDiagnosticMessage_u24lambda_u240.append("Content: " + content).append('\n');
        return stringBuilder2.toString();
    }

    protected final void removeComponent(@NotNull KClass<? extends K> tClass) {
        Intrinsics.checkNotNullParameter(tClass, (String)"tClass");
        int id = this.getTypeRegistry().getId(tClass);
        if (this.arrayMap.get(id) == null) {
            return;
        }
        if (this.arrayMap.getSize() == 1) {
            EmptyArrayMap emptyArrayMap = EmptyArrayMap.INSTANCE;
            Intrinsics.checkNotNull((Object)emptyArrayMap, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.util.ArrayMap<T of org.jetbrains.kotlin.util.AttributeArrayOwner>");
            this.arrayMap = emptyArrayMap;
        } else {
            ArrayMap<T> arrayMap = this.arrayMap;
            Intrinsics.checkNotNull(arrayMap, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.util.ArrayMapImpl<T of org.jetbrains.kotlin.util.AttributeArrayOwner>");
            ArrayMapImpl map = (ArrayMapImpl)arrayMap;
            map.remove(id);
            if (map.getSize() == 1) {
                ArrayMapImpl.Entry entry2 = (ArrayMapImpl.Entry)CollectionsKt.first(map.entries());
                int index = entry2.component1();
                Object value2 = entry2.component2();
                this.arrayMap = new OneElementArrayMap(value2, index);
            }
        }
    }
}

