/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.resolve.constants;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.gradle.internal.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.gradle.internal.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.gradle.internal.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.gradle.internal.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J\u0013\u0010\u001a\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001f\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0013\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/resolve/constants/TypedCompileTimeConstant;", "T", "Lorg/jetbrains/kotlin/gradle/internal/resolve/constants/CompileTimeConstant;", "constantValue", "Lorg/jetbrains/kotlin/gradle/internal/resolve/constants/ConstantValue;", "moduleDescriptor", "Lorg/jetbrains/kotlin/gradle/internal/descriptors/ModuleDescriptor;", "parameters", "Lorg/jetbrains/kotlin/gradle/internal/resolve/constants/CompileTimeConstant$Parameters;", "<init>", "(Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;)V", "getConstantValue", "()Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getParameters", "()Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "isError", "", "()Z", "type", "Lorg/jetbrains/kotlin/gradle/internal/types/KotlinType;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "toConstantValue", "expectedType", "equals", "other", "", "hashCode", "", "hasIntegerLiteralType", "getHasIntegerLiteralType", "descriptors"})
public final class TypedCompileTimeConstant<T>
implements CompileTimeConstant<T> {
    @NotNull
    private final ConstantValue<T> constantValue;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final CompileTimeConstant.Parameters parameters;
    @NotNull
    private final KotlinType type;

    public TypedCompileTimeConstant(@NotNull ConstantValue<? extends T> constantValue, @NotNull ModuleDescriptor moduleDescriptor, @NotNull CompileTimeConstant.Parameters parameters) {
        Intrinsics.checkNotNullParameter(constantValue, (String)"constantValue");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.constantValue = constantValue;
        this.moduleDescriptor = moduleDescriptor;
        this.parameters = parameters;
        this.type = this.constantValue.getType(this.getModuleDescriptor());
    }

    @NotNull
    public final ConstantValue<T> getConstantValue() {
        return this.constantValue;
    }

    @Override
    @NotNull
    public ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @Override
    @NotNull
    public CompileTimeConstant.Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isError() {
        return this.constantValue instanceof ErrorValue;
    }

    @NotNull
    public final KotlinType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public ConstantValue<T> toConstantValue(@NotNull KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        return this.constantValue;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypedCompileTimeConstant)) {
            return false;
        }
        if (this.isError()) {
            return ((TypedCompileTimeConstant)other).isError();
        }
        if (((TypedCompileTimeConstant)other).isError()) {
            return false;
        }
        return Intrinsics.areEqual(this.constantValue.getValue(), ((TypedCompileTimeConstant)other).constantValue.getValue()) && Intrinsics.areEqual((Object)this.type, (Object)((TypedCompileTimeConstant)other).type);
    }

    @Override
    public int hashCode() {
        if (this.isError()) {
            return 13;
        }
        T t = this.constantValue.getValue();
        int result2 = t != null ? t.hashCode() : 0;
        result2 = 31 * result2 + this.type.hashCode();
        return result2;
    }

    @Override
    public boolean getHasIntegerLiteralType() {
        return false;
    }
}

