/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip;

import java.io.Serializable;
import java.util.zip.ZipException;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.ZipMethod;

public class UnsupportedZipFeatureException
extends ZipException {
    private static final long serialVersionUID = 20161219L;
    private final Feature reason;
    private final transient ZipArchiveEntry entry;

    public UnsupportedZipFeatureException(Feature reason) {
        super("Unsupported feature " + reason + " used in archive.");
        this.reason = reason;
        this.entry = null;
    }

    public UnsupportedZipFeatureException(Feature reason, ZipArchiveEntry entry2) {
        super("Unsupported feature " + reason + " used in entry " + entry2.getName());
        this.reason = reason;
        this.entry = entry2;
    }

    public UnsupportedZipFeatureException(ZipMethod method, ZipArchiveEntry entry2) {
        super("Unsupported compression method " + entry2.getMethod() + " (" + method.name() + ") used in entry " + entry2.getName());
        this.reason = Feature.METHOD;
        this.entry = entry2;
    }

    public ZipArchiveEntry getEntry() {
        return this.entry;
    }

    public Feature getFeature() {
        return this.reason;
    }

    public static class Feature
    implements Serializable {
        private static final long serialVersionUID = 4112582948775420359L;
        public static final Feature ENCRYPTION = new Feature("encryption");
        public static final Feature METHOD = new Feature("compression method");
        public static final Feature DATA_DESCRIPTOR = new Feature("data descriptor");
        public static final Feature SPLITTING = new Feature("splitting");
        public static final Feature UNKNOWN_COMPRESSED_SIZE = new Feature("unknown compressed size");
        private final String name;

        private Feature(String name2) {
            this.name = name2;
        }

        public String toString() {
            return this.name;
        }
    }
}

