/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\u001a%\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u0007\"\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\tH\u0000\u001a\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0000\u001aH\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\f\b\u0002\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0015H\u0000\u001a\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a%\u0010\u001a\u001a\u00020\u00052\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u0007\"\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0014\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d*\u00060\u001cj\u0002`\u001dH\u0000\u001a\u001e\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d*\u00060\u001cj\u0002`\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0000\u001a\f\u0010 \u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\f\u0010!\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\f\u0010\"\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\f\u0010#\u001a\u00020\u0005*\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"ANSI_COLOR_REGEX", "Lkotlin/text/Regex;", "invalidTaskNameCharacters", "upperCaseRegex", "dashSeparatedName", "", "nameParts", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "dashSeparatedToUpperCamelCase", "name", "escapeStringCharacters", "str", "length", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "additionalChars", "escapeSlash", "", "escapeUnicode", "isPrintableUnicode", "c", "", "lowerCamelCaseName", "appendLine", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "value", "", "asValidTaskName", "clearAnsiColor", "decamelize", "removingTrailingNewline", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nstringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 stringUtils.kt\norg/jetbrains/kotlin/gradle/utils/StringUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,113:1\n11653#2,9:114\n13543#2:123\n13544#2:126\n11662#2:127\n11653#2,9:132\n13543#2:141\n13544#2:143\n11662#2:144\n1#3:124\n1#3:125\n1#3:142\n37#4:128\n36#4,3:129\n384#5,4:145\n*S KotlinDebug\n*F\n+ 1 stringUtils.kt\norg/jetbrains/kotlin/gradle/utils/StringUtilsKt\n*L\n12#1:114,9\n12#1:123\n12#1:126\n12#1:127\n27#1:132,9\n27#1:141\n27#1:143\n27#1:144\n12#1:125\n27#1:142\n24#1:128\n24#1:129,3\n59#1:145,4\n*E\n"})
public final class StringUtilsKt {
    @NotNull
    private static final Regex upperCaseRegex = new Regex("([A-Z])");
    @NotNull
    private static final Regex invalidTaskNameCharacters = new Regex("[/\\\\:<>\"?*|]");
    @NotNull
    private static final Regex ANSI_COLOR_REGEX = new Regex("\\x1b\\[[0-9;]*m");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String lowerCamelCaseName(String ... nameParts) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)nameParts, (String)"nameParts");
        String[] $this$mapNotNull$iv = nameParts;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            Object object;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (it != null) {
                void var16_15;
                void p0 = var16_15;
                boolean bl3 = false;
                boolean $i$f$lowerCamelCaseName$lambda$0$stub_for_inlining = false;
                object = ((CharSequence)p0).length() > 0 ? var16_15 : null;
            } else {
                object = null;
            }
            if (object == null) continue;
            Object it$iv$iv = object;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nonEmptyParts = (List)destination$iv$iv;
        Iterable iterable = CollectionsKt.drop((Iterable)nonEmptyParts, (int)1);
        CharSequence charSequence = "";
        String string = (String)CollectionsKt.firstOrNull((List)nonEmptyParts);
        if (string == null) {
            string = "";
        }
        return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)charSequence, (CharSequence)string, null, (int)0, null, (Function1)lowerCamelCaseName.1.INSTANCE, (int)28, null);
    }

    @NotNull
    public static final String dashSeparatedToUpperCamelCase(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String[] stringArray = new String[]{"-"};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)name2, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"", null, null, (int)0, null, (Function1)dashSeparatedToUpperCamelCase.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String dashSeparatedName(@NotNull Iterable<String> nameParts) {
        Intrinsics.checkNotNullParameter(nameParts, (String)"nameParts");
        Collection $this$toTypedArray$iv = CollectionsKt.toList(nameParts);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] stringArray2 = stringArray;
        return StringUtilsKt.dashSeparatedName(Arrays.copyOf(stringArray2, stringArray2.length));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String dashSeparatedName(String ... nameParts) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)nameParts, (String)"nameParts");
        String[] $this$mapNotNull$iv = nameParts;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            Object object;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (it != null) {
                void var16_15;
                void p0 = var16_15;
                boolean bl3 = false;
                boolean $i$f$dashSeparatedName$lambda$2$stub_for_inlining$1 = false;
                object = ((CharSequence)p0).length() > 0 ? var16_15 : null;
            } else {
                object = null;
            }
            if (object == null) continue;
            Object it$iv$iv = object;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nonEmptyParts = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)nonEmptyParts, (CharSequence)"-", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final String decamelize(@NotNull String $this$decamelize) {
        Intrinsics.checkNotNullParameter((Object)$this$decamelize, (String)"<this>");
        CharSequence charSequence = $this$decamelize;
        Regex regex = upperCaseRegex;
        Function1 function1 = decamelize.1.INSTANCE;
        return regex.replace(charSequence, function1);
    }

    @NotNull
    public static final String asValidTaskName(@NotNull String $this$asValidTaskName) {
        Intrinsics.checkNotNullParameter((Object)$this$asValidTaskName, (String)"<this>");
        CharSequence charSequence = $this$asValidTaskName;
        Regex regex = invalidTaskNameCharacters;
        String string = "_";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public static final String clearAnsiColor(@NotNull String $this$clearAnsiColor) {
        Intrinsics.checkNotNullParameter((Object)$this$clearAnsiColor, (String)"<this>");
        CharSequence charSequence = $this$clearAnsiColor;
        Regex regex = ANSI_COLOR_REGEX;
        String string = "";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public static final Appendable appendLine(@NotNull Appendable $this$appendLine, @Nullable Object value2) {
        Intrinsics.checkNotNullParameter((Object)$this$appendLine, (String)"<this>");
        Appendable appendable = $this$appendLine.append(String.valueOf(value2));
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value.toString())");
        return StringUtilsKt.appendLine(appendable);
    }

    @NotNull
    public static final Appendable appendLine(@NotNull Appendable $this$appendLine) {
        Intrinsics.checkNotNullParameter((Object)$this$appendLine, (String)"<this>");
        Appendable appendable = $this$appendLine.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append('\\n')");
        return appendable;
    }

    @NotNull
    public static final String removingTrailingNewline(@NotNull String $this$removingTrailingNewline) {
        String string;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$removingTrailingNewline, (String)"<this>");
            String $this$dropLastWhile$iv = $this$removingTrailingNewline;
            boolean $i$f$dropLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv); -1 < index$iv; --index$iv) {
                char it = $this$dropLastWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it == '\n') continue;
                String string2 = $this$dropLastWhile$iv;
                int n = 0;
                int n2 = index$iv + 1;
                String string3 = string2.substring(n, n2);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                break block1;
            }
            string = "";
        }
        return string;
    }

    @NotNull
    public static final String escapeStringCharacters(@NotNull String str, int length, @NotNull StringBuilder buffer, @Nullable String additionalChars, boolean escapeSlash, boolean escapeUnicode) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        char prev = (char)0;
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if (escapeSlash && ch == '\\') {
                        buffer.append("\\\\");
                        break;
                    }
                    if (additionalChars != null && StringsKt.indexOf$default((CharSequence)additionalChars, (char)ch, (int)0, (boolean)false, (int)6, null) > -1 && (escapeSlash || prev != '\\')) {
                        buffer.append("\\").append(ch);
                        break;
                    }
                    if (escapeUnicode && !StringUtilsKt.isPrintableUnicode(ch)) {
                        String string = Integer.toHexString(ch);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(ch.code)");
                        String string2 = string.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                        CharSequence hexCode = string2;
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append(hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            prev = ch;
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    public static /* synthetic */ String escapeStringCharacters$default(String string, int n, StringBuilder stringBuilder, String string2, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = string.length();
        }
        if ((n2 & 4) != 0) {
            stringBuilder = new StringBuilder(n);
        }
        if ((n2 & 8) != 0) {
            string2 = "\"";
        }
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = true;
        }
        return StringUtilsKt.escapeStringCharacters(string, n, stringBuilder, string2, bl, bl2);
    }

    private static final boolean isPrintableUnicode(char c) {
        byte t = (byte)Character.getType(c);
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19 && !Intrinsics.areEqual((Object)block, (Object)Character.UnicodeBlock.VARIATION_SELECTORS) && !Intrinsics.areEqual((Object)block, (Object)Character.UnicodeBlock.VARIATION_SELECTORS_SUPPLEMENT);
    }
}

