/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="Uploading keys to a keyserver is not cacheable. This task is intended for CLI usage.")
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/UploadPgpKeyTask;", "Lorg/gradle/api/DefaultTask;", "()V", "keyring", "Lorg/gradle/api/provider/Property;", "", "getKeyring", "()Lorg/gradle/api/provider/Property;", "keyserver", "getKeyserver", "execute", "", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\npgpHelperTasks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 pgpHelperTasks.kt\norg/jetbrains/kotlin/gradle/tasks/UploadPgpKeyTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,329:1\n1#2:330\n*E\n"})
public abstract class UploadPgpKeyTask
extends DefaultTask {
    @Input
    @Option(description="The file that contains the public key to upload to the keyserver in armored ASCII format.", option="keyring")
    @NotNull
    public abstract Property<String> getKeyring();

    @Input
    @Option(description="The address of the keyserver to upload the key to. Default: 'https://keyserver.ubuntu.com'", option="keyserver")
    @Optional
    @NotNull
    public abstract Property<String> getKeyserver();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void execute() {
        File publicKeyringFile = new File((String)this.getKeyring().get());
        if (!publicKeyringFile.isFile()) {
            boolean $i$a$-require-UploadPgpKeyTask$execute$32 = false;
            String $i$a$-require-UploadPgpKeyTask$execute$32 = "The provided public keyring file does not exist or cannot be read: " + publicKeyringFile.getAbsolutePath();
            throw new IllegalArgumentException($i$a$-require-UploadPgpKeyTask$execute$32.toString());
        }
        String publicKeyringContent = FilesKt.readText$default((File)publicKeyringFile, null, (int)1, null);
        if (!StringsKt.startsWith$default((String)publicKeyringContent, (String)"-----BEGIN PGP PUBLIC KEY BLOCK-----", (boolean)false, (int)2, null)) {
            boolean $i$a$-require-UploadPgpKeyTask$execute$42 = false;
            String $i$a$-require-UploadPgpKeyTask$execute$42 = StringsKt.trimIndent((String)"\n                The provided public keyring file does not start with '-----BEGIN PGP PUBLIC KEY BLOCK-----'.\n                Please make sure that the provided file contains a valid public key in armored ASCII format.\n            ");
            throw new IllegalArgumentException($i$a$-require-UploadPgpKeyTask$execute$42.toString());
        }
        Object $i$a$-require-UploadPgpKeyTask$execute$42 = URI.create((String)this.getKeyserver().get() + "/pks/add").toURL().openConnection();
        Intrinsics.checkNotNull((Object)$i$a$-require-UploadPgpKeyTask$execute$42, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection connection = (HttpURLConnection)$i$a$-require-UploadPgpKeyTask$execute$42;
        try {
            String string;
            Object object;
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setAllowUserInteraction(true);
            OutputStream outputStream = connection.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"connection.outputStream");
            $i$a$-require-UploadPgpKeyTask$execute$42 = outputStream;
            Charset charset = Charsets.UTF_8;
            $i$a$-require-UploadPgpKeyTask$execute$42 = new OutputStreamWriter((OutputStream)$i$a$-require-UploadPgpKeyTask$execute$42, charset);
            int n = 8192;
            $i$a$-require-UploadPgpKeyTask$execute$42 = $i$a$-require-UploadPgpKeyTask$execute$42 instanceof BufferedWriter ? (BufferedWriter)$i$a$-require-UploadPgpKeyTask$execute$42 : new BufferedWriter((Writer)$i$a$-require-UploadPgpKeyTask$execute$42, n);
            Object object2 = null;
            try {
                BufferedWriter it = (BufferedWriter)$i$a$-require-UploadPgpKeyTask$execute$42;
                boolean bl = false;
                it.write("keytext=");
                it.write(URLEncoder.encode(publicKeyringContent, StandardCharsets.UTF_8.toString()));
                it.write("&options=nm");
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$i$a$-require-UploadPgpKeyTask$execute$42, (Throwable)object2);
            }
            InputStream inputStream = connection.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"connection.inputStream");
            object2 = inputStream;
            object = Charsets.UTF_8;
            object2 = new InputStreamReader((InputStream)object2, (Charset)object);
            object = null;
            try {
                InputStreamReader it = (InputStreamReader)object2;
                boolean bl = false;
                string = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
            String result2 = string;
            System.out.println((Object)("Key upload successful. Server returned:\n" + result2));
        }
        catch (IOException e) {
            Object object = connection.getErrorStream();
            if (object != null) {
                Object object3;
                InputStream inputStream = object;
                Object object4 = Charsets.UTF_8;
                object4 = new InputStreamReader(inputStream, (Charset)object4);
                Throwable throwable = null;
                try {
                    Object it = (InputStreamReader)object4;
                    boolean bl = false;
                    it = TextStreamsKt.readText((Reader)((Reader)it));
                    object3 = it;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object4, (Throwable)throwable);
                }
                object = object3;
                if (object3 != null) {
                    Object result3 = object4 = object;
                    boolean bl = false;
                    System.out.println((Object)("Failed to upload public key. Server returned:\n" + (String)result3));
                }
            }
            throw e;
        }
        finally {
            connection.disconnect();
        }
    }
}

