/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks.configuration;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KaptExtensionConfig;
import org.jetbrains.kotlin.gradle.internal.KaptGenerateStubsTask;
import org.jetbrains.kotlin.gradle.internal.KaptTask;
import org.jetbrains.kotlin.gradle.internal.kapt.KaptProperties;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.StructureTransformAction;
import org.jetbrains.kotlin.gradle.tasks.configuration.KaptConfig;
import org.jetbrains.kotlin.gradle.tasks.configuration.KaptConfigKt;
import org.jetbrains.kotlin.gradle.tasks.configuration.TaskConfigAction;
import org.jetbrains.kotlin.gradle.utils.ConfigurationsKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ-\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00110\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010H\u0000\u00a2\u0006\u0002\b\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/configuration/KaptConfig;", "TASK", "Lorg/jetbrains/kotlin/gradle/internal/KaptTask;", "Lorg/jetbrains/kotlin/gradle/tasks/configuration/TaskConfigAction;", "project", "Lorg/gradle/api/Project;", "kaptGenerateStubsTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/jetbrains/kotlin/gradle/internal/KaptGenerateStubsTask;", "ext", "Lorg/jetbrains/kotlin/gradle/dsl/KaptExtensionConfig;", "(Lorg/gradle/api/Project;Lorg/gradle/api/tasks/TaskProvider;Lorg/jetbrains/kotlin/gradle/dsl/KaptExtensionConfig;)V", "(Lorg/gradle/api/Project;Lorg/jetbrains/kotlin/gradle/dsl/KaptExtensionConfig;)V", "getExt", "()Lorg/jetbrains/kotlin/gradle/dsl/KaptExtensionConfig;", "getJavaOptions", "Lorg/gradle/api/provider/Provider;", "", "", "defaultJavaSourceCompatibility", "getJavaOptions$kotlin_gradle_plugin_common", "getKaptClasspathSnapshot", "Lorg/gradle/api/file/FileCollection;", "taskProvider", "maybeRegisterTransform", "", "kotlin-gradle-plugin_common"})
public class KaptConfig<TASK extends KaptTask>
extends TaskConfigAction<TASK> {
    @NotNull
    private final KaptExtensionConfig ext;

    public KaptConfig(final @NotNull Project project, @NotNull KaptExtensionConfig ext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        super(project);
        this.ext = ext;
        this.configureTaskProvider((Function1)new Function1<TaskProvider<TASK>, Unit>(){

            public final void invoke(TaskProvider<TASK> taskProvider2) {
                Intrinsics.checkNotNullParameter(taskProvider2, (String)"taskProvider");
                final FileCollection kaptClasspathSnapshot = this.getKaptClasspathSnapshot(taskProvider2);
                taskProvider2.configure(new Action(){

                    public final void execute(final TASK task2) {
                        ((KaptTask)task2).getVerbose().set(KaptTask.Companion.queryKaptVerboseProperty$kotlin_gradle_plugin_common(project));
                        Object object = KaptProperties.INSTANCE.isIncrementalKapt(project).get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"KaptProperties.isIncrementalKapt(project).get()");
                        ((KaptTask)task2).setIncremental$kotlin_gradle_plugin_common((Boolean)object);
                        ((KaptTask)task2).setUseBuildCache(this.getExt().getUseBuildCache());
                        ((KaptTask)task2).getIncludeCompileClasspath().set(project.provider(new Callable(){

                            public final Boolean call() {
                                return this.getExt().getIncludeCompileClasspath();
                            }
                        }).orElse(KaptProperties.INSTANCE.isIncludeCompileClasspath(project)));
                        Object[] objectArray = new Object[]{kaptClasspathSnapshot};
                        ((KaptTask)task2).getClasspathStructure().from(objectArray);
                        objectArray = new Object[]{new Function0<Directory>(){

                            public final Directory invoke() {
                                return (Directory)task2.getIncAptCache().getOrNull();
                            }
                        }};
                        task2.getLocalStateDirectories().from(objectArray);
                        task2.onlyIf((Spec)3.INSTANCE);
                    }
                });
            }
        });
    }

    @NotNull
    protected final KaptExtensionConfig getExt() {
        return this.ext;
    }

    public KaptConfig(@NotNull Project project, final @NotNull TaskProvider<KaptGenerateStubsTask> kaptGenerateStubsTask, @NotNull KaptExtensionConfig ext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(kaptGenerateStubsTask, (String)"kaptGenerateStubsTask");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        this(project, ext);
        this.configureTask((Function1)new Function1<TASK, Unit>(){

            public final void invoke(TASK task2) {
                Intrinsics.checkNotNullParameter(task2, (String)"task");
                Object[] objectArray = new Object[]{kaptGenerateStubsTask.map((Transformer)1.INSTANCE)};
                task2.getClasspath().from(objectArray);
                objectArray = new Object[]{kaptGenerateStubsTask.flatMap((Transformer)2.INSTANCE), new Function0<DirectoryProperty>(){

                    public final DirectoryProperty invoke() {
                        DirectoryProperty directoryProperty;
                        DirectoryProperty it = directoryProperty = ((KaptGenerateStubsTask)kaptGenerateStubsTask.get()).getJavaOutputDir$kotlin_gradle_plugin_common();
                        boolean bl = false;
                        return it.isPresent() ? directoryProperty : null;
                    }
                }};
                task2.getCompiledSources().from(objectArray).disallowChanges();
                task2.getSourceSetName().value(kaptGenerateStubsTask.flatMap((Transformer)4.INSTANCE)).disallowChanges();
                Object[] objectArray2 = new Object[]{kaptGenerateStubsTask.map((Transformer)kaptSources.1.INSTANCE), task2.getStubsDir()};
                FileCollection kaptSources2 = this.getObjectFactory().fileCollection().from(objectArray2).getAsFileTree().matching((Action)kaptSources.2.INSTANCE).filter(new Spec(task2){
                    final /* synthetic */ TASK $task;
                    {
                        this.$task = $task;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isSatisfiedBy(File it) {
                        if (!it.exists()) return false;
                        File file2 = ((Directory)this.$task.getDestinationDir().get()).getAsFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"task.destinationDir.get().asFile");
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (KaptConfigKt.access$isAncestor(file2, it)) return false;
                        File file3 = ((Directory)this.$task.getClassesDir().get()).getAsFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"task.classesDir.get().asFile");
                        if (KaptConfigKt.access$isAncestor(file3, it)) return false;
                        return true;
                    }
                });
                objectArray2 = new Object[]{kaptSources2};
                task2.getSource().from(objectArray2).disallowChanges();
            }
        });
    }

    private final FileCollection getKaptClasspathSnapshot(TaskProvider<TASK> taskProvider2) {
        FileCollection fileCollection;
        Object object = KaptProperties.INSTANCE.isIncrementalKapt(this.getProject()).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"KaptProperties.isIncrementalKapt(project).get()");
        if (((Boolean)object).booleanValue()) {
            this.maybeRegisterTransform(this.getProject());
            ConfigurationContainer configurationContainer = this.getProject().getConfigurations();
            Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
            Configuration classStructureConfiguration = ConfigurationsKt.detachedResolvable(configurationContainer, new Dependency[0]);
            Object[] objectArray = new Object[]{this.getProject().provider(new Callable(taskProvider2){
                final /* synthetic */ TaskProvider<TASK> $taskProvider;
                {
                    this.$taskProvider = $taskProvider;
                }

                public final ConfigurableFileCollection call() {
                    return ((KaptTask)this.$taskProvider.get()).getClasspath();
                }
            })};
            classStructureConfiguration.getDependencies().add((Object)this.getProject().getDependencies().create((Object)this.getProject().files(objectArray)));
            fileCollection = classStructureConfiguration.getIncoming().artifactView((Action)getKaptClasspathSnapshot.2.INSTANCE).getFiles();
        } else {
            fileCollection = null;
        }
        return fileCollection;
    }

    private final void maybeRegisterTransform(Project project) {
        if (!project.getExtensions().getExtraProperties().has("KaptStructureTransformAdded")) {
            project.getDependencies().registerTransform(StructureTransformAction.class, (Action)maybeRegisterTransform.1.INSTANCE);
            project.getDependencies().registerTransform(StructureTransformAction.class, (Action)maybeRegisterTransform.2.INSTANCE);
            project.getExtensions().getExtraProperties().set("KaptStructureTransformAdded", (Object)true);
        }
    }

    @NotNull
    public final Provider<Map<String, String>> getJavaOptions$kotlin_gradle_plugin_common(@NotNull Provider<String> defaultJavaSourceCompatibility) {
        Intrinsics.checkNotNullParameter(defaultJavaSourceCompatibility, (String)"defaultJavaSourceCompatibility");
        Provider provider = this.getProviders().provider(new Callable(this, defaultJavaSourceCompatibility){
            final /* synthetic */ KaptConfig<TASK> this$0;
            final /* synthetic */ Provider<String> $defaultJavaSourceCompatibility;
            {
                this.this$0 = $receiver;
                this.$defaultJavaSourceCompatibility = $defaultJavaSourceCompatibility;
            }

            public final Map<String, String> call() {
                Map map = MapsKt.toMutableMap((Map)this.this$0.getExt().getJavacOptions());
                Provider<String> provider = this.$defaultJavaSourceCompatibility;
                Map result2 = map;
                boolean bl = false;
                if (!result2.containsKey("-source") && !result2.containsKey("--source") && !result2.containsKey("--release") && provider.isPresent()) {
                    String string = System.getProperty("java.version");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"java.version\")");
                    char[] cArray = new char[]{'.'};
                    boolean atLeast12Java = Integer.parseInt((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null))) >= 12;
                    String sourceOptionKey = atLeast12Java ? "--source" : "-source";
                    Map map2 = result2;
                    Object object = provider.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"defaultJavaSourceCompatibility.get()");
                    Object object2 = object;
                    map2.put(sourceOptionKey, object2);
                }
                return map;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"internal fun getJavaOpti\u2026        }\n        }\n    }");
        return provider;
    }
}

