/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.graph;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.HashMultiset;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.com.google.common.collect.Multiset;
import org.jetbrains.kotlin.com.google.common.graph.AbstractDirectedNetworkConnections;
import org.jetbrains.kotlin.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.graph.MultiEdgesConnecting;
import org.jetbrains.kotlin.com.google.errorprone.annotations.concurrent.LazyInit;

@ElementTypesAreNonnullByDefault
final class DirectedMultiNetworkConnections<N, E>
extends AbstractDirectedNetworkConnections<N, E> {
    @CheckForNull
    @LazyInit
    private transient Reference<Multiset<N>> predecessorsReference;
    @CheckForNull
    @LazyInit
    private transient Reference<Multiset<N>> successorsReference;

    private DirectedMultiNetworkConnections(Map<E, N> inEdges, Map<E, N> outEdges, int selfLoopCount) {
        super(inEdges, outEdges, selfLoopCount);
    }

    static <N, E> DirectedMultiNetworkConnections<N, E> of() {
        return new DirectedMultiNetworkConnections(new HashMap(2, 1.0f), new HashMap(2, 1.0f), 0);
    }

    static <N, E> DirectedMultiNetworkConnections<N, E> ofImmutable(Map<E, N> inEdges, Map<E, N> outEdges, int selfLoopCount) {
        return new DirectedMultiNetworkConnections<N, E>(ImmutableMap.copyOf(inEdges), ImmutableMap.copyOf(outEdges), selfLoopCount);
    }

    @Override
    public Set<N> predecessors() {
        return Collections.unmodifiableSet(this.predecessorsMultiset().elementSet());
    }

    private Multiset<N> predecessorsMultiset() {
        Multiset<N> predecessors = DirectedMultiNetworkConnections.getReference(this.predecessorsReference);
        if (predecessors == null) {
            predecessors = HashMultiset.create(this.inEdgeMap.values());
            this.predecessorsReference = new SoftReference<Multiset<N>>(predecessors);
        }
        return predecessors;
    }

    @Override
    public Set<N> successors() {
        return Collections.unmodifiableSet(this.successorsMultiset().elementSet());
    }

    private Multiset<N> successorsMultiset() {
        Multiset<N> successors = DirectedMultiNetworkConnections.getReference(this.successorsReference);
        if (successors == null) {
            successors = HashMultiset.create(this.outEdgeMap.values());
            this.successorsReference = new SoftReference<Multiset<N>>(successors);
        }
        return successors;
    }

    @Override
    public Set<E> edgesConnecting(final N node2) {
        return new MultiEdgesConnecting<E>(this, this.outEdgeMap, node2){
            final /* synthetic */ DirectedMultiNetworkConnections this$0;
            {
                this.this$0 = this$0;
                super(outEdgeToNode, targetNode);
            }

            @Override
            public int size() {
                return this.this$0.successorsMultiset().count(node2);
            }
        };
    }

    @Override
    public N removeInEdge(E edge, boolean isSelfLoop) {
        Object node2 = super.removeInEdge(edge, isSelfLoop);
        Multiset<N> predecessors = DirectedMultiNetworkConnections.getReference(this.predecessorsReference);
        if (predecessors != null) {
            Preconditions.checkState(predecessors.remove(node2));
        }
        return node2;
    }

    @Override
    public N removeOutEdge(E edge) {
        Object node2 = super.removeOutEdge(edge);
        Multiset<N> successors = DirectedMultiNetworkConnections.getReference(this.successorsReference);
        if (successors != null) {
            Preconditions.checkState(successors.remove(node2));
        }
        return node2;
    }

    @Override
    public void addInEdge(E edge, N node2, boolean isSelfLoop) {
        super.addInEdge(edge, node2, isSelfLoop);
        Multiset<N> predecessors = DirectedMultiNetworkConnections.getReference(this.predecessorsReference);
        if (predecessors != null) {
            Preconditions.checkState(predecessors.add(node2));
        }
    }

    @Override
    public void addOutEdge(E edge, N node2) {
        super.addOutEdge(edge, node2);
        Multiset<N> successors = DirectedMultiNetworkConnections.getReference(this.successorsReference);
        if (successors != null) {
            Preconditions.checkState(successors.add(node2));
        }
    }

    @CheckForNull
    private static <T> T getReference(@CheckForNull Reference<T> reference) {
        return reference == null ? null : (T)reference.get();
    }
}

