/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.tasks.internal.CleanableStore;
import org.jetbrains.kotlin.gradle.tasks.internal.DownloadedFile;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0096\u0002J\b\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/internal/CleanableStoreImpl;", "Lorg/jetbrains/kotlin/gradle/tasks/internal/CleanableStore;", "dirPath", "", "(Ljava/lang/String;)V", "dir", "Ljava/io/File;", "cleanDir", "", "expirationDate", "Ljava/time/Instant;", "get", "Lorg/jetbrains/kotlin/gradle/tasks/internal/DownloadedFile;", "fileName", "markUsed", "touchExisting", "file", "touchFileByWritingEmptyByteArray", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nCleanableStoreImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CleanableStoreImpl.kt\norg/jetbrains/kotlin/gradle/tasks/internal/CleanableStoreImpl\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n3829#2:63\n4344#2,2:64\n1863#3,2:66\n1#4:68\n*S KotlinDebug\n*F\n+ 1 CleanableStoreImpl.kt\norg/jetbrains/kotlin/gradle/tasks/internal/CleanableStoreImpl\n*L\n34#1:63\n34#1:64,2\n37#1:66,2\n*E\n"})
public final class CleanableStoreImpl
implements CleanableStore {
    @NotNull
    private final File dir;

    public CleanableStoreImpl(@NotNull String dirPath) {
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        this.dir = new File(dirPath);
    }

    @Override
    @NotNull
    public DownloadedFile get(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return new DownloadedFile(this, FilesKt.resolve((File)this.dir, (String)fileName));
    }

    @Override
    public void markUsed() {
        if (this.dir.exists()) {
            this.touchExisting(this.dir);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void cleanDir(@NotNull Instant expirationDate) {
        Intrinsics.checkNotNullParameter((Object)expirationDate, (String)"expirationDate");
        File[] fileArray = this.dir.listFiles();
        if (fileArray != null) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void element$iv$iv;
                void file2 = element$iv$iv = $this$filterTo$iv$iv[j];
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                if (!CleanableStoreImpl.cleanDir$modificationDate((File)file2).isBefore(expirationDate)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file3 = (File)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"file");
                FilesKt.deleteRecursively((File)file3);
            }
        }
    }

    private final void touchExisting(File file2) {
        try {
            Files.setLastModifiedTime(file2.toPath(), FileTime.fromMillis(System.currentTimeMillis()));
        }
        catch (IOException e) {
            if (file2.isFile() && file2.length() == 0L) {
                this.touchFileByWritingEmptyByteArray(file2);
            }
            throw new UncheckedIOException("Could not update timestamp for " + file2, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void touchFileByWritingEmptyByteArray(File file2) {
        try {
            Closeable closeable = new FileOutputStream(file2);
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl = false;
                it.write(new byte[0]);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not update timestamp for " + file2, e);
        }
    }

    private static final Instant cleanDir$modificationDate(File file2) {
        Instant instant = Files.getLastModifiedTime(file2.toPath(), new LinkOption[0]).toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"getLastModifiedTime(file.toPath()).toInstant()");
        return instant;
    }
}

