/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks.abi;

import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.CharsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.abi.tools.api.AbiToolsFactory;
import org.jetbrains.kotlin.abi.tools.api.AbiToolsInterface;
import org.jetbrains.kotlin.gradle.internal.ClassLoadersCachingBuildService;
import org.jetbrains.kotlin.gradle.internal.UsesClassLoadersCachingBuildService;
import org.jetbrains.kotlin.gradle.tasks.abi.SharedClassLoaderProvider;

@DisableCachingByDefault(because="Abstract task")
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b!\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007J-\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H$R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/abi/AbiToolsTask;", "Lorg/gradle/api/DefaultTask;", "Lorg/jetbrains/kotlin/gradle/internal/UsesClassLoadersCachingBuildService;", "()V", "toolsClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getToolsClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "execute", "", "loadImplementation", "T", "", "cls", "Lkotlin/reflect/KClass;", "classLoader", "Ljava/lang/ClassLoader;", "(Lkotlin/reflect/KClass;Ljava/lang/ClassLoader;)Ljava/lang/Object;", "runTools", "tools", "Lorg/jetbrains/kotlin/abi/tools/api/AbiToolsInterface;", "Companion", "kotlin-gradle-plugin_common"})
public abstract class AbiToolsTask
extends DefaultTask
implements UsesClassLoadersCachingBuildService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getToolsClasspath();

    @TaskAction
    public final void execute() {
        Set set = this.getToolsClasspath().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toolsClasspath.files");
        List files2 = CollectionsKt.toList((Iterable)set);
        ClassLoader classLoader = ((ClassLoadersCachingBuildService)this.getClassLoadersCachingService().get()).getClassLoader(files2, SharedClassLoaderProvider.INSTANCE);
        AbiToolsFactory factory2 = (AbiToolsFactory)this.loadImplementation(Reflection.getOrCreateKotlinClass(AbiToolsFactory.class), classLoader);
        this.runTools(factory2.get());
    }

    protected abstract void runTools(@NotNull AbiToolsInterface var1);

    private final <T> T loadImplementation(KClass<T> cls, ClassLoader classLoader) {
        ServiceLoader implementations = ServiceLoader.load(JvmClassMappingKt.getJavaClass(cls), classLoader);
        Intrinsics.checkNotNullExpressionValue(implementations, (String)"implementations");
        if (CollectionsKt.firstOrNull((Iterable)implementations) == null) {
            throw new IllegalStateException(("The classpath contains no implementation for " + cls.getQualifiedName()).toString());
        }
        Object object = CollectionsKt.singleOrNull((Iterable)implementations);
        if (object == null) {
            throw new IllegalStateException(("The classpath contains more than one implementation for " + cls.getQualifiedName()).toString());
        }
        return (T)object;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/abi/AbiToolsTask$Companion;", "", "()V", "composeTaskName", "", "baseName", "variantName", "composeTaskName$kotlin_gradle_plugin_common", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nAbiToolsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbiToolsTask.kt\norg/jetbrains/kotlin/gradle/tasks/abi/AbiToolsTask$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String composeTaskName$kotlin_gradle_plugin_common(@NotNull String baseName2, @NotNull String variantName) {
            String string;
            Intrinsics.checkNotNullParameter((Object)baseName2, (String)"baseName");
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            if (Intrinsics.areEqual((Object)variantName, (Object)"main")) {
                string = "";
            } else {
                String string2 = variantName;
                if (((CharSequence)string2).length() > 0) {
                    String string3;
                    void it;
                    char c = string2.charAt(0);
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl = false;
                    if (Character.isLowerCase((char)it)) {
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                        string3 = CharsKt.titlecase((char)it, (Locale)locale);
                    } else {
                        string3 = String.valueOf((char)it);
                    }
                    StringBuilder stringBuilder2 = stringBuilder.append((Object)string3);
                    String string4 = string2;
                    int n = 1;
                    String string5 = string4.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    string = stringBuilder2.append(string5).toString();
                } else {
                    string = string2;
                }
            }
            String suffix = string;
            return baseName2 + suffix;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

