/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.Segment;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.ByteCode;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.CPClass;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.CPDouble;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.CPLong;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.ClassFileEntry;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.ConstantPoolEntry;

public class ClassConstantPool {
    protected HashSet<ClassFileEntry> entriesContainsSet = new HashSet();
    protected HashSet<ClassFileEntry> othersContainsSet = new HashSet();
    private final HashSet<ClassFileEntry> mustStartClassPool = new HashSet();
    protected Map<ClassFileEntry, Integer> indexCache;
    private final List<ClassFileEntry> others = new ArrayList<ClassFileEntry>(500);
    private final List<ClassFileEntry> entries = new ArrayList<ClassFileEntry>(500);
    private boolean resolved;

    public ClassFileEntry add(ClassFileEntry entry2) {
        if (entry2 instanceof ByteCode) {
            return null;
        }
        if (entry2 instanceof ConstantPoolEntry) {
            if (this.entriesContainsSet.add(entry2)) {
                this.entries.add(entry2);
            }
        } else if (this.othersContainsSet.add(entry2)) {
            this.others.add(entry2);
        }
        return entry2;
    }

    public void addNestedEntries() {
        boolean added = true;
        ArrayList<ClassFileEntry> parents = new ArrayList<ClassFileEntry>(512);
        ArrayList<ClassFileEntry> children = new ArrayList<ClassFileEntry>(512);
        parents.addAll(this.entries);
        parents.addAll(this.others);
        while (added || parents.size() > 0) {
            children.clear();
            int entriesOriginalSize = this.entries.size();
            int othersOriginalSize = this.others.size();
            for (int indexParents = 0; indexParents < parents.size(); ++indexParents) {
                boolean isAtStart;
                ClassFileEntry entry2 = (ClassFileEntry)parents.get(indexParents);
                ClassFileEntry[] entryChildren = entry2.getNestedClassFileEntries();
                children.addAll(Arrays.asList(entryChildren));
                boolean bl = isAtStart = entry2 instanceof ByteCode && ((ByteCode)entry2).nestedMustStartClassPool();
                if (isAtStart) {
                    this.mustStartClassPool.addAll(Arrays.asList(entryChildren));
                }
                this.add(entry2);
            }
            added = this.entries.size() != entriesOriginalSize || this.others.size() != othersOriginalSize;
            parents.clear();
            parents.addAll(children);
        }
    }

    public ClassFileEntry addWithNestedEntries(ClassFileEntry entry2) {
        this.add(entry2);
        for (ClassFileEntry nestedEntry : entry2.getNestedClassFileEntries()) {
            this.addWithNestedEntries(nestedEntry);
        }
        return entry2;
    }

    public List<ClassFileEntry> entries() {
        return Collections.unmodifiableList(this.entries);
    }

    public ClassFileEntry get(int i2) {
        if (!this.resolved) {
            throw new IllegalStateException("Constant pool is not yet resolved; this does not make any sense");
        }
        return this.entries.get(--i2);
    }

    public int indexOf(ClassFileEntry entry2) {
        if (!this.resolved) {
            throw new IllegalStateException("Constant pool is not yet resolved; this does not make any sense");
        }
        if (null == this.indexCache) {
            throw new IllegalStateException("Index cache is not initialized!");
        }
        Integer entryIndex = this.indexCache.get(entry2);
        if (entryIndex != null) {
            return entryIndex + 1;
        }
        return -1;
    }

    private void initialSort() {
        TreeSet<ClassFileEntry> inCpAll = new TreeSet<ClassFileEntry>(Comparator.comparingInt(arg0 -> ((ConstantPoolEntry)arg0).getGlobalIndex()));
        TreeSet<ClassFileEntry> cpUtf8sNotInCpAll = new TreeSet<ClassFileEntry>(Comparator.comparing(arg0 -> ((CPUTF8)arg0).underlyingString()));
        TreeSet<ClassFileEntry> cpClassesNotInCpAll = new TreeSet<ClassFileEntry>(Comparator.comparing(arg0 -> ((CPClass)arg0).getName()));
        for (ClassFileEntry entry2 : this.entries) {
            ConstantPoolEntry entry3 = (ConstantPoolEntry)entry2;
            if (entry3.getGlobalIndex() == -1) {
                if (entry3 instanceof CPUTF8) {
                    cpUtf8sNotInCpAll.add(entry3);
                    continue;
                }
                if (entry3 instanceof CPClass) {
                    cpClassesNotInCpAll.add(entry3);
                    continue;
                }
                throw new Error("error");
            }
            inCpAll.add(entry3);
        }
        this.entries.clear();
        this.entries.addAll(inCpAll);
        this.entries.addAll(cpUtf8sNotInCpAll);
        this.entries.addAll(cpClassesNotInCpAll);
    }

    public void resolve(Segment segment) {
        this.initialSort();
        this.sortClassPool();
        this.resolved = true;
        this.entries.forEach(entry2 -> entry2.resolve(this));
        this.others.forEach(entry2 -> entry2.resolve(this));
    }

    public int size() {
        return this.entries.size();
    }

    protected void sortClassPool() {
        ArrayList<ClassFileEntry> startOfPool = new ArrayList<ClassFileEntry>(this.entries.size());
        ArrayList<ClassFileEntry> finalSort = new ArrayList<ClassFileEntry>(this.entries.size());
        for (ClassFileEntry entry2 : this.entries) {
            if (this.mustStartClassPool.contains(entry2)) {
                startOfPool.add(entry2);
                continue;
            }
            finalSort.add(entry2);
        }
        this.indexCache = new HashMap<ClassFileEntry, Integer>(this.entries.size());
        int index = 0;
        this.entries.clear();
        for (ClassFileEntry entry3 : startOfPool) {
            this.indexCache.put(entry3, index);
            if (entry3 instanceof CPLong || entry3 instanceof CPDouble) {
                this.entries.add(entry3);
                this.entries.add(entry3);
                index += 2;
                continue;
            }
            this.entries.add(entry3);
            ++index;
        }
        for (ClassFileEntry entry3 : finalSort) {
            this.indexCache.put(entry3, index);
            if (entry3 instanceof CPLong || entry3 instanceof CPDouble) {
                this.entries.add(entry3);
                this.entries.add(entry3);
                index += 2;
                continue;
            }
            this.entries.add(entry3);
            ++index;
        }
    }
}

