/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.ir.builders;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrVariable;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.impl.BuildersKt;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.gradle.internal.ir.expressions.IrExpression;
import org.jetbrains.kotlin.gradle.internal.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.gradle.internal.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.gradle.internal.ir.types.IrType;
import org.jetbrains.kotlin.gradle.internal.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\f\u001a\u00020\u000bH\u0002J\u001c\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0002J>\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bJN\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u001a\u001a\u00020\u000b2\b\b\u0002\u0010\u001b\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ir/builders/Scope;", "", "scopeOwnerSymbol", "Lorg/jetbrains/kotlin/gradle/internal/ir/symbols/IrSymbol;", "<init>", "(Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)V", "getScopeOwnerSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getLocalDeclarationParent", "Lorg/jetbrains/kotlin/gradle/internal/ir/declarations/IrDeclarationParent;", "lastTemporaryIndex", "", "nextTemporaryIndex", "inventNameForTemporary", "", "prefix", "nameHint", "getNameForTemporary", "createTemporaryVariableDeclaration", "Lorg/jetbrains/kotlin/gradle/internal/ir/declarations/IrVariable;", "irType", "Lorg/jetbrains/kotlin/gradle/internal/ir/types/IrType;", "isMutable", "", "origin", "Lorg/jetbrains/kotlin/gradle/internal/ir/declarations/IrDeclarationOrigin;", "startOffset", "endOffset", "createTemporaryVariable", "irExpression", "Lorg/jetbrains/kotlin/gradle/internal/ir/expressions/IrExpression;", "ir.tree"})
public final class Scope {
    @NotNull
    private final IrSymbol scopeOwnerSymbol;
    private int lastTemporaryIndex;

    public Scope(@NotNull IrSymbol scopeOwnerSymbol) {
        Intrinsics.checkNotNullParameter((Object)scopeOwnerSymbol, (String)"scopeOwnerSymbol");
        this.scopeOwnerSymbol = scopeOwnerSymbol;
    }

    @NotNull
    public final IrSymbol getScopeOwnerSymbol() {
        return this.scopeOwnerSymbol;
    }

    @NotNull
    public final IrDeclarationParent getLocalDeclarationParent() {
        IrDeclarationParent irDeclarationParent;
        if (!this.scopeOwnerSymbol.isBound()) {
            throw new AssertionError((Object)("Unbound symbol: " + this.scopeOwnerSymbol));
        }
        IrSymbolOwner scopeOwnerElement = this.scopeOwnerSymbol.getOwner();
        if (scopeOwnerElement instanceof IrDeclarationParent) {
            irDeclarationParent = (IrDeclarationParent)((Object)scopeOwnerElement);
        } else {
            if (!(scopeOwnerElement instanceof IrDeclaration)) {
                throw new AssertionError((Object)("Not a declaration: " + scopeOwnerElement));
            }
            irDeclarationParent = ((IrDeclaration)scopeOwnerElement).getParent();
        }
        return irDeclarationParent;
    }

    private final int nextTemporaryIndex() {
        int n = this.lastTemporaryIndex;
        this.lastTemporaryIndex = n + 1;
        return n;
    }

    @NotNull
    public final String inventNameForTemporary(@NotNull String prefix, @Nullable String nameHint) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        int index = this.nextTemporaryIndex();
        return nameHint != null ? prefix + index + '_' + nameHint : prefix + index;
    }

    public static /* synthetic */ String inventNameForTemporary$default(Scope scope, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "tmp";
        }
        if ((n & 2) != 0) {
            string3 = null;
        }
        return scope.inventNameForTemporary(string2, string3);
    }

    private final String getNameForTemporary(String nameHint) {
        return this.inventNameForTemporary("tmp", nameHint);
    }

    @NotNull
    public final IrVariable createTemporaryVariableDeclaration(@NotNull IrType irType, @Nullable String nameHint, boolean isMutable, @NotNull IrDeclarationOrigin origin, int startOffset, int endOffset) {
        IrVariableImpl irVariableImpl;
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Name name = Name.identifier(this.getNameForTemporary(nameHint));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        Name name2 = name;
        IrVariableImpl $this$createTemporaryVariableDeclaration_u24lambda_u240 = irVariableImpl = BuildersKt.IrVariableImpl(startOffset, endOffset, origin, new IrVariableSymbolImpl(null, 1, null), name2, irType, isMutable, false, false);
        boolean bl = false;
        $this$createTemporaryVariableDeclaration_u24lambda_u240.setParent(this.getLocalDeclarationParent());
        return irVariableImpl;
    }

    public static /* synthetic */ IrVariable createTemporaryVariableDeclaration$default(Scope scope, IrType irType, String string2, boolean bl, IrDeclarationOrigin irDeclarationOrigin, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string2 = null;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            irDeclarationOrigin = IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE();
        }
        return scope.createTemporaryVariableDeclaration(irType, string2, bl, irDeclarationOrigin, n, n2);
    }

    @NotNull
    public final IrVariable createTemporaryVariable(@NotNull IrExpression irExpression, @Nullable String nameHint, boolean isMutable, @NotNull IrDeclarationOrigin origin, @Nullable IrType irType, int startOffset, int endOffset) {
        IrVariable irVariable;
        Intrinsics.checkNotNullParameter((Object)irExpression, (String)"irExpression");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        IrType irType2 = irType;
        if (irType2 == null) {
            irType2 = irExpression.getType();
        }
        IrVariable $this$createTemporaryVariable_u24lambda_u241 = irVariable = this.createTemporaryVariableDeclaration(irType2, nameHint, isMutable, origin, startOffset, endOffset);
        boolean bl = false;
        $this$createTemporaryVariable_u24lambda_u241.setInitializer(irExpression);
        return irVariable;
    }

    public static /* synthetic */ IrVariable createTemporaryVariable$default(Scope scope, IrExpression irExpression, String string2, boolean bl, IrDeclarationOrigin irDeclarationOrigin, IrType irType, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string2 = null;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            irDeclarationOrigin = IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE();
        }
        if ((n3 & 0x10) != 0) {
            irType = null;
        }
        if ((n3 & 0x20) != 0) {
            n = irExpression.getStartOffset();
        }
        if ((n3 & 0x40) != 0) {
            n2 = irExpression.getEndOffset();
        }
        return scope.createTemporaryVariable(irExpression, string2, bl, irDeclarationOrigin, irType, n, n2);
    }
}

