/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.graph;

import java.util.Objects;
import java.util.OptionalInt;
import org.jetbrains.kotlin.com.intellij.util.graph.ElementOrder;
import org.jetbrains.kotlin.com.intellij.util.graph.MutableNetwork;

public abstract class NetworkBuilder<N, E> {
    protected final boolean myIsDirected;
    protected boolean myDoAllowParallelEdges = false;
    protected boolean myDoAllowSelfLoops = false;
    protected ElementOrder<N> myNodeOrder = ElementOrder.insertion();
    protected ElementOrder<? super E> myEdgeOrder = ElementOrder.insertion();
    protected ElementOrder<N> myIncidentEdgeOrder = ElementOrder.unordered();
    protected OptionalInt myExpectedNodeCount = OptionalInt.empty();
    protected OptionalInt myExpectedEdgeCount = OptionalInt.empty();

    protected NetworkBuilder(boolean directed) {
        this.myIsDirected = directed;
    }

    public NetworkBuilder<N, E> allowsParallelEdges(boolean allowsParallelEdges) {
        this.myDoAllowParallelEdges = allowsParallelEdges;
        return this;
    }

    public NetworkBuilder<N, E> allowsSelfLoops(boolean allowsSelfLoops) {
        this.myDoAllowSelfLoops = allowsSelfLoops;
        return this;
    }

    public NetworkBuilder<N, E> expectedNodeCount(int expectedNodeCount) {
        assert (expectedNodeCount >= 0);
        this.myExpectedNodeCount = OptionalInt.of(expectedNodeCount);
        return this;
    }

    public NetworkBuilder<N, E> expectedEdgeCount(int expectedEdgeCount) {
        assert (expectedEdgeCount >= 0);
        this.myExpectedEdgeCount = OptionalInt.of(expectedEdgeCount);
        return this;
    }

    public <N1 extends N> NetworkBuilder<N1, E> nodeOrder(ElementOrder<N1> nodeOrder) {
        NetworkBuilder newBuilder = this.cast();
        newBuilder.myNodeOrder = Objects.requireNonNull(nodeOrder);
        return newBuilder;
    }

    public <E1 extends E> NetworkBuilder<N, E1> edgeOrder(ElementOrder<E1> edgeOrder) {
        NetworkBuilder newBuilder = this.cast();
        newBuilder.myEdgeOrder = Objects.requireNonNull(edgeOrder);
        return newBuilder;
    }

    public abstract <N1 extends N, E1 extends E> MutableNetwork<N1, E1> build();

    private <N1 extends N, E1 extends E> NetworkBuilder<N1, E1> cast() {
        return this;
    }
}

