/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.ControlFlowException;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.DifferenceFilter;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtilRt;
import org.jetbrains.kotlin.com.intellij.util.JBIterableClassTraverser;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtilRt;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public final class ReflectionUtil {
    private static final Logger LOG;
    private static final Object unsafe;

    private ReflectionUtil() {
    }

    @NotNull
    public static List<Field> collectFields(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(0);
        }
        ArrayList<Field> result2 = new ArrayList<Field>();
        for (Class clazz2 : JBIterableClassTraverser.classTraverser(clazz)) {
            Collections.addAll(result2, clazz2.getDeclaredFields());
        }
        ArrayList<Field> arrayList = result2;
        if (arrayList == null) {
            ReflectionUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static Field findField(@NotNull Class<?> clazz, @Nullable Class<?> type, @NotNull @NonNls String name) throws NoSuchFieldException {
        Field result2;
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(2);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(3);
        }
        if ((result2 = ReflectionUtil.findFieldInHierarchy(clazz, field -> name.equals(field.getName()) && (type == null || field.getType().equals(type)))) != null) {
            Field field2 = result2;
            if (field2 == null) {
                ReflectionUtil.$$$reportNull$$$0(4);
            }
            return field2;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type);
    }

    @NotNull
    public static Field findAssignableField(@NotNull Class<?> clazz, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<?> fieldType, @NotNull @NonNls String fieldName) throws NoSuchFieldException {
        Field result2;
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(5);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(6);
        }
        if ((result2 = ReflectionUtil.findFieldInHierarchy(clazz, field -> fieldName.equals(field.getName()) && (fieldType == null || fieldType.isAssignableFrom(field.getType())))) != null) {
            Field field2 = result2;
            if (field2 == null) {
                ReflectionUtil.$$$reportNull$$$0(7);
            }
            return field2;
        }
        throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + fieldName + " fieldType: " + fieldType);
    }

    @Nullable
    public static Field findFieldInHierarchy(@NotNull Class<?> rootClass, @NotNull Predicate<? super Field> checker) {
        if (rootClass == null) {
            ReflectionUtil.$$$reportNull$$$0(8);
        }
        if (checker == null) {
            ReflectionUtil.$$$reportNull$$$0(9);
        }
        for (Class<?> aClass = rootClass; aClass != null; aClass = aClass.getSuperclass()) {
            for (Field field : aClass.getDeclaredFields()) {
                if (!checker.test(field)) continue;
                field.setAccessible(true);
                return field;
            }
        }
        return ReflectionUtil.processInterfaces(rootClass.getInterfaces(), new HashSet(), checker);
    }

    @Nullable
    private static Field processInterfaces(Class<?> @NotNull [] interfaces, @NotNull Set<? super Class<?>> visited, @NotNull Predicate<? super Field> checker) {
        if (visited == null) {
            ReflectionUtil.$$$reportNull$$$0(10);
        }
        if (checker == null) {
            ReflectionUtil.$$$reportNull$$$0(11);
        }
        if (interfaces == null) {
            ReflectionUtil.$$$reportNull$$$0(12);
        }
        for (Class<?> anInterface : interfaces) {
            if (!visited.add(anInterface)) continue;
            for (Field field : anInterface.getDeclaredFields()) {
                if (!checker.test(field)) continue;
                field.setAccessible(true);
                return field;
            }
            Field field = ReflectionUtil.processInterfaces(anInterface.getInterfaces(), visited, checker);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public static void resetField(@NotNull Class<?> clazz, @Nullable(value="null means of any type") @Nullable(value="null means of any type") Class<?> type, @NotNull @NonNls String name) {
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(13);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(14);
        }
        try {
            ReflectionUtil.resetField(null, ReflectionUtil.findField(clazz, type, name));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static void resetField(@NotNull Object object, @NotNull @NonNls String name) {
        if (object == null) {
            ReflectionUtil.$$$reportNull$$$0(15);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(16);
        }
        try {
            ReflectionUtil.resetField(object, ReflectionUtil.findField(object.getClass(), null, name));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static void resetField(@Nullable Object object, @NotNull Field field) {
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(17);
        }
        field.setAccessible(true);
        Class<?> type = field.getType();
        try {
            if (type.isPrimitive()) {
                if (Boolean.TYPE.equals(type)) {
                    field.set(object, Boolean.FALSE);
                } else if (Integer.TYPE.equals(type)) {
                    field.set(object, 0);
                } else if (Double.TYPE.equals(type)) {
                    field.set(object, 0.0);
                } else if (Float.TYPE.equals(type)) {
                    field.set(object, Float.valueOf(0.0f));
                }
            } else {
                field.set(object, null);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static Method findMethod(@NotNull Collection<Method> methods, @NonNls @NotNull String name, Class<?> ... parameters) {
        if (methods == null) {
            ReflectionUtil.$$$reportNull$$$0(18);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(19);
        }
        if (parameters == null) {
            ReflectionUtil.$$$reportNull$$$0(20);
        }
        for (Method method : methods) {
            if (parameters.length != method.getParameterCount() || !name.equals(method.getName()) || !Arrays.equals(parameters, method.getParameterTypes())) continue;
            return ReflectionUtil.makeAccessible(method);
        }
        return null;
    }

    private static Method makeAccessible(Method method) {
        method.setAccessible(true);
        return method;
    }

    @Nullable
    public static Method getMethod(@NotNull Class<?> aClass, @NonNls @NotNull String name, Class<?> ... parameters) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(21);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(22);
        }
        if (parameters == null) {
            ReflectionUtil.$$$reportNull$$$0(23);
        }
        try {
            return ReflectionUtil.makeAccessible(aClass.getMethod(name, parameters));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Deprecated
    @Nullable
    public static Method getDeclaredMethod(@NotNull Class<?> aClass, @NonNls @NotNull String name, Class<?> ... parameters) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(24);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(25);
        }
        if (parameters == null) {
            ReflectionUtil.$$$reportNull$$$0(26);
        }
        try {
            return ReflectionUtil.makeAccessible(aClass.getDeclaredMethod(name, parameters));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Deprecated
    @Nullable
    public static Field getDeclaredField(@NotNull Class<?> aClass, @NonNls @NotNull String name) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(27);
        }
        if (name == null) {
            ReflectionUtil.$$$reportNull$$$0(28);
        }
        return ReflectionUtil.findFieldInHierarchy(aClass, field -> name.equals(field.getName()));
    }

    @NotNull
    public static List<Method> getClassPublicMethods(@NotNull Class<?> aClass) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(29);
        }
        return ReflectionUtil.filterRealMethods(aClass.getMethods());
    }

    @NotNull
    public static List<Method> getClassDeclaredMethods(@NotNull Class<?> aClass) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(30);
        }
        return ReflectionUtil.filterRealMethods(aClass.getDeclaredMethods());
    }

    @NotNull
    private static List<Method> filterRealMethods(Method @NotNull [] methods) {
        if (methods == null) {
            ReflectionUtil.$$$reportNull$$$0(31);
        }
        ArrayList<Method> result2 = new ArrayList<Method>();
        for (Method method : methods) {
            if (method.isSynthetic()) continue;
            result2.add(method);
        }
        ArrayList<Method> arrayList = result2;
        if (arrayList == null) {
            ReflectionUtil.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @Nullable
    public static Class<?> getMethodDeclaringClass(@NotNull Class<?> instanceClass, @NonNls @NotNull String methodName, Class<?> ... parameters) {
        if (instanceClass == null) {
            ReflectionUtil.$$$reportNull$$$0(33);
        }
        if (methodName == null) {
            ReflectionUtil.$$$reportNull$$$0(34);
        }
        if (parameters == null) {
            ReflectionUtil.$$$reportNull$$$0(35);
        }
        try {
            return instanceClass.getMethod(methodName, parameters).getDeclaringClass();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            while (instanceClass != null) {
                try {
                    return instanceClass.getDeclaredMethod(methodName, parameters).getDeclaringClass();
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    instanceClass = instanceClass.getSuperclass();
                }
            }
            return null;
        }
    }

    public static <T> T getField(@NotNull Class<?> objectClass, @Nullable Object object, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(36);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(37);
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            return ReflectionUtil.getFieldValue(field, object);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static <T> T getStaticFieldValue(@NotNull Class<?> objectClass, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(38);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(39);
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            if (ReflectionUtil.isInstanceField(field)) {
                throw new IllegalArgumentException("Field " + objectClass + "." + fieldName + " is not static");
            }
            return ReflectionUtil.getFieldValue(field, null);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
    }

    @Nullable
    public static <T> T getFieldValue(@NotNull Field field, @Nullable Object object) {
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(40);
        }
        try {
            return (T)field.get(object);
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static boolean isInstanceField(@NotNull Field field) {
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(41);
        }
        return !Modifier.isStatic(field.getModifiers());
    }

    public static <T> boolean setField(@NotNull Class<?> objectClass, Object object, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName, T value2) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(42);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(43);
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            field.set(object, value2);
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOG.debug(e);
            return false;
        }
    }

    @NotNull
    public static <T> Constructor<T> getDefaultConstructor(@NotNull Class<T> aClass) {
        Constructor<T> constructor;
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(44);
        }
        try {
            Constructor<T> constructor2 = aClass.getConstructor(new Class[0]);
            constructor2.setAccessible(true);
            constructor = constructor2;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No default constructor in " + aClass, e);
        }
        if (constructor == null) {
            ReflectionUtil.$$$reportNull$$$0(45);
        }
        return constructor;
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(46);
        }
        return ReflectionUtil.newInstance(aClass, true);
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass, boolean isKotlinDataClassesSupported) {
        T t;
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(47);
        }
        try {
            Constructor<T> constructor = aClass.getDeclaredConstructor(new Class[0]);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            t = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            T t2;
            Throwable targetException;
            if (e instanceof InvocationTargetException && (targetException = ((InvocationTargetException)e).getTargetException()) instanceof ControlFlowException && targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (isKotlinDataClassesSupported && (t2 = ReflectionUtil.createAsDataClass(aClass)) != null) {
                T t3 = t2;
                if (t3 == null) {
                    ReflectionUtil.$$$reportNull$$$0(49);
                }
                return t3;
            }
            ExceptionUtilRt.rethrowUnchecked(e);
            throw new RuntimeException(e);
        }
        if (t == null) {
            ReflectionUtil.$$$reportNull$$$0(48);
        }
        return t;
    }

    @Nullable
    private static <T> T createAsDataClass(@NotNull Class<T> aClass) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(50);
        }
        for (Annotation annotation : aClass.getAnnotations()) {
            String name = annotation.annotationType().getName();
            if (!name.equals("kotlin.Metadata") && !name.equals("kotlin.jvm.internal.KotlinClass")) continue;
            Constructor<?>[] constructors = aClass.getDeclaredConstructors();
            Exception exception = null;
            SmartList defaultCtors = new SmartList();
            for (Constructor<?> constructor : constructors) {
                try {
                    block15: {
                        Class<?>[] parameterTypes;
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (constructor.getParameterCount() == 0) {
                            return (T)constructor.newInstance(new Object[0]);
                        }
                        for (Class<?> type : parameterTypes = constructor.getParameterTypes()) {
                            if (!type.getName().equals("kotlin.jvm.internal.DefaultConstructorMarker")) {
                                continue;
                            }
                            break block15;
                        }
                        return (T)constructor.newInstance(new Object[parameterTypes.length]);
                    }
                    defaultCtors.add(constructor);
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            for (Constructor constructor : defaultCtors) {
                try {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            if (exception == null) continue;
            ExceptionUtil.rethrow(exception);
        }
        return null;
    }

    @NotNull
    public static <T> T createInstance(@NotNull Constructor<T> constructor, Object ... args2) {
        T t;
        if (constructor == null) {
            ReflectionUtil.$$$reportNull$$$0(51);
        }
        if (args2 == null) {
            ReflectionUtil.$$$reportNull$$$0(52);
        }
        try {
            t = constructor.newInstance(args2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (t == null) {
            ReflectionUtil.$$$reportNull$$$0(53);
        }
        return t;
    }

    @Nullable
    public static Class<?> getGrandCallerClass() {
        int stackFrameCount = 3;
        return ReflectionUtil.getCallerClass(stackFrameCount + 1);
    }

    public static Class<?> getCallerClass(int stackFrameCount) {
        Class<?> callerClass = ReflectionUtil.findCallerClass(stackFrameCount);
        int depth = stackFrameCount + 1;
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = ReflectionUtil.findCallerClass(depth);
            ++depth;
        }
        if (callerClass == null) {
            callerClass = ReflectionUtil.findCallerClass(stackFrameCount - 1);
        }
        return callerClass;
    }

    public static void copyFields(Field @NotNull [] fields, @NotNull Object from2, @NotNull Object to) {
        if (from2 == null) {
            ReflectionUtil.$$$reportNull$$$0(54);
        }
        if (to == null) {
            ReflectionUtil.$$$reportNull$$$0(55);
        }
        if (fields == null) {
            ReflectionUtil.$$$reportNull$$$0(56);
        }
        ReflectionUtil.copyFields(fields, from2, to, null);
    }

    public static void copyFields(Field @NotNull [] fields, @NotNull Object from2, @NotNull Object to, @Nullable DifferenceFilter<?> diffFilter) {
        if (from2 == null) {
            ReflectionUtil.$$$reportNull$$$0(57);
        }
        if (to == null) {
            ReflectionUtil.$$$reportNull$$$0(58);
        }
        if (fields == null) {
            ReflectionUtil.$$$reportNull$$$0(59);
        }
        HashSet<Field> sourceFields = new HashSet<Field>(Arrays.asList(from2.getClass().getFields()));
        for (Field field : fields) {
            if (!sourceFields.contains(field) || !ReflectionUtil.isPublic(field) || ReflectionUtil.isFinal(field)) continue;
            try {
                if (diffFilter != null && !diffFilter.test(field)) continue;
                ReflectionUtil.copyFieldValue(from2, to, field);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <T> boolean comparePublicNonFinalFields(@NotNull T first, @NotNull T second) {
        if (first == null) {
            ReflectionUtil.$$$reportNull$$$0(60);
        }
        if (second == null) {
            ReflectionUtil.$$$reportNull$$$0(61);
        }
        Class<?> defaultClass = first.getClass();
        Field[] fields = defaultClass.getDeclaredFields();
        if (defaultClass != second.getClass()) {
            fields = ArrayUtil.mergeArrays(fields, second.getClass().getDeclaredFields());
        }
        for (Field field : fields) {
            if (!ReflectionUtil.isPublic(field) || ReflectionUtil.isFinal(field)) continue;
            field.setAccessible(true);
            try {
                if (Comparing.equal(field.get(second), field.get(first))) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public static void copyFieldValue(@NotNull Object from2, @NotNull Object to, @NotNull Field field) throws IllegalAccessException {
        Class<?> fieldType;
        if (from2 == null) {
            ReflectionUtil.$$$reportNull$$$0(62);
        }
        if (to == null) {
            ReflectionUtil.$$$reportNull$$$0(63);
        }
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(64);
        }
        if (!((fieldType = field.getType()).isPrimitive() || fieldType.equals(String.class) || fieldType.isEnum())) {
            throw new RuntimeException("Field '" + field.getName() + "' not copied: unsupported type: " + field.getType());
        }
        field.set(to, field.get(from2));
    }

    private static boolean isPublic(@NotNull Field field) {
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(65);
        }
        return (field.getModifiers() & 1) != 0;
    }

    private static boolean isFinal(@NotNull Field field) {
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(66);
        }
        return (field.getModifiers() & 0x10) != 0;
    }

    @NotNull
    public static Class<?> forName(@NotNull String fqn) {
        Class<?> clazz;
        if (fqn == null) {
            ReflectionUtil.$$$reportNull$$$0(67);
        }
        try {
            clazz = Class.forName(fqn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(68);
        }
        return clazz;
    }

    @NotNull
    public static Class<?> boxType(@NotNull Class<?> type) {
        if (type == null) {
            ReflectionUtil.$$$reportNull$$$0(69);
        }
        if (!type.isPrimitive()) {
            Class<?> clazz = type;
            if (clazz == null) {
                ReflectionUtil.$$$reportNull$$$0(70);
            }
            return clazz;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        Class<?> clazz = type;
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(71);
        }
        return clazz;
    }

    @NotNull
    public static <T, V> Field getTheOnlyVolatileInstanceFieldOfClass(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        if (ownerClass == null) {
            ReflectionUtil.$$$reportNull$$$0(72);
        }
        if (fieldType == null) {
            ReflectionUtil.$$$reportNull$$$0(73);
        }
        Field[] declaredFields = ownerClass.getDeclaredFields();
        Field found = null;
        for (Field field : declaredFields) {
            int modifiers = field.getModifiers();
            if (BitUtil.isSet(modifiers, 8) || !BitUtil.isSet(modifiers, 64) || !fieldType.isAssignableFrom(field.getType())) continue;
            if (found == null) {
                found = field;
                continue;
            }
            throw new IllegalArgumentException("Two fields of " + fieldType + " found in the " + ownerClass + ": " + found + " and " + field);
        }
        if (found == null) {
            throw new IllegalArgumentException("No (non-static, non-final) field of " + fieldType + " found in the " + ownerClass);
        }
        Field field = found;
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(74);
        }
        return field;
    }

    @Deprecated
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static Object getUnsafe() {
        Object object = unsafe;
        if (object == null) {
            ReflectionUtil.$$$reportNull$$$0(75);
        }
        return object;
    }

    public static Class<?> findCallerClass(int framesToSkip) {
        return ReflectionUtilRt.findCallerClass(framesToSkip + 1);
    }

    public static boolean isAssignable(@NotNull Class<?> ancestor, @NotNull Class<?> descendant) {
        if (ancestor == null) {
            ReflectionUtil.$$$reportNull$$$0(76);
        }
        if (descendant == null) {
            ReflectionUtil.$$$reportNull$$$0(77);
        }
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    public static String dumpFields(@NotNull Class<?> objectClass, @Nullable Object object, String ... fieldNames) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(78);
        }
        SmartList<String> chunks = new SmartList<String>();
        for (String fieldName : fieldNames) {
            chunks.add(fieldName + "=" + ReflectionUtil.getField(objectClass, object, null, fieldName));
        }
        return String.join((CharSequence)"; ", chunks);
    }

    @NotNull
    public static <T> T proxy(@NotNull Class<? extends T> superInterface, @NotNull InvocationHandler handler) {
        if (superInterface == null) {
            ReflectionUtil.$$$reportNull$$$0(79);
        }
        if (handler == null) {
            ReflectionUtil.$$$reportNull$$$0(80);
        }
        T t = superInterface.cast(Proxy.newProxyInstance(superInterface.getClassLoader(), new Class[]{superInterface}, handler));
        if (t == null) {
            ReflectionUtil.$$$reportNull$$$0(81);
        }
        return t;
    }

    @NotNull
    public static <T> T proxy(@Nullable ClassLoader loader, @NotNull Class<? extends T> superInterface, @NotNull InvocationHandler handler) {
        if (superInterface == null) {
            ReflectionUtil.$$$reportNull$$$0(82);
        }
        if (handler == null) {
            ReflectionUtil.$$$reportNull$$$0(83);
        }
        T t = superInterface.cast(Proxy.newProxyInstance(loader, new Class[]{superInterface}, handler));
        if (t == null) {
            ReflectionUtil.$$$reportNull$$$0(84);
        }
        return t;
    }

    static {
        Class<?> unsafeClass;
        LOG = Logger.getInstance(ReflectionUtil.class);
        try {
            unsafeClass = Class.forName("sun.misc.Unsafe");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        unsafe = ReflectionUtil.getStaticFieldValue(unsafeClass, unsafeClass, "theUnsafe");
        if (unsafe == null) {
            throw new RuntimeException("Could not find 'theUnsafe' field in the Unsafe class");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 32: 
            case 45: 
            case 48: 
            case 49: 
            case 53: 
            case 68: 
            case 70: 
            case 71: 
            case 74: 
            case 75: 
            case 81: 
            case 84: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 32: 
            case 45: 
            case 48: 
            case 49: 
            case 53: 
            case 68: 
            case 70: 
            case 71: 
            case 74: 
            case 75: 
            case 81: 
            case 84: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 32: 
            case 45: 
            case 48: 
            case 49: 
            case 53: 
            case 68: 
            case 70: 
            case 71: 
            case 74: 
            case 75: 
            case 81: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil";
                break;
            }
            case 3: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 37: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootClass";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaces";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 17: 
            case 40: 
            case 41: 
            case 64: 
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 18: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 20: 
            case 23: 
            case 26: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 44: 
            case 46: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceClass";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 36: 
            case 38: 
            case 42: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectClass";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 54: 
            case 57: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 55: 
            case 58: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 79: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superInterface";
                break;
            }
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ReflectionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFields";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findField";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findAssignableField";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRealMethods";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConstructor";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "forName";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "boxType";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getTheOnlyVolatileInstanceFieldOfClass";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsafe";
                break;
            }
            case 81: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "proxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectFields";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 32: 
            case 45: 
            case 48: 
            case 49: 
            case 53: 
            case 68: 
            case 70: 
            case 71: 
            case 74: 
            case 75: 
            case 81: 
            case 84: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findField";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAssignableField";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFieldInHierarchy";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processInterfaces";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resetField";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getMethod";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredMethod";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredField";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getClassPublicMethods";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getClassDeclaredMethods";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "filterRealMethods";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDeclaringClass";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getStaticFieldValue";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getFieldValue";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceField";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setField";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConstructor";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createAsDataClass";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "copyFields";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "comparePublicNonFinalFields";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "copyFieldValue";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isPublic";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isFinal";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "forName";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "boxType";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getTheOnlyVolatileInstanceFieldOfClass";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "dumpFields";
                break;
            }
            case 79: 
            case 80: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "proxy";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 32: 
            case 45: 
            case 48: 
            case 49: 
            case 53: 
            case 68: 
            case 70: 
            case 71: 
            case 74: 
            case 75: 
            case 81: 
            case 84: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

