/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.execution.process;

import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.execution.process.BaseProcessHandler;
import org.jetbrains.kotlin.com.intellij.execution.process.ProcessAdapter;
import org.jetbrains.kotlin.com.intellij.execution.process.ProcessEvent;
import org.jetbrains.kotlin.com.intellij.execution.process.ProcessIOExecutorService;
import org.jetbrains.kotlin.com.intellij.execution.process.ProcessOutputTypes;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.io.BaseDataReader;
import org.jetbrains.kotlin.com.intellij.util.io.BaseInputStreamReader;
import org.jetbrains.kotlin.com.intellij.util.io.BaseOutputReader;

public class BaseOSProcessHandler
extends BaseProcessHandler<Process> {
    private static final Logger LOG = Logger.getInstance(BaseOSProcessHandler.class);
    private final AtomicLong mySleepStart;
    private final Throwable myProcessStart;

    public BaseOSProcessHandler(@NotNull Process process, String commandLine, @Nullable Charset charset) {
        if (process == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(0);
        }
        super(process, commandLine, charset);
        this.mySleepStart = new AtomicLong(System.currentTimeMillis());
        this.myProcessStart = new Throwable("Process creation:");
    }

    @Override
    @NotNull
    public Future<?> executeTask(@NotNull Runnable task2) {
        if (task2 == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(1);
        }
        Future<?> future2 = ProcessIOExecutorService.INSTANCE.submit(task2);
        if (future2 == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(2);
        }
        return future2;
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        if (Boolean.getBoolean("output.reader.blocking.mode")) {
            BaseOutputReader.Options options = BaseOutputReader.Options.BLOCKING;
            if (options == null) {
                BaseOSProcessHandler.$$$reportNull$$$0(3);
            }
            return options;
        }
        BaseOutputReader.Options options = BaseOutputReader.Options.NON_BLOCKING;
        if (options == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(4);
        }
        return options;
    }

    protected boolean processHasSeparateErrorStream() {
        return true;
    }

    @Override
    public void startNotify() {
        if (this.myCommandLine != null) {
            this.notifyTextAvailable(this.myCommandLine + '\n', ProcessOutputTypes.SYSTEM);
        }
        this.addProcessListener(new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    BaseDataReader stdOutReader = BaseOSProcessHandler.this.createOutputDataReader();
                    BaseDataReader stdErrReader = BaseOSProcessHandler.this.processHasSeparateErrorStream() ? BaseOSProcessHandler.this.createErrorDataReader() : null;
                    BaseOSProcessHandler.this.myWaitFor.setTerminationCallback(exitCode -> {
                        try {
                            if (stdErrReader != null) {
                                stdErrReader.stop();
                            }
                            stdOutReader.stop();
                            try {
                                if (stdErrReader != null) {
                                    stdErrReader.waitFor();
                                }
                                stdOutReader.waitFor();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        finally {
                            BaseOSProcessHandler.this.onOSProcessTerminated((int)exitCode);
                        }
                    });
                }
                finally {
                    BaseOSProcessHandler.this.removeProcessListener(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/execution/process/BaseOSProcessHandler$1", "startNotified"));
            }
        });
        super.startNotify();
    }

    @NotNull
    protected BaseDataReader createErrorDataReader() {
        return new SimpleOutputReader(this.createProcessErrReader(), ProcessOutputTypes.STDERR, this.readerOptions(), "error stream of " + this.myPresentableName);
    }

    @NotNull
    protected BaseDataReader createOutputDataReader() {
        return new SimpleOutputReader(this.createProcessOutReader(), ProcessOutputTypes.STDOUT, this.readerOptions(), "output stream of " + this.myPresentableName);
    }

    @NotNull
    protected Reader createProcessOutReader() {
        return this.createInputStreamReader(this.myProcess.getInputStream());
    }

    @NotNull
    protected Reader createProcessErrReader() {
        return this.createInputStreamReader(this.myProcess.getErrorStream());
    }

    @NotNull
    private Reader createInputStreamReader(@NotNull InputStream streamToRead) {
        Charset charset;
        if (streamToRead == null) {
            BaseOSProcessHandler.$$$reportNull$$$0(5);
        }
        if ((charset = this.getCharset()) == null) {
            charset = Charset.defaultCharset();
        }
        return new BaseInputStreamReader(streamToRead, charset);
    }

    @Override
    public String toString() {
        return this.myCommandLine;
    }

    @Override
    public boolean waitFor() {
        boolean result2 = super.waitFor();
        try {
            this.myWaitFor.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return result2;
    }

    @Override
    public boolean waitFor(long timeoutInMilliseconds) {
        long start2 = System.currentTimeMillis();
        boolean result2 = super.waitFor(timeoutInMilliseconds);
        long elapsed = System.currentTimeMillis() - start2;
        try {
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return result2 &= this.myWaitFor.waitFor(Math.max(0L, timeoutInMilliseconds - elapsed), TimeUnit.MILLISECONDS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/execution/process/BaseOSProcessHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamToRead";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/execution/process/BaseOSProcessHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "executeTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readerOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createInputStreamReader";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    protected final class SimpleOutputReader
    extends BaseOutputReader {
        private final Key<?> myProcessOutputType;

        public SimpleOutputReader(Reader reader, Key<?> outputType, @NotNull @NonNls BaseOutputReader.Options options, String presentableName2) {
            if (presentableName2 == null) {
                SimpleOutputReader.$$$reportNull$$$0(0);
            }
            super(reader, options);
            this.myProcessOutputType = outputType;
            this.start(presentableName2);
        }

        @Override
        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                SimpleOutputReader.$$$reportNull$$$0(1);
            }
            Future<?> future2 = BaseOSProcessHandler.this.executeTask(runnable);
            if (future2 == null) {
                SimpleOutputReader.$$$reportNull$$$0(2);
            }
            return future2;
        }

        @Override
        protected void onTextAvailable(@NotNull String text) {
            if (text == null) {
                SimpleOutputReader.$$$reportNull$$$0(3);
            }
            BaseOSProcessHandler.this.notifyTextAvailable(text, this.myProcessOutputType);
        }

        @Override
        protected void beforeSleeping(boolean hasJustReadSomething) {
            long sleepStart = BaseOSProcessHandler.this.mySleepStart.get();
            if (sleepStart < 0L) {
                return;
            }
            long now = System.currentTimeMillis();
            if (hasJustReadSomething) {
                BaseOSProcessHandler.this.mySleepStart.set(now);
            } else if (TimeUnit.MILLISECONDS.toMinutes(now - sleepStart) >= 2L && BaseOSProcessHandler.this.mySleepStart.compareAndSet(sleepStart, -1L)) {
                LOG.warn("Process hasn't generated any output for a long time.\nIf it's a long-running mostly idle daemon process, consider overriding OSProcessHandler#readerOptions with 'BaseOutputReader.Options.forMostlySilentProcess()' to reduce CPU usage.\nCommand line: " + StringUtil.trimLog(StringUtil.notNullize(BaseOSProcessHandler.this.myCommandLine), 1000), BaseOSProcessHandler.this.myProcessStart);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/execution/process/BaseOSProcessHandler$SimpleOutputReader";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/execution/process/BaseOSProcessHandler$SimpleOutputReader";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeOnPooledThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "executeOnPooledThread";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onTextAvailable";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

