/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.io.AbstractStringEnumerator;
import org.jetbrains.kotlin.com.intellij.util.io.DataInputOutputUtil;

public final class StringRef {
    public static final StringRef[] EMPTY_ARRAY = new StringRef[0];
    private int id;
    private String name;
    private final AbstractStringEnumerator store;

    private StringRef(@NotNull String name) {
        if (name == null) {
            StringRef.$$$reportNull$$$0(0);
        }
        this.name = name;
        this.id = -1;
        this.store = null;
    }

    private StringRef(int id, @NotNull AbstractStringEnumerator store) {
        if (store == null) {
            StringRef.$$$reportNull$$$0(1);
        }
        this.id = id;
        this.store = store;
    }

    public String getString() {
        String name = this.name;
        if (name == null) {
            try {
                this.name = name = (String)this.store.valueOf(this.id);
            }
            catch (IOException e) {
                this.store.markCorrupted();
                throw new RuntimeException(e);
            }
        }
        return name;
    }

    public void writeTo(@NotNull DataOutput out, @NotNull AbstractStringEnumerator store) throws IOException {
        if (out == null) {
            StringRef.$$$reportNull$$$0(2);
        }
        if (store == null) {
            StringRef.$$$reportNull$$$0(3);
        }
        int nameId = this.getId(store);
        out.writeByte(nameId & 0xFF);
        DataInputOutputUtil.writeINT(out, nameId >> 8);
    }

    public int getId(@NotNull AbstractStringEnumerator store) {
        if (store == null) {
            StringRef.$$$reportNull$$$0(4);
        }
        if (this.id == -1) {
            try {
                this.id = store.enumerate(this.name);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.id;
    }

    public String toString() {
        return this.getString();
    }

    public int length() {
        return this.getString().length();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object that) {
        return that == this || that instanceof StringRef && this.toString().equals(that.toString());
    }

    @Contract(value="null -> null")
    public static String toString(@Nullable StringRef ref) {
        return ref != null ? ref.getString() : null;
    }

    @Contract(value="null -> null; !null -> !null")
    public static StringRef fromString(@Nullable String source2) {
        return source2 == null ? null : new StringRef(source2);
    }

    @NotNull
    public static StringRef fromNullableString(@Nullable String source2) {
        return new StringRef(source2 == null ? "" : source2);
    }

    @Nullable
    public static StringRef fromStream(@NotNull DataInput in, @NotNull AbstractStringEnumerator store) throws IOException {
        int nameId;
        if (in == null) {
            StringRef.$$$reportNull$$$0(5);
        }
        if (store == null) {
            StringRef.$$$reportNull$$$0(6);
        }
        return (nameId = DataInputOutputUtil.readINT(in)) != 0 ? new StringRef(nameId, store) : null;
    }

    @Nullable
    public static String stringFromStream(@NotNull DataInput in, @NotNull AbstractStringEnumerator store) throws IOException {
        int nameId;
        if (in == null) {
            StringRef.$$$reportNull$$$0(7);
        }
        if (store == null) {
            StringRef.$$$reportNull$$$0(8);
        }
        return (nameId = DataInputOutputUtil.readINT(in)) != 0 ? (String)store.valueOf(nameId) : null;
    }

    public static StringRef @NotNull [] createArray(int count) {
        return count == 0 ? EMPTY_ARRAY : new StringRef[count];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "store";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/StringRef";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeTo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getId";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "fromStream";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "stringFromStream";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

