/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.util.Locale;

public final class SystemInfoRt {
    public static final String OS_NAME;
    public static final String OS_VERSION;
    private static final String _OS_NAME;
    public static final boolean isWindows;
    public static final boolean isMac;
    public static final boolean isLinux;
    public static final boolean isFreeBSD;
    public static final boolean isSolaris;
    public static final boolean isUnix;
    public static final boolean isXWindow;
    public static final boolean isJBSystemMenu;
    public static final boolean isFileSystemCaseSensitive;

    static {
        String name = System.getProperty("os.name");
        String version2 = System.getProperty("os.version").toLowerCase(Locale.ENGLISH);
        if (name.startsWith("Windows") && name.matches("Windows \\d+")) {
            try {
                String version22 = name.substring("Windows".length() + 1) + ".0";
                if (Float.parseFloat(version22) > Float.parseFloat(version2)) {
                    version2 = version22;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            name = "Windows";
        }
        OS_NAME = name;
        OS_VERSION = version2;
        _OS_NAME = OS_NAME.toLowerCase(Locale.ENGLISH);
        isWindows = _OS_NAME.startsWith("windows");
        isMac = _OS_NAME.startsWith("mac");
        isLinux = _OS_NAME.startsWith("linux");
        isFreeBSD = _OS_NAME.startsWith("freebsd");
        isSolaris = _OS_NAME.startsWith("sunos");
        isUnix = !isWindows;
        isXWindow = isUnix && !isMac;
        isJBSystemMenu = isMac && Boolean.parseBoolean(System.getProperty("jbScreenMenuBar.enabled", "true"));
        isFileSystemCaseSensitive = isUnix && !isMac || "true".equalsIgnoreCase(System.getProperty("idea.case.sensitive.fs"));
    }
}

