/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.SafeMath;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.AbstractShortList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortConsumer;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortIterators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortListIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortSpliterators;

public class ShortArrayList
extends AbstractShortList
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    protected transient short[] a;
    protected int size;

    private static final short[] copyArraySafe(short[] a, int length) {
        if (length == 0) {
            return ShortArrays.EMPTY_ARRAY;
        }
        return java.util.Arrays.copyOf(a, length);
    }

    private static final short[] copyArrayFromSafe(ShortArrayList l) {
        return ShortArrayList.copyArraySafe(l.a, l.size);
    }

    protected ShortArrayList(short[] a, boolean wrapped) {
        this.a = a;
    }

    private void initArrayFromCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = capacity == 0 ? ShortArrays.EMPTY_ARRAY : new short[capacity];
    }

    public ShortArrayList(int capacity) {
        this.initArrayFromCapacity(capacity);
    }

    public ShortArrayList() {
        this.a = ShortArrays.DEFAULT_EMPTY_ARRAY;
    }

    public ShortArrayList(Collection<? extends Short> c) {
        if (c instanceof ShortArrayList) {
            this.a = ShortArrayList.copyArrayFromSafe((ShortArrayList)c);
            this.size = this.a.length;
        } else {
            this.initArrayFromCapacity(c.size());
            if (c instanceof ShortList) {
                this.size = c.size();
                ((ShortList)c).getElements(0, this.a, 0, this.size);
            } else {
                this.size = ShortIterators.unwrap(ShortIterators.asShortIterator(c.iterator()), this.a);
            }
        }
    }

    public ShortArrayList(ShortCollection c) {
        if (c instanceof ShortArrayList) {
            this.a = ShortArrayList.copyArrayFromSafe((ShortArrayList)c);
            this.size = this.a.length;
        } else {
            this.initArrayFromCapacity(c.size());
            if (c instanceof ShortList) {
                this.size = c.size();
                ((ShortList)c).getElements(0, this.a, 0, this.size);
            } else {
                this.size = ShortIterators.unwrap(c.iterator(), this.a);
            }
        }
    }

    public ShortArrayList(ShortList l) {
        if (l instanceof ShortArrayList) {
            this.a = ShortArrayList.copyArrayFromSafe((ShortArrayList)l);
            this.size = this.a.length;
        } else {
            this.initArrayFromCapacity(l.size());
            this.size = l.size();
            l.getElements(0, this.a, 0, this.size);
        }
    }

    public ShortArrayList(short[] a) {
        this(a, 0, a.length);
    }

    public ShortArrayList(short[] a, int offset, int length) {
        this(length);
        System.arraycopy(a, offset, this.a, 0, length);
        this.size = length;
    }

    public ShortArrayList(Iterator<? extends Short> i2) {
        this();
        while (i2.hasNext()) {
            this.add((short)i2.next());
        }
    }

    public ShortArrayList(ShortIterator i2) {
        this();
        while (i2.hasNext()) {
            this.add(i2.nextShort());
        }
    }

    public short[] elements() {
        return this.a;
    }

    public static ShortArrayList wrap(short[] a, int length) {
        if (length > a.length) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + a.length + ")");
        }
        ShortArrayList l = new ShortArrayList(a, true);
        l.size = length;
        return l;
    }

    public static ShortArrayList wrap(short[] a) {
        return ShortArrayList.wrap(a, a.length);
    }

    public static ShortArrayList of() {
        return new ShortArrayList();
    }

    public static ShortArrayList of(short ... init) {
        return ShortArrayList.wrap(init);
    }

    public void ensureCapacity(int capacity) {
        if (capacity <= this.a.length || this.a == ShortArrays.DEFAULT_EMPTY_ARRAY && capacity <= 10) {
            return;
        }
        this.a = ShortArrays.ensureCapacity(this.a, capacity, this.size);
        assert (this.size <= this.a.length);
    }

    private void grow(int capacity) {
        if (capacity <= this.a.length) {
            return;
        }
        if (this.a != ShortArrays.DEFAULT_EMPTY_ARRAY) {
            capacity = (int)Math.max(Math.min((long)this.a.length + (long)(this.a.length >> 1), 0x7FFFFFF7L), (long)capacity);
        } else if (capacity < 10) {
            capacity = 10;
        }
        this.a = ShortArrays.forceCapacity(this.a, capacity, this.size);
        assert (this.size <= this.a.length);
    }

    @Override
    public void add(int index, short k) {
        this.ensureIndex(index);
        this.grow(this.size + 1);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + 1, this.size - index);
        }
        this.a[index] = k;
        ++this.size;
        assert (this.size <= this.a.length);
    }

    @Override
    public boolean add(short k) {
        this.grow(this.size + 1);
        this.a[this.size++] = k;
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public short getShort(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[index];
    }

    @Override
    public int indexOf(short k) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (k != this.a[i2]) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(short k) {
        int i2 = this.size;
        while (i2-- != 0) {
            if (k != this.a[i2]) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public short removeShort(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        short old = this.a[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.a, index + 1, this.a, index, this.size - index);
        }
        assert (this.size <= this.a.length);
        return old;
    }

    @Override
    public boolean rem(short k) {
        int index = this.indexOf(k);
        if (index == -1) {
            return false;
        }
        this.removeShort(index);
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public short set(int index, short k) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        short old = this.a[index];
        this.a[index] = k;
        return old;
    }

    @Override
    public void clear() {
        this.size = 0;
        assert (this.size <= this.a.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void size(int size) {
        if (size > this.a.length) {
            this.a = ShortArrays.forceCapacity(this.a, size, this.size);
        }
        if (size > this.size) {
            java.util.Arrays.fill(this.a, this.size, size, (short)0);
        }
        this.size = size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public void trim() {
        this.trim(0);
    }

    public void trim(int n) {
        if (n >= this.a.length || this.size == this.a.length) {
            return;
        }
        short[] t = new short[Math.max(n, this.size)];
        System.arraycopy(this.a, 0, t, 0, this.size);
        this.a = t;
        assert (this.size <= this.a.length);
    }

    @Override
    public ShortList subList(int from2, int to) {
        if (from2 == 0 && to == this.size()) {
            return this;
        }
        this.ensureIndex(from2);
        this.ensureIndex(to);
        if (from2 > to) {
            throw new IndexOutOfBoundsException("Start index (" + from2 + ") is greater than end index (" + to + ")");
        }
        return new SubList(from2, to);
    }

    @Override
    public void getElements(int from2, short[] a, int offset, int length) {
        ShortArrays.ensureOffsetLength(a, offset, length);
        System.arraycopy(this.a, from2, a, offset, length);
    }

    @Override
    public void removeElements(int from2, int to) {
        Arrays.ensureFromTo(this.size, from2, to);
        System.arraycopy(this.a, to, this.a, from2, this.size - to);
        this.size -= to - from2;
    }

    @Override
    public void addElements(int index, short[] a, int offset, int length) {
        this.ensureIndex(index);
        ShortArrays.ensureOffsetLength(a, offset, length);
        this.grow(this.size + length);
        System.arraycopy(this.a, index, this.a, index + length, this.size - index);
        System.arraycopy(a, offset, this.a, index, length);
        this.size += length;
    }

    @Override
    public void setElements(int index, short[] a, int offset, int length) {
        this.ensureIndex(index);
        ShortArrays.ensureOffsetLength(a, offset, length);
        if (index + length > this.size) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + this.size + ")");
        }
        System.arraycopy(a, offset, this.a, index, length);
    }

    @Override
    public void forEach(ShortConsumer action2) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            action2.accept(this.a[i2]);
        }
    }

    @Override
    public boolean addAll(int index, ShortCollection c) {
        if (c instanceof ShortList) {
            return this.addAll(index, (ShortList)c);
        }
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        this.grow(this.size + n);
        System.arraycopy(this.a, index, this.a, index + n, this.size - index);
        ShortIterator i2 = c.iterator();
        this.size += n;
        while (n-- != 0) {
            this.a[index++] = i2.nextShort();
        }
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public boolean addAll(int index, ShortList l) {
        this.ensureIndex(index);
        int n = l.size();
        if (n == 0) {
            return false;
        }
        this.grow(this.size + n);
        System.arraycopy(this.a, index, this.a, index + n, this.size - index);
        l.getElements(0, this.a, index, n);
        this.size += n;
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public boolean removeAll(ShortCollection c) {
        short[] a = this.a;
        int j = 0;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (c.contains(a[i2])) continue;
            a[j++] = a[i2];
        }
        boolean modified = this.size != j;
        this.size = j;
        return modified;
    }

    @Override
    public short[] toArray(short[] a) {
        if (a == null || a.length < this.size) {
            a = java.util.Arrays.copyOf(a, this.size);
        }
        System.arraycopy(this.a, 0, a, 0, this.size);
        return a;
    }

    @Override
    public ShortListIterator listIterator(final int index) {
        this.ensureIndex(index);
        return new ShortListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < ShortArrayList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0;
            }

            @Override
            public short nextShort() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return ShortArrayList.this.a[this.last];
            }

            @Override
            public short previousShort() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return ShortArrayList.this.a[this.pos];
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void add(short k) {
                ShortArrayList.this.add(this.pos++, k);
                this.last = -1;
            }

            @Override
            public void set(short k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                ShortArrayList.this.set(this.last, k);
            }

            @Override
            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                ShortArrayList.this.removeShort(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }

            @Override
            public void forEachRemaining(ShortConsumer action2) {
                while (this.pos < ShortArrayList.this.size) {
                    ++this.pos;
                    this.last = this.last;
                    action2.accept(ShortArrayList.this.a[this.last]);
                }
            }

            @Override
            public int back(int n) {
                if (n < 0) {
                    throw new IllegalArgumentException("Argument must be nonnegative: " + n);
                }
                int remaining = ShortArrayList.this.size - this.pos;
                if (n < remaining) {
                    this.pos -= n;
                } else {
                    n = remaining;
                    this.pos = 0;
                }
                this.last = this.pos;
                return n;
            }

            @Override
            public int skip(int n) {
                if (n < 0) {
                    throw new IllegalArgumentException("Argument must be nonnegative: " + n);
                }
                int remaining = ShortArrayList.this.size - this.pos;
                if (n < remaining) {
                    this.pos += n;
                } else {
                    n = remaining;
                    this.pos = ShortArrayList.this.size;
                }
                this.last = this.pos - 1;
                return n;
            }
        };
    }

    @Override
    public ShortSpliterator spliterator() {
        return new Spliterator();
    }

    @Override
    public void sort(ShortComparator comp) {
        if (comp == null) {
            ShortArrays.stableSort(this.a, 0, this.size);
        } else {
            ShortArrays.stableSort(this.a, 0, this.size, comp);
        }
    }

    @Override
    public void unstableSort(ShortComparator comp) {
        if (comp == null) {
            ShortArrays.unstableSort(this.a, 0, this.size);
        } else {
            ShortArrays.unstableSort(this.a, 0, this.size, comp);
        }
    }

    public ShortArrayList clone() {
        ShortArrayList cloned = null;
        if (this.getClass() == ShortArrayList.class) {
            cloned = new ShortArrayList(ShortArrayList.copyArraySafe(this.a, this.size), false);
            cloned.size = this.size;
        } else {
            try {
                cloned = (ShortArrayList)super.clone();
            }
            catch (CloneNotSupportedException err) {
                throw new InternalError(err);
            }
            cloned.a = ShortArrayList.copyArraySafe(this.a, this.size);
        }
        return cloned;
    }

    public boolean equals(ShortArrayList l) {
        if (l == this) {
            return true;
        }
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        short[] a1 = this.a;
        short[] a2 = l.a;
        if (a1 == a2 && s == l.size()) {
            return true;
        }
        while (s-- != 0) {
            if (a1[s] == a2[s]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (o instanceof ShortArrayList) {
            return this.equals((ShortArrayList)o);
        }
        if (o instanceof SubList) {
            return ((SubList)o).equals(this);
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(ShortArrayList l) {
        int i2;
        int s1 = this.size();
        int s2 = l.size();
        short[] a1 = this.a;
        short[] a2 = l.a;
        if (a1 == a2 && s1 == s2) {
            return 0;
        }
        for (i2 = 0; i2 < s1 && i2 < s2; ++i2) {
            short e1 = a1[i2];
            short e2 = a2[i2];
            int r = Short.compare(e1, e2);
            if (r == 0) continue;
            return r;
        }
        return i2 < s2 ? -1 : (i2 < s1 ? 1 : 0);
    }

    @Override
    public int compareTo(List<? extends Short> l) {
        if (l instanceof ShortArrayList) {
            return this.compareTo((ShortArrayList)l);
        }
        if (l instanceof SubList) {
            return -((SubList)l).compareTo(this);
        }
        return super.compareTo(l);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int i2 = 0; i2 < this.size; ++i2) {
            s.writeShort(this.a[i2]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = new short[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.a[i2] = s.readShort();
        }
    }

    private class SubList
    extends AbstractShortList.ShortRandomAccessSubList {
        private static final long serialVersionUID = -3185226345314976296L;

        protected SubList(int from2, int to) {
            super(ShortArrayList.this, from2, to);
        }

        private short[] getParentArray() {
            return ShortArrayList.this.a;
        }

        @Override
        public short getShort(int i2) {
            this.ensureRestrictedIndex(i2);
            return ShortArrayList.this.a[i2 + this.from];
        }

        @Override
        public ShortListIterator listIterator(int index) {
            return new SubListIterator(index);
        }

        @Override
        public ShortSpliterator spliterator() {
            return new SubListSpliterator();
        }

        boolean contentsEquals(short[] otherA, int otherAFrom, int otherATo) {
            if (ShortArrayList.this.a == otherA && this.from == otherAFrom && this.to == otherATo) {
                return true;
            }
            if (otherATo - otherAFrom != this.size()) {
                return false;
            }
            int pos = this.from;
            int otherPos = otherAFrom;
            while (pos < this.to) {
                if (ShortArrayList.this.a[pos++] == otherA[otherPos++]) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof List)) {
                return false;
            }
            if (o instanceof ShortArrayList) {
                ShortArrayList other = (ShortArrayList)o;
                return this.contentsEquals(other.a, 0, other.size());
            }
            if (o instanceof SubList) {
                SubList other = (SubList)o;
                return this.contentsEquals(other.getParentArray(), other.from, other.to);
            }
            return super.equals(o);
        }

        int contentsCompareTo(short[] otherA, int otherAFrom, int otherATo) {
            if (ShortArrayList.this.a == otherA && this.from == otherAFrom && this.to == otherATo) {
                return 0;
            }
            int i2 = this.from;
            int j = otherAFrom;
            while (i2 < this.to && i2 < otherATo) {
                short e1 = ShortArrayList.this.a[i2];
                short e2 = otherA[j];
                int r = Short.compare(e1, e2);
                if (r != 0) {
                    return r;
                }
                ++i2;
                ++j;
            }
            return i2 < otherATo ? -1 : (i2 < this.to ? 1 : 0);
        }

        @Override
        public int compareTo(List<? extends Short> l) {
            if (l instanceof ShortArrayList) {
                ShortArrayList other = (ShortArrayList)l;
                return this.contentsCompareTo(other.a, 0, other.size());
            }
            if (l instanceof SubList) {
                SubList other = (SubList)l;
                return this.contentsCompareTo(other.getParentArray(), other.from, other.to);
            }
            return super.compareTo(l);
        }

        private final class SubListIterator
        extends ShortIterators.AbstractIndexBasedListIterator {
            SubListIterator(int index) {
                super(0, index);
            }

            @Override
            protected final short get(int i2) {
                return ShortArrayList.this.a[SubList.this.from + i2];
            }

            @Override
            protected final void add(int i2, short k) {
                SubList.this.add(i2, k);
            }

            @Override
            protected final void set(int i2, short k) {
                SubList.this.set(i2, k);
            }

            @Override
            protected final void remove(int i2) {
                SubList.this.removeShort(i2);
            }

            @Override
            protected final int getMaxPos() {
                return SubList.this.to - SubList.this.from;
            }

            @Override
            public short nextShort() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.pos++;
                return ShortArrayList.this.a[SubList.this.from + this.lastReturned];
            }

            @Override
            public short previousShort() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = --this.pos;
                return ShortArrayList.this.a[SubList.this.from + this.pos];
            }

            @Override
            public void forEachRemaining(ShortConsumer action2) {
                int max = SubList.this.to - SubList.this.from;
                while (this.pos < max) {
                    ++this.pos;
                    this.lastReturned = this.lastReturned;
                    action2.accept(ShortArrayList.this.a[SubList.this.from + this.lastReturned]);
                }
            }
        }

        private final class SubListSpliterator
        extends ShortSpliterators.LateBindingSizeIndexBasedSpliterator {
            SubListSpliterator() {
                super(SubList.this.from);
            }

            private SubListSpliterator(int pos, int maxPos) {
                super(pos, maxPos);
            }

            @Override
            protected final int getMaxPosFromBackingStore() {
                return SubList.this.to;
            }

            @Override
            protected final short get(int i2) {
                return ShortArrayList.this.a[i2];
            }

            @Override
            protected final SubListSpliterator makeForSplit(int pos, int maxPos) {
                return new SubListSpliterator(pos, maxPos);
            }

            @Override
            public boolean tryAdvance(ShortConsumer action2) {
                if (this.pos >= this.getMaxPos()) {
                    return false;
                }
                action2.accept(ShortArrayList.this.a[this.pos++]);
                return true;
            }

            @Override
            public void forEachRemaining(ShortConsumer action2) {
                int max = this.getMaxPos();
                while (this.pos < max) {
                    action2.accept(ShortArrayList.this.a[this.pos++]);
                }
            }
        }
    }

    private final class Spliterator
    implements ShortSpliterator {
        boolean hasSplit = false;
        int pos;
        int max;

        public Spliterator() {
            this(0, shortArrayList.size, false);
        }

        private Spliterator(int pos, int max, boolean hasSplit) {
            assert (pos <= max) : "pos " + pos + " must be <= max " + max;
            this.pos = pos;
            this.max = max;
            this.hasSplit = hasSplit;
        }

        private int getWorkingMax() {
            return this.hasSplit ? this.max : ShortArrayList.this.size;
        }

        @Override
        public int characteristics() {
            return 16720;
        }

        @Override
        public long estimateSize() {
            return this.getWorkingMax() - this.pos;
        }

        @Override
        public boolean tryAdvance(ShortConsumer action2) {
            if (this.pos >= this.getWorkingMax()) {
                return false;
            }
            action2.accept(ShortArrayList.this.a[this.pos++]);
            return true;
        }

        @Override
        public void forEachRemaining(ShortConsumer action2) {
            int max = this.getWorkingMax();
            while (this.pos < max) {
                action2.accept(ShortArrayList.this.a[this.pos]);
                ++this.pos;
            }
        }

        @Override
        public long skip(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            int max = this.getWorkingMax();
            if (this.pos >= max) {
                return 0L;
            }
            int remaining = max - this.pos;
            if (n < (long)remaining) {
                this.pos = SafeMath.safeLongToInt((long)this.pos + n);
                return n;
            }
            n = remaining;
            this.pos = max;
            return n;
        }

        @Override
        public ShortSpliterator trySplit() {
            int myNewPos;
            int max = this.getWorkingMax();
            int retLen = max - this.pos >> 1;
            if (retLen <= 1) {
                return null;
            }
            this.max = max;
            int retMax = myNewPos = this.pos + retLen;
            int oldPos = this.pos;
            this.pos = myNewPos;
            this.hasSplit = true;
            return new Spliterator(oldPos, retMax, true);
        }
    }
}

