/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.indexing.impl;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.ThrowableComputable;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.indexing.DataIndexer;
import org.jetbrains.kotlin.com.intellij.util.indexing.IndexExtension;
import org.jetbrains.kotlin.com.intellij.util.indexing.IndexId;
import org.jetbrains.kotlin.com.intellij.util.indexing.InvertedIndex;
import org.jetbrains.kotlin.com.intellij.util.indexing.StorageException;
import org.jetbrains.kotlin.com.intellij.util.indexing.ValueContainer;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.AbstractUpdateData;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.IndexDebugProperties;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.IndexStorage;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.IndexStorageLayout;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.InputData;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.InputDataDiffBuilder;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.MapReduceIndexMappingException;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.RemovedKeyProcessor;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.UpdateData;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.ValueContainerImpl;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.ValueSerializationChecker;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.ValueSerializationProblemReporter;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.forward.ForwardIndex;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.forward.IntForwardIndex;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.forward.IntForwardIndexAccessor;
import org.jetbrains.kotlin.com.intellij.util.io.MeasurableIndexStore;

public abstract class MapReduceIndex<Key, Value, Input>
implements InvertedIndex<Key, Value, Input>,
MeasurableIndexStore {
    private static final Logger LOG = Logger.getInstance(MapReduceIndex.class);
    private static final boolean USE_READ_LOCK_ON_UPDATE = SystemProperties.getBooleanProperty("idea.map.reduce.index.use.read.lock.on.update", false);
    protected final IndexId<Key, Value> myIndexId;
    protected final IndexStorage<Key, Value> myStorage;
    protected final AtomicLong myModificationStamp;
    protected final DataIndexer<Key, Value, Input> myIndexer;
    @Nullable
    private final ValueSerializationChecker<Value, Input> myValueSerializationChecker;
    private final IndexExtension<Key, Value, Input> myExtension;
    @Nullable
    private final ForwardIndex myForwardIndex;
    private final ForwardIndexAccessor<Key, Value> myForwardIndexAccessor;
    private final ReadWriteLock myLock;
    private final boolean myUseIntForwardIndex;
    private volatile boolean myDisposed;
    private final LowMemoryWatcher myLowMemoryFlusher;
    private final RemovedKeyProcessor<Key> myRemovedKeyProcessor;
    private final KeyValueUpdateProcessor<Key, Value> myAddedKeyProcessor;
    private final KeyValueUpdateProcessor<Key, Value> myUpdatedKeyProcessor;

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorageLayout<Key, Value> indexStorageLayout) throws IOException {
        if (extension == null) {
            MapReduceIndex.$$$reportNull$$$0(0);
        }
        if (indexStorageLayout == null) {
            MapReduceIndex.$$$reportNull$$$0(1);
        }
        this(extension, indexStorageLayout.openIndexStorage(), indexStorageLayout.openForwardIndex(), indexStorageLayout.getForwardIndexAccessor());
    }

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage, @Nullable ForwardIndex forwardIndex, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor) throws IOException {
        if (extension == null) {
            MapReduceIndex.$$$reportNull$$$0(2);
        }
        if (storage == null) {
            MapReduceIndex.$$$reportNull$$$0(3);
        }
        this(extension, () -> storage, () -> forwardIndex, forwardIndexAccessor);
    }

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull ThrowableComputable<? extends IndexStorage<Key, Value>, ? extends IOException> storage, @Nullable ThrowableComputable<? extends ForwardIndex, ? extends IOException> forwardIndex, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor) throws IOException {
        if (extension == null) {
            MapReduceIndex.$$$reportNull$$$0(4);
        }
        if (storage == null) {
            MapReduceIndex.$$$reportNull$$$0(5);
        }
        this.myModificationStamp = new AtomicLong();
        this.myRemovedKeyProcessor = new RemovedKeyProcessor<Key>(){

            @Override
            public void process(Key key, int inputId) throws StorageException {
                MapReduceIndex.this.incrementModificationStamp();
                MapReduceIndex.this.myStorage.removeAllValues(key, inputId);
            }
        };
        this.myAddedKeyProcessor = new KeyValueUpdateProcessor<Key, Value>(){

            @Override
            public void process(Key key, Value value2, int inputId) throws StorageException {
                MapReduceIndex.this.incrementModificationStamp();
                MapReduceIndex.this.myStorage.addValue(key, inputId, value2);
            }
        };
        this.myUpdatedKeyProcessor = new KeyValueUpdateProcessor<Key, Value>(){

            @Override
            public void process(Key key, Value value2, int inputId) throws StorageException {
                MapReduceIndex.this.incrementModificationStamp();
                MapReduceIndex.this.myStorage.updateValue(key, inputId, value2);
            }
        };
        this.myIndexId = extension.getName();
        this.myExtension = extension;
        this.myIndexer = this.myExtension.getIndexer();
        this.myStorage = storage.compute();
        try {
            this.myForwardIndex = forwardIndex == null ? null : forwardIndex.compute();
        }
        catch (IOException e) {
            this.tryDispose();
            throw e;
        }
        this.myForwardIndexAccessor = forwardIndexAccessor;
        this.myUseIntForwardIndex = this.myForwardIndex instanceof IntForwardIndex && this.myForwardIndexAccessor instanceof IntForwardIndexAccessor;
        LOG.assertTrue(this.myForwardIndex instanceof IntForwardIndex == this.myForwardIndexAccessor instanceof IntForwardIndexAccessor, "Invalid index configuration for " + this.myIndexId);
        this.myLock = new ReentrantReadWriteLock();
        this.myValueSerializationChecker = new ValueSerializationChecker(extension, this.getSerializationProblemReporter());
        this.myLowMemoryFlusher = LowMemoryWatcher.register(() -> this.clearCaches());
    }

    public void clearCaches() {
        try {
            this.myLock.readLock().lock();
            try {
                this.myStorage.clearCaches();
            }
            finally {
                this.myLock.readLock().unlock();
            }
            this.flush();
        }
        catch (Throwable e) {
            this.requestRebuild(e);
        }
    }

    @NotNull
    protected ValueSerializationProblemReporter getSerializationProblemReporter() {
        ValueSerializationProblemReporter valueSerializationProblemReporter = ValueSerializationChecker.DEFAULT_SERIALIZATION_PROBLEM_REPORTER;
        if (valueSerializationProblemReporter == null) {
            MapReduceIndex.$$$reportNull$$$0(6);
        }
        return valueSerializationProblemReporter;
    }

    protected void tryDispose() {
        try {
            this.dispose();
        }
        catch (Exception e) {
            LOG.info(e);
        }
    }

    @Nullable
    public ForwardIndex getForwardIndex() {
        return this.myForwardIndex;
    }

    public ForwardIndexAccessor<Key, Value> getForwardIndexAccessor() {
        return this.myForwardIndexAccessor;
    }

    @NotNull
    public IndexExtension<Key, Value, Input> getExtension() {
        IndexExtension<Key, Value, Input> indexExtension = this.myExtension;
        if (indexExtension == null) {
            MapReduceIndex.$$$reportNull$$$0(7);
        }
        return indexExtension;
    }

    @NotNull
    public IndexStorage<Key, Value> getStorage() {
        IndexStorage<Key, Value> indexStorage = this.myStorage;
        if (indexStorage == null) {
            MapReduceIndex.$$$reportNull$$$0(8);
        }
        return indexStorage;
    }

    @NotNull
    public final ReadWriteLock getLock() {
        ReadWriteLock readWriteLock = this.myLock;
        if (readWriteLock == null) {
            MapReduceIndex.$$$reportNull$$$0(9);
        }
        return readWriteLock;
    }

    @Override
    public void clear() {
        this.myLock.writeLock().lock();
        try {
            this.incrementModificationStamp();
            this.doClear();
        }
        catch (IOException | StorageException e) {
            LOG.info(e);
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    protected void doClear() throws StorageException, IOException {
        this.myStorage.clear();
        if (this.myForwardIndex != null) {
            this.myForwardIndex.clear();
        }
    }

    @Override
    public void flush() throws StorageException {
        this.myLock.readLock().lock();
        try {
            this.doFlush();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                throw new StorageException(cause);
            }
            throw e;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    public boolean isDirty() {
        if (this.myForwardIndex != null && this.myForwardIndex.isDirty()) {
            return true;
        }
        return this.myStorage.isDirty();
    }

    protected void doFlush() throws IOException, StorageException {
        if (this.myForwardIndex != null) {
            this.myForwardIndex.force();
        }
        this.myStorage.flush();
    }

    @Override
    public void dispose() {
        this.myLowMemoryFlusher.stop();
        this.myLock.writeLock().lock();
        try {
            this.myDisposed = true;
            this.doDispose();
        }
        catch (StorageException e) {
            LOG.error(e);
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    @Override
    public int keysCountApproximately() {
        return MeasurableIndexStore.keysCountApproximatelyIfPossible(this.myStorage);
    }

    protected boolean isDisposed() {
        return this.myDisposed;
    }

    protected void doDispose() throws StorageException {
        try {
            this.myStorage.close();
        }
        finally {
            try {
                if (this.myForwardIndex != null) {
                    this.myForwardIndex.close();
                }
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public ValueContainer<Value> getData(@NotNull Key key) throws StorageException {
        if (key == null) {
            MapReduceIndex.$$$reportNull$$$0(10);
        }
        this.myLock.readLock().lock();
        if (this.isDisposed()) {
            ValueContainerImpl valueContainerImpl = ValueContainerImpl.createNewValueContainer();
            ValueContainerImpl valueContainerImpl2 = valueContainerImpl;
            if (valueContainerImpl2 == null) {
                MapReduceIndex.$$$reportNull$$$0(11);
            }
            return valueContainerImpl2;
        }
        IndexDebugProperties.DEBUG_INDEX_ID.set(this.myIndexId);
        ValueContainer<Value> valueContainer = this.myStorage.read(key);
        ValueContainer<Value> valueContainer2 = valueContainer;
        if (valueContainer2 == null) {
            MapReduceIndex.$$$reportNull$$$0(12);
        }
        return valueContainer2;
        finally {
            IndexDebugProperties.DEBUG_INDEX_ID.set(null);
            this.myLock.readLock().unlock();
        }
    }

    @Override
    @NotNull
    public Computable<Boolean> mapInputAndPrepareUpdate(int inputId, @Nullable Input content) throws MapReduceIndexMappingException, ProcessCanceledException {
        InputData<Key, Value> data;
        try {
            data = this.mapInput(inputId, content);
        }
        catch (ProcessCanceledException | MapReduceIndexMappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MapReduceIndexMappingException(e, this.myExtension.getClass());
        }
        Computable computable = this.prepareUpdate(inputId, (InputData)data);
        if (computable == null) {
            MapReduceIndex.$$$reportNull$$$0(13);
        }
        return computable;
    }

    @NotNull
    public IndexUpdateComputable prepareUpdate(int inputId, @NotNull InputData<Key, Value> data) {
        if (data == null) {
            MapReduceIndex.$$$reportNull$$$0(14);
        }
        UpdateData<Key, Value> updateData = new UpdateData<Key, Value>(inputId, data.getKeyValues(), () -> this.getKeysDiffBuilder(inputId), this.myIndexId, () -> this.updateForwardIndex(inputId, data));
        return new IndexUpdateComputable(updateData, data);
    }

    @ApiStatus.Internal
    protected void checkNonCancellableSection() {
    }

    protected void updateForwardIndex(int inputId, @NotNull InputData<Key, Value> data) throws IOException {
        if (data == null) {
            MapReduceIndex.$$$reportNull$$$0(15);
        }
        if (this.myForwardIndex != null) {
            if (this.myUseIntForwardIndex) {
                ((IntForwardIndex)this.myForwardIndex).putInt(inputId, ((IntForwardIndexAccessor)this.myForwardIndexAccessor).serializeIndexedDataToInt(data));
            } else {
                this.myForwardIndex.put(inputId, this.myForwardIndexAccessor.serializeIndexedData(data));
            }
        }
    }

    @NotNull
    protected InputDataDiffBuilder<Key, Value> getKeysDiffBuilder(int inputId) throws IOException {
        if (this.myForwardIndex != null) {
            if (this.myUseIntForwardIndex) {
                InputDataDiffBuilder inputDataDiffBuilder = ((IntForwardIndexAccessor)this.myForwardIndexAccessor).getDiffBuilderFromInt(inputId, ((IntForwardIndex)this.myForwardIndex).getInt(inputId));
                if (inputDataDiffBuilder == null) {
                    MapReduceIndex.$$$reportNull$$$0(16);
                }
                return inputDataDiffBuilder;
            }
            InputDataDiffBuilder<Key, Value> inputDataDiffBuilder = this.myForwardIndexAccessor.getDiffBuilder(inputId, this.myForwardIndex.get(inputId));
            if (inputDataDiffBuilder == null) {
                MapReduceIndex.$$$reportNull$$$0(17);
            }
            return inputDataDiffBuilder;
        }
        return new EmptyInputDataDiffBuilder(inputId);
    }

    @NotNull
    protected InputData<Key, Value> mapInput(int inputId, @Nullable Input content) {
        if (content == null) {
            InputData inputData = InputData.empty();
            if (inputData == null) {
                MapReduceIndex.$$$reportNull$$$0(18);
            }
            return inputData;
        }
        Map<Key, Value> data = this.mapByIndexer(inputId, content);
        if (this.myValueSerializationChecker != null) {
            this.myValueSerializationChecker.checkValueSerialization(data, content);
        }
        this.checkCanceled();
        return new InputData<Key, Value>(data);
    }

    @NotNull
    protected Map<Key, Value> mapByIndexer(int inputId, @NotNull Input content) {
        if (content == null) {
            MapReduceIndex.$$$reportNull$$$0(19);
        }
        Map<Key, Value> map2 = this.myIndexer.map(content);
        if (map2 == null) {
            MapReduceIndex.$$$reportNull$$$0(20);
        }
        return map2;
    }

    public abstract void checkCanceled();

    protected abstract void requestRebuild(@NotNull Throwable var1);

    public long getModificationStamp() {
        return this.myModificationStamp.get();
    }

    protected void incrementModificationStamp() {
        this.myModificationStamp.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWithMap(@NotNull AbstractUpdateData<Key, Value> updateData) throws StorageException {
        if (updateData == null) {
            MapReduceIndex.$$$reportNull$$$0(21);
        }
        Lock lock2 = USE_READ_LOCK_ON_UPDATE ? this.myLock.readLock() : this.myLock.writeLock();
        lock2.lock();
        try {
            IndexId<?, ?> oldIndexId = IndexDebugProperties.DEBUG_INDEX_ID.get();
            try {
                IndexDebugProperties.DEBUG_INDEX_ID.set(this.myIndexId);
                boolean hasDifference = updateData.iterateKeys(this.myAddedKeyProcessor, this.myUpdatedKeyProcessor, this.myRemovedKeyProcessor);
                if (hasDifference) {
                    updateData.updateForwardIndex();
                }
            }
            catch (ProcessCanceledException e) {
                LOG.error("ProcessCanceledException is not expected here!", e);
                throw e;
            }
            catch (Throwable e) {
                throw new StorageException(e);
            }
            finally {
                IndexDebugProperties.DEBUG_INDEX_ID.set(oldIndexId);
            }
        }
        finally {
            lock2.unlock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexStorageLayout";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/indexing/impl/MapReduceIndex";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/indexing/impl/MapReduceIndex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializationProblemReporter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLock";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInputAndPrepareUpdate";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysDiffBuilder";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInput";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "mapByIndexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "prepareUpdate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateForwardIndex";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "mapByIndexer";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateWithMap";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public final class IndexUpdateComputable
    implements Computable<Boolean> {
        private final UpdateData<Key, Value> myUpdateData;
        private final InputData<Key, Value> myInputData;

        private IndexUpdateComputable(@NotNull UpdateData<Key, Value> updateData, InputData<Key, Value> inputData) {
            if (updateData == null) {
                IndexUpdateComputable.$$$reportNull$$$0(0);
            }
            if (inputData == null) {
                IndexUpdateComputable.$$$reportNull$$$0(1);
            }
            this.myUpdateData = updateData;
            this.myInputData = inputData;
        }

        @NotNull
        public InputData<Key, Value> getInputData() {
            InputData inputData = this.myInputData;
            if (inputData == null) {
                IndexUpdateComputable.$$$reportNull$$$0(2);
            }
            return inputData;
        }

        @Override
        public Boolean compute() {
            MapReduceIndex.this.checkNonCancellableSection();
            try {
                MapReduceIndex.this.updateWithMap(this.myUpdateData);
            }
            catch (ProcessCanceledException | StorageException ex) {
                String message2 = "An exception during updateWithMap(). Index " + MapReduceIndex.this.myIndexId.getName() + " will be rebuilt.";
                if (ex instanceof ProcessCanceledException) {
                    LOG.error(message2, ex);
                } else if (IndexDebugProperties.IS_UNIT_TEST_MODE) {
                    LOG.error(message2, ex);
                } else {
                    LOG.info(message2, ex);
                }
                MapReduceIndex.this.requestRebuild(ex);
                return false;
            }
            catch (Throwable t) {
                LOG.error("An exception during updateWithMap(). Index " + MapReduceIndex.this.myIndexId.getName(), t);
                throw t;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updateData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/indexing/impl/MapReduceIndex$IndexUpdateComputable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/indexing/impl/MapReduceIndex$IndexUpdateComputable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInputData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

