/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentIntObjectMap;
import org.jetbrains.kotlin.com.intellij.util.containers.IntObjectMap;
import org.jetbrains.kotlin.com.intellij.util.containers.Predicate;
import org.jetbrains.kotlin.com.intellij.util.containers.ThreadLocalRandom;
import org.jetbrains.kotlin.com.intellij.util.containers.Unsafe;

@Deprecated
final class ConcurrentIntObjectHashMap<V>
implements ConcurrentIntObjectMap<V> {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int DEFAULT_CAPACITY = 16;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final float LOAD_FACTOR = 0.75f;
    static final int TREEIFY_THRESHOLD = 8;
    static final int UNTREEIFY_THRESHOLD = 6;
    static final int MIN_TREEIFY_CAPACITY = 64;
    private static final int MIN_TRANSFER_STRIDE = 16;
    private static final int RESIZE_STAMP_BITS = 16;
    private static final int MAX_RESIZERS = 65535;
    private static final int RESIZE_STAMP_SHIFT = 16;
    static final int MOVED = -1;
    static final int TREEBIN = -2;
    static final int RESERVED = -3;
    static final int HASH_BITS = Integer.MAX_VALUE;
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    volatile transient Node<V>[] table;
    private volatile transient Node<V>[] nextTable;
    private volatile transient long baseCount;
    private volatile transient int sizeCtl;
    private volatile transient int transferIndex;
    private volatile transient int cellsBusy;
    private volatile transient CounterCell[] counterCells;
    private transient ValuesView<V> values;
    private transient EntrySetView<V> entrySet;
    private static final long SIZECTL;
    private static final long TRANSFERINDEX;
    private static final long BASECOUNT;
    private static final long CELLSBUSY;
    private static final long CELLVALUE;
    private static final long ABASE;
    private static final int ASHIFT;

    static final int spread(int h) {
        return (h ^ h >>> 16) & Integer.MAX_VALUE;
    }

    private static final int tableSizeFor(int c) {
        int n = -1 >>> Integer.numberOfLeadingZeros(c - 1);
        return n < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    static <V> Node<V> tabAt(Node<V>[] tab, int i2) {
        try {
            Object o = Unsafe.getObjectVolatile(tab, ((long)i2 << ASHIFT) + ABASE);
            return (Node)o;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static <V> boolean casTabAt(Node<V>[] tab, int i2, Node<V> v) {
        try {
            return Unsafe.compareAndSwapObject(tab, ((long)i2 << ASHIFT) + ABASE, null, v);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static <V> void setTabAt(Node<V>[] tab, int i2, Node<V> v) {
        try {
            Unsafe.putObjectVolatile(tab, ((long)i2 << ASHIFT) + ABASE, v);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    ConcurrentIntObjectHashMap() {
    }

    ConcurrentIntObjectHashMap(int initialCapacity) {
        int cap;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.sizeCtl = cap = initialCapacity >= 0x20000000 ? 0x40000000 : ConcurrentIntObjectHashMap.tableSizeFor(initialCapacity + (initialCapacity >>> 1) + 1);
    }

    @Override
    public int size() {
        long n = this.sumCount();
        return n < 0L ? 0 : (n > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n);
    }

    @Override
    public boolean isEmpty() {
        return this.sumCount() <= 0L;
    }

    @Override
    public V get(int key) {
        Node<V> e;
        int n;
        int h = ConcurrentIntObjectHashMap.spread(key);
        Node<V>[] tab = this.table;
        if (this.table != null && (n = tab.length) > 0 && (e = ConcurrentIntObjectHashMap.tabAt(tab, n - 1 & h)) != null) {
            int ek;
            int eh = e.hash;
            if (eh == h) {
                ek = e.key;
                if (ek == key || ConcurrentIntObjectHashMap.isEqual(key, ek)) {
                    return e.val;
                }
            } else if (eh < 0) {
                Node<V> p = e.find(h, key);
                return p != null ? (V)p.val : null;
            }
            while ((e = e.next) != null) {
                if (e.hash != h || (ek = e.key) != key && !ConcurrentIntObjectHashMap.isEqual(key, ek)) continue;
                return e.val;
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(@NotNull Object value2) {
        if (value2 == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(0);
        }
        Node<V>[] t = this.table;
        if (this.table != null) {
            Node<V> p;
            Traverser<V> it = new Traverser<V>(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                Object v = p.val;
                if (v != value2 && (v == null || !value2.equals(v))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V put(int key, @NotNull V value2) {
        if (value2 == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(1);
        }
        return this.putVal(key, value2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V putVal(int key, V value2, boolean onlyIfAbsent) {
        int binCount;
        block21: {
            V oldVal;
            int i2;
            int hash = ConcurrentIntObjectHashMap.spread(key);
            binCount = 0;
            Node<V>[] tab = this.table;
            while (true) {
                Object fv;
                int fk;
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i2 = n - 1 & hash;
                Node<V> f = ConcurrentIntObjectHashMap.tabAt(tab, i2);
                if (f == null) {
                    if (!ConcurrentIntObjectHashMap.casTabAt(tab, i2, new Node<V>(hash, key, value2, null))) continue;
                    break block21;
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                if (onlyIfAbsent && fh == hash && (fk = f.key) == key && (fv = f.val) != null) {
                    return fv;
                }
                oldVal = null;
                Node<V> node2 = f;
                synchronized (node2) {
                    block22: {
                        if (ConcurrentIntObjectHashMap.tabAt(tab, i2) == f) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<V> e = f;
                                while (true) {
                                    int ek;
                                    if (e.hash == hash && (ek = e.key) == key) {
                                        oldVal = e.val;
                                        if (!onlyIfAbsent) {
                                            e.val = value2;
                                        }
                                        break block22;
                                    }
                                    Node<V> pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        pred.next = new Node<V>(hash, key, value2, null);
                                        break block22;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                binCount = 2;
                                TreeNode<V> p = ((TreeBin)f).putTreeVal(hash, key, value2);
                                if (p != null) {
                                    oldVal = p.val;
                                    if (!onlyIfAbsent) {
                                        p.val = value2;
                                    }
                                }
                            } else if (f instanceof ReservationNode) {
                                throw new IllegalStateException("Recursive update");
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i2);
            }
            if (oldVal != null) {
                return oldVal;
            }
        }
        this.addCount(1L, binCount);
        return null;
    }

    @Override
    public V remove(int key) {
        return this.replaceNode(key, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V replaceNode(int key, V value2, Object cv) {
        int i2;
        Node<V> f;
        int n;
        int hash = ConcurrentIntObjectHashMap.spread(key);
        Node<V>[] tab = this.table;
        while (tab != null && (n = tab.length) != 0 && (f = ConcurrentIntObjectHashMap.tabAt(tab, i2 = n - 1 & hash)) != null) {
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                continue;
            }
            Object oldVal = null;
            boolean validated = false;
            Node<V> node2 = f;
            synchronized (node2) {
                if (ConcurrentIntObjectHashMap.tabAt(tab, i2) == f) {
                    if (fh >= 0) {
                        validated = true;
                        Node<V> e = f;
                        Node<V> pred = null;
                        do {
                            if (e.key == key) {
                                Object ev = e.val;
                                if (cv == null || cv == ev || ev != null && cv.equals(ev)) {
                                    oldVal = ev;
                                    if (value2 != null) {
                                        e.val = value2;
                                    } else if (pred != null) {
                                        pred.next = e.next;
                                    } else {
                                        ConcurrentIntObjectHashMap.setTabAt(tab, i2, e.next);
                                    }
                                }
                                break;
                            }
                            pred = e;
                        } while ((e = e.next) != null);
                    } else if (f instanceof TreeBin) {
                        TreeNode p;
                        validated = true;
                        TreeBin t = (TreeBin)f;
                        TreeNode r = t.root;
                        if (r != null && (p = r.findTreeNode(hash, key)) != null) {
                            Object pv = p.val;
                            if (cv == null || cv == pv || pv != null && cv.equals(pv)) {
                                oldVal = pv;
                                if (value2 != null) {
                                    p.val = value2;
                                } else if (t.removeTreeNode(p)) {
                                    ConcurrentIntObjectHashMap.setTabAt(tab, i2, this.untreeify(t.first));
                                }
                            }
                        }
                    } else if (f instanceof ReservationNode) {
                        throw new IllegalStateException("Recursive update");
                    }
                }
            }
            if (!validated) continue;
            if (oldVal == null) break;
            if (value2 == null) {
                this.addCount(-1L, -1);
            }
            return (V)oldVal;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        long delta = 0L;
        int i2 = 0;
        Node<V>[] tab = this.table;
        while (tab != null && i2 < tab.length) {
            Node<V> f = ConcurrentIntObjectHashMap.tabAt(tab, i2);
            if (f == null) {
                ++i2;
                continue;
            }
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                i2 = 0;
                continue;
            }
            Node<V> node2 = f;
            synchronized (node2) {
                if (ConcurrentIntObjectHashMap.tabAt(tab, i2) == f) {
                    Node<V> p;
                    Node<V> node3 = fh >= 0 ? f : (p = f instanceof TreeBin ? ((TreeBin)f).first : null);
                    while (p != null) {
                        --delta;
                        p = p.next;
                    }
                    ConcurrentIntObjectHashMap.setTabAt(tab, i2++, null);
                }
            }
        }
        if (delta != 0L) {
            this.addCount(delta, -1);
        }
    }

    @Override
    public Collection<V> values() {
        ValuesView<V> vs = this.values;
        if (vs != null) {
            return vs;
        }
        this.values = new ValuesView(this);
        return this.values;
    }

    @Override
    public Set<IntObjectMap.Entry<V>> entrySet() {
        EntrySetView<V> es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySetView(this));
    }

    public int hashCode() {
        int h = 0;
        Node<V>[] t = this.table;
        if (this.table != null) {
            Node<V> p;
            Traverser<V> it = new Traverser<V>(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                h += ConcurrentIntObjectHashMap.spread(p.key) ^ p.val.hashCode();
            }
        }
        return h;
    }

    public String toString() {
        Node<V>[] t = this.table;
        int f = this.table == null ? 0 : t.length;
        Traverser<V> it = new Traverser<V>(t, f, 0, f);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Node<V> p = it.advance();
        if (p != null) {
            while (true) {
                int k = p.key;
                Object v = p.val;
                sb.append(k);
                sb.append('=');
                sb.append((Object)(v == this ? "(this Map)" : v));
                p = it.advance();
                if (p == null) break;
                sb.append(',').append(' ');
            }
        }
        return sb.append('}').toString();
    }

    public boolean equals(Object o) {
        if (o != this) {
            Node<V> p;
            if (!(o instanceof ConcurrentIntObjectMap)) {
                return false;
            }
            ConcurrentIntObjectMap m = (ConcurrentIntObjectMap)o;
            Node<V>[] t = this.table;
            int f = this.table == null ? 0 : t.length;
            Traverser<V> it = new Traverser<V>(t, f, 0, f);
            while ((p = it.advance()) != null) {
                Object val = p.val;
                Object v = m.get(p.key);
                if (v != null && (v == val || v.equals(val))) continue;
                return false;
            }
            for (IntObjectMap.Entry e : m.entrySet()) {
                int mk = e.getKey();
                Object mv = e.getValue();
                V v = this.get(mk);
                if (v != null && (mv == v || mv.equals(v))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public V putIfAbsent(int key, @NotNull V value2) {
        if (value2 == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(2);
        }
        return this.putVal(key, value2, true);
    }

    @Override
    public boolean remove(int key, @NotNull Object value2) {
        if (value2 == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(3);
        }
        return this.replaceNode(key, null, value2) != null;
    }

    @Override
    public boolean replace(int key, @NotNull V oldValue, @NotNull V newValue) {
        if (oldValue == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(4);
        }
        if (newValue == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(5);
        }
        return this.replaceNode(key, newValue, oldValue) != null;
    }

    public V replace(int key, @NotNull V value2) {
        if (value2 == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(6);
        }
        return this.replaceNode(key, value2, null);
    }

    public V getOrDefault(int key, V defaultValue) {
        V v = this.get(key);
        return v == null ? defaultValue : v;
    }

    boolean removeValueIf(Predicate<? super V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        boolean removed = false;
        Node<V>[] t = this.table;
        if (this.table != null) {
            Node<V> p;
            Traverser<V> it = new Traverser<V>(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                int k = p.key;
                Object v = p.val;
                if (!function.test(v) || this.replaceNode(k, null, v) == null) continue;
                removed = true;
            }
        }
        return removed;
    }

    public boolean contains(Object value2) {
        return this.containsValue(value2);
    }

    @Override
    public int @NotNull [] keys() {
        Object[] entries2 = new EntrySetView(this).toArray();
        int[] result2 = new int[entries2.length];
        for (int i2 = 0; i2 < entries2.length; ++i2) {
            IntObjectMap.Entry entry2 = (IntObjectMap.Entry)entries2[i2];
            result2[i2] = entry2.getKey();
        }
        if (result2 == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(7);
        }
        return result2;
    }

    @Override
    @NotNull
    public Enumeration<V> elements() {
        Node<V>[] t = this.table;
        int f = this.table == null ? 0 : t.length;
        return new ValueIterator<V>(t, f, 0, f, this);
    }

    public long mappingCount() {
        long n = this.sumCount();
        return n < 0L ? 0L : n;
    }

    static final int resizeStamp(int n) {
        return Integer.numberOfLeadingZeros(n) | 0x8000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Node<V>[] initTable() {
        Node<V>[] tab;
        block6: {
            int sc;
            while (true) {
                tab = this.table;
                if (this.table != null && tab.length != 0) break block6;
                sc = this.sizeCtl;
                if (sc < 0) {
                    Thread.yield();
                    continue;
                }
                if (Unsafe.compareAndSwapInt(this, SIZECTL, sc, -1)) break;
            }
            try {
                tab = this.table;
                if (this.table == null || tab.length == 0) {
                    int n = sc > 0 ? sc : 16;
                    Node[] nt = new Node[n];
                    tab = nt;
                    this.table = nt;
                    sc = n - (n >>> 2);
                }
            }
            finally {
                this.sizeCtl = sc;
            }
        }
        return tab;
    }

    private final void addCount(long x, int check) {
        long s;
        long b;
        CounterCell[] as = this.counterCells;
        if (this.counterCells != null || !Unsafe.compareAndSwapLong(this, BASECOUNT, b = this.baseCount, s = b + x)) {
            long v;
            CounterCell a;
            int m;
            boolean uncontended = true;
            if (as == null || (m = as.length - 1) < 0 || (a = as[ThreadLocalRandom.getProbe() & m]) == null || !(uncontended = Unsafe.compareAndSwapLong(a, CELLVALUE, v = a.value, v + x))) {
                this.fullAddCount(x, uncontended);
                return;
            }
            if (check <= 1) {
                return;
            }
            s = this.sumCount();
        }
        if (check >= 0) {
            int sc;
            while (s >= (long)(sc = this.sizeCtl)) {
                int n;
                Node<V>[] tab = this.table;
                if (this.table == null || (n = tab.length) >= 0x40000000) break;
                int rs = ConcurrentIntObjectHashMap.resizeStamp(n) << 16;
                if (sc < 0) {
                    if (sc == rs + 65535 || sc == rs + 1) break;
                    Node<V>[] nt = this.nextTable;
                    if (this.nextTable == null || this.transferIndex <= 0) break;
                    if (Unsafe.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) {
                        this.transfer(tab, nt);
                    }
                } else if (Unsafe.compareAndSwapInt(this, SIZECTL, sc, rs + 2)) {
                    this.transfer(tab, null);
                }
                s = this.sumCount();
            }
        }
    }

    final Node<V>[] helpTransfer(Node<V>[] tab, Node<V> f) {
        if (tab != null && f instanceof ForwardingNode) {
            Node<V>[] nextTab = ((ForwardingNode)f).nextTable;
            if (((ForwardingNode)f).nextTable != null) {
                int sc;
                int rs = ConcurrentIntObjectHashMap.resizeStamp(tab.length) << 16;
                while (nextTab == this.nextTable && this.table == tab && (sc = this.sizeCtl) < 0 && sc != rs + 65535 && sc != rs + 1 && this.transferIndex > 0) {
                    if (!Unsafe.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) continue;
                    this.transfer(tab, nextTab);
                    break;
                }
                return nextTab;
            }
        }
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryPresize(int size) {
        int sc;
        int c;
        int n = c = size >= 0x20000000 ? 0x40000000 : ConcurrentIntObjectHashMap.tableSizeFor(size + (size >>> 1) + 1);
        while ((sc = this.sizeCtl) >= 0) {
            int rs;
            int n2;
            Node<V>[] tab = this.table;
            if (tab == null || (n2 = tab.length) == 0) {
                int n3 = n2 = sc > c ? sc : c;
                if (!Unsafe.compareAndSwapInt(this, SIZECTL, sc, -1)) continue;
                try {
                    if (this.table != tab) continue;
                    Node[] nt = new Node[n2];
                    this.table = nt;
                    sc = n2 - (n2 >>> 2);
                    continue;
                }
                finally {
                    this.sizeCtl = sc;
                    continue;
                }
            }
            if (c <= sc || n2 >= 0x40000000) break;
            if (tab != this.table || !Unsafe.compareAndSwapInt(this, SIZECTL, sc, ((rs = ConcurrentIntObjectHashMap.resizeStamp(n2)) << 16) + 2)) continue;
            this.transfer(tab, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void transfer(Node<V>[] tab, Node<V>[] nextTab) {
        int n = tab.length;
        int stride = NCPU > 1 ? (n >>> 3) / NCPU : n;
        if (stride < 16) {
            stride = 16;
        }
        if (nextTab == null) {
            try {
                Node[] nt = new Node[n << 1];
                nextTab = nt;
            }
            catch (Throwable ex) {
                this.sizeCtl = Integer.MAX_VALUE;
                return;
            }
            this.nextTable = nextTab;
            this.transferIndex = n;
        }
        int nextn = nextTab.length;
        ForwardingNode<V> fwd = new ForwardingNode<V>(nextTab);
        boolean advance = true;
        boolean finishing = false;
        int i2 = 0;
        int bound = 0;
        while (true) {
            if (advance) {
                if (--i2 >= bound || finishing) {
                    advance = false;
                    continue;
                }
                int nextIndex = this.transferIndex;
                if (nextIndex <= 0) {
                    i2 = -1;
                    advance = false;
                    continue;
                }
                int nextBound = nextIndex > stride ? nextIndex - stride : 0;
                if (!Unsafe.compareAndSwapInt(this, TRANSFERINDEX, nextIndex, nextBound)) continue;
                bound = nextBound;
                i2 = nextIndex - 1;
                advance = false;
                continue;
            }
            if (i2 < 0 || i2 >= n || i2 + n >= nextn) {
                if (finishing) {
                    this.nextTable = null;
                    this.table = nextTab;
                    this.sizeCtl = (n << 1) - (n >>> 1);
                    return;
                }
                int sc = this.sizeCtl;
                if (!Unsafe.compareAndSwapInt(this, SIZECTL, sc, sc - 1)) continue;
                if (sc - 2 != ConcurrentIntObjectHashMap.resizeStamp(n) << 16) {
                    return;
                }
                advance = true;
                finishing = true;
                i2 = n;
                continue;
            }
            TreeBin f = ConcurrentIntObjectHashMap.tabAt(tab, i2);
            if (f == null) {
                advance = ConcurrentIntObjectHashMap.casTabAt(tab, i2, fwd);
                continue;
            }
            int fh = f.hash;
            if (fh == -1) {
                advance = true;
                continue;
            }
            TreeBin treeBin = f;
            synchronized (treeBin) {
                if (ConcurrentIntObjectHashMap.tabAt(tab, i2) == f) {
                    Node hn;
                    if (fh >= 0) {
                        Node ln;
                        int runBit = fh & n;
                        TreeBin lastRun = f;
                        Node p = f.next;
                        while (p != null) {
                            int b = p.hash & n;
                            if (b != runBit) {
                                runBit = b;
                                lastRun = p;
                            }
                            p = p.next;
                        }
                        if (runBit == 0) {
                            ln = lastRun;
                            hn = null;
                        } else {
                            hn = lastRun;
                            ln = null;
                        }
                        p = f;
                        while (p != lastRun) {
                            int ph = p.hash;
                            int pk = p.key;
                            Object pv = p.val;
                            if ((ph & n) == 0) {
                                ln = new Node(ph, pk, pv, ln);
                            } else {
                                hn = new Node(ph, pk, pv, hn);
                            }
                            p = p.next;
                        }
                        ConcurrentIntObjectHashMap.setTabAt(nextTab, i2, ln);
                        ConcurrentIntObjectHashMap.setTabAt(nextTab, i2 + n, hn);
                        ConcurrentIntObjectHashMap.setTabAt(tab, i2, fwd);
                        advance = true;
                    } else if (f instanceof TreeBin) {
                        TreeBin ln;
                        TreeBin t = f;
                        TreeNode lo = null;
                        TreeNode loTail = null;
                        TreeNode hi = null;
                        TreeNode hiTail = null;
                        int lc = 0;
                        int hc = 0;
                        Node e = t.first;
                        while (e != null) {
                            int h = e.hash;
                            TreeNode p = new TreeNode(h, e.key, e.val, null, null);
                            if ((h & n) == 0) {
                                p.prev = loTail;
                                if (p.prev == null) {
                                    lo = p;
                                } else {
                                    loTail.next = p;
                                }
                                loTail = p;
                                ++lc;
                            } else {
                                p.prev = hiTail;
                                if (p.prev == null) {
                                    hi = p;
                                } else {
                                    hiTail.next = p;
                                }
                                hiTail = p;
                                ++hc;
                            }
                            e = e.next;
                        }
                        TreeBin treeBin2 = lc <= 6 ? this.untreeify(lo) : (ln = hc != 0 ? new TreeBin(lo) : t);
                        hn = hc <= 6 ? this.untreeify(hi) : (lc != 0 ? new TreeBin(hi) : t);
                        ConcurrentIntObjectHashMap.setTabAt(nextTab, i2, ln);
                        ConcurrentIntObjectHashMap.setTabAt(nextTab, i2 + n, hn);
                        ConcurrentIntObjectHashMap.setTabAt(tab, i2, fwd);
                        advance = true;
                    } else if (f instanceof ReservationNode) {
                        throw new IllegalStateException("Recursive update");
                    }
                }
            }
        }
    }

    final long sumCount() {
        CounterCell[] cs = this.counterCells;
        long sum = this.baseCount;
        if (cs != null) {
            for (CounterCell c : cs) {
                if (c == null) continue;
                sum += c.value;
            }
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void fullAddCount(long x, boolean wasUncontended) {
        int h = ThreadLocalRandom.getProbe();
        if (h == 0) {
            ThreadLocalRandom.localInit();
            h = ThreadLocalRandom.getProbe();
            wasUncontended = true;
        }
        boolean collide = false;
        while (true) {
            long v;
            int n;
            CounterCell[] cs = this.counterCells;
            if (this.counterCells != null && (n = cs.length) > 0) {
                CounterCell c = cs[n - 1 & h];
                if (c == null) {
                    if (this.cellsBusy == 0) {
                        CounterCell r = new CounterCell(x);
                        if (this.cellsBusy == 0 && Unsafe.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                            boolean created = false;
                            try {
                                int j;
                                int m;
                                CounterCell[] rs = this.counterCells;
                                if (this.counterCells != null && (m = rs.length) > 0 && rs[j = m - 1 & h] == null) {
                                    rs[j] = r;
                                    created = true;
                                }
                            }
                            finally {
                                this.cellsBusy = 0;
                            }
                            if (!created) continue;
                            return;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v = c.value;
                    if (Unsafe.compareAndSwapLong(c, CELLVALUE, v, v + x)) return;
                    if (this.counterCells != cs || n >= NCPU) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.cellsBusy == 0 && Unsafe.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                        try {
                            if (this.counterCells == cs) {
                                this.counterCells = Arrays.copyOf(cs, n << 1);
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h = ThreadLocalRandom.advanceProbe(h);
                continue;
            }
            if (this.cellsBusy == 0 && this.counterCells == cs && Unsafe.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                boolean init = false;
                try {
                    if (this.counterCells == cs) {
                        CounterCell[] rs = new CounterCell[2];
                        rs[h & 1] = new CounterCell(x);
                        this.counterCells = rs;
                        init = true;
                    }
                }
                finally {
                    this.cellsBusy = 0;
                }
                if (!init) continue;
                return;
            }
            v = this.baseCount;
            if (Unsafe.compareAndSwapLong(this, BASECOUNT, v, v + x)) return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void treeifyBin(Node<V>[] tab, int index) {
        if (tab != null) {
            int n = tab.length;
            if (n < 64) {
                this.tryPresize(n << 1);
            } else {
                Node<V> b = ConcurrentIntObjectHashMap.tabAt(tab, index);
                if (b != null && b.hash >= 0) {
                    Node<V> node2 = b;
                    synchronized (node2) {
                        if (ConcurrentIntObjectHashMap.tabAt(tab, index) == b) {
                            TreeNode hd = null;
                            TreeNode tl = null;
                            Node<V> e = b;
                            while (e != null) {
                                TreeNode p = new TreeNode(e.hash, e.key, e.val, null, null);
                                p.prev = tl;
                                if (p.prev == null) {
                                    hd = p;
                                } else {
                                    tl.next = p;
                                }
                                tl = p;
                                e = e.next;
                            }
                            ConcurrentIntObjectHashMap.setTabAt(tab, index, new TreeBin(hd));
                        }
                    }
                }
            }
        }
    }

    Node<V> untreeify(Node<V> b) {
        Node hd = null;
        Node tl = null;
        Node<V> q = b;
        while (q != null) {
            Node p = new Node(q.hash, q.key, q.val, null);
            if (tl == null) {
                hd = p;
            } else {
                tl.next = p;
            }
            tl = p;
            q = q.next;
        }
        return hd;
    }

    @NotNull
    public Iterable<IntObjectMap.Entry<V>> entries() {
        return new EntrySetView(this);
    }

    private static boolean isEqual(int key1, int key2) {
        return key1 == key2;
    }

    @Override
    @NotNull
    public V cacheOrGet(int key, @NotNull V defaultValue) {
        V v;
        if (defaultValue == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(8);
        }
        if ((v = this.get(key)) != null) {
            V v2 = v;
            if (v2 == null) {
                ConcurrentIntObjectHashMap.$$$reportNull$$$0(9);
            }
            return v2;
        }
        V prev = this.putIfAbsent(key, defaultValue);
        V v3 = prev == null ? defaultValue : prev;
        if (v3 == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(10);
        }
        return v3;
    }

    static {
        try {
            Class<ConcurrentIntObjectHashMap> k = ConcurrentIntObjectHashMap.class;
            SIZECTL = Unsafe.objectFieldOffset(k.getDeclaredField("sizeCtl"));
            TRANSFERINDEX = Unsafe.objectFieldOffset(k.getDeclaredField("transferIndex"));
            BASECOUNT = Unsafe.objectFieldOffset(k.getDeclaredField("baseCount"));
            CELLSBUSY = Unsafe.objectFieldOffset(k.getDeclaredField("cellsBusy"));
            CELLVALUE = Unsafe.objectFieldOffset(CounterCell.class.getDeclaredField("value"));
            ABASE = Unsafe.arrayBaseOffset(Node[].class);
            int scale = Unsafe.arrayIndexScale(Node[].class);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
        Class<LockSupport> ensureLoaded = LockSupport.class;
        Class<ReservationNode> clazz = ReservationNode.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentIntObjectHashMap";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentIntObjectHashMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "keys";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheOrGet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "containsValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cacheOrGet";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class Node<V>
    implements IntObjectMap.Entry<V> {
        final int hash;
        final int key;
        volatile V val;
        volatile Node<V> next;

        Node(int hash, int key, V val, Node<V> next) {
            this.hash = hash;
            this.key = key;
            this.val = val;
            this.next = next;
        }

        @Override
        public final int getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.val;
        }

        public final int hashCode() {
            return ConcurrentIntObjectHashMap.spread(this.key) ^ this.val.hashCode();
        }

        public final String toString() {
            return this.key + "=" + this.val;
        }

        public final boolean equals(Object o) {
            V u;
            if (!(o instanceof IntObjectMap.Entry)) {
                return false;
            }
            IntObjectMap.Entry e = (IntObjectMap.Entry)o;
            if (e.getKey() != this.key) {
                return false;
            }
            Object v = e.getValue();
            return v == (u = this.val) || v.equals(u);
        }

        Node<V> find(int h, int k) {
            Node<V> e = this;
            do {
                if (e.key != k) continue;
                return e;
            } while ((e = e.next) != null);
            return null;
        }
    }

    static class Traverser<V> {
        Node<V>[] tab;
        Node<V> next;
        TableStack<V> stack;
        TableStack<V> spare;
        int index;
        int baseIndex;
        int baseLimit;
        final int baseSize;

        Traverser(Node<V>[] tab, int size, int index, int limit) {
            this.tab = tab;
            this.baseSize = size;
            this.baseIndex = this.index = index;
            this.baseLimit = limit;
            this.next = null;
        }

        final Node<V> advance() {
            Node<V> e = this.next;
            if (e != null) {
                e = e.next;
            }
            while (true) {
                int i2;
                int n;
                Node<V>[] t;
                block10: {
                    block9: {
                        if (e != null) {
                            this.next = e;
                            return this.next;
                        }
                        if (this.baseIndex >= this.baseLimit) break block9;
                        t = this.tab;
                        if (this.tab != null && (n = t.length) > (i2 = this.index) && i2 >= 0) break block10;
                    }
                    this.next = null;
                    return null;
                }
                e = ConcurrentIntObjectHashMap.tabAt(t, i2);
                if (e != null && e.hash < 0) {
                    if (e instanceof ForwardingNode) {
                        this.tab = ((ForwardingNode)e).nextTable;
                        e = null;
                        this.pushState(t, i2, n);
                        continue;
                    }
                    e = e instanceof TreeBin ? ((TreeBin)e).first : null;
                }
                if (this.stack != null) {
                    this.recoverState(n);
                    continue;
                }
                this.index = i2 + this.baseSize;
                if (this.index < n) continue;
                this.index = ++this.baseIndex;
            }
        }

        private void pushState(Node<V>[] t, int i2, int n) {
            TableStack<V> s = this.spare;
            if (s != null) {
                this.spare = s.next;
            } else {
                s = new TableStack();
            }
            s.tab = t;
            s.length = n;
            s.index = i2;
            s.next = this.stack;
            this.stack = s;
        }

        private void recoverState(int n) {
            int len;
            TableStack<V> s;
            while ((s = this.stack) != null && (this.index += (len = s.length)) >= n) {
                n = len;
                this.index = s.index;
                this.tab = s.tab;
                s.tab = null;
                TableStack next = s.next;
                s.next = this.spare;
                this.stack = next;
                this.spare = s;
            }
            if (s == null && (this.index += this.baseSize) >= n) {
                this.index = ++this.baseIndex;
            }
        }
    }

    static final class TreeBin<V>
    extends Node<V> {
        TreeNode<V> root;
        volatile TreeNode<V> first;
        volatile Thread waiter;
        volatile int lockState;
        static final int WRITER = 1;
        static final int WAITER = 2;
        static final int READER = 4;
        private static final long LOCKSTATE;

        TreeBin(TreeNode<V> b) {
            super(-2, 0, null, null);
            this.first = b;
            TreeNode r = null;
            TreeNode x = b;
            while (x != null) {
                TreeNode next = (TreeNode)x.next;
                x.right = null;
                x.left = null;
                if (r == null) {
                    x.parent = null;
                    x.red = false;
                    r = x;
                } else {
                    TreeNode xp;
                    int dir2;
                    int h = x.hash;
                    TreeNode p = r;
                    do {
                        int ph;
                        dir2 = (ph = p.hash) > h ? -1 : (ph < h ? 1 : 0);
                        xp = p;
                    } while ((p = dir2 <= 0 ? p.left : p.right) != null);
                    x.parent = xp;
                    if (dir2 <= 0) {
                        xp.left = x;
                    } else {
                        xp.right = x;
                    }
                    r = TreeBin.balanceInsertion(r, x);
                }
                x = next;
            }
            this.root = r;
            assert (TreeBin.checkInvariants(this.root));
        }

        private final void lockRoot() {
            if (!Unsafe.compareAndSwapInt(this, LOCKSTATE, 0, 1)) {
                this.contendedLock();
            }
        }

        private final void unlockRoot() {
            this.lockState = 0;
        }

        private final void contendedLock() {
            boolean waiting = false;
            while (true) {
                int s;
                if (((s = this.lockState) & 0xFFFFFFFD) == 0) {
                    if (!Unsafe.compareAndSwapInt(this, LOCKSTATE, s, 1)) continue;
                    if (waiting) {
                        this.waiter = null;
                    }
                    return;
                }
                if ((s & 2) == 0) {
                    if (!Unsafe.compareAndSwapInt(this, LOCKSTATE, s, s | 2)) continue;
                    waiting = true;
                    this.waiter = Thread.currentThread();
                    continue;
                }
                if (!waiting) continue;
                LockSupport.park(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Node<V> find(int h, int k) {
            Node e = this.first;
            while (e != null) {
                TreeNode<V> p;
                int s = this.lockState;
                if ((s & 3) != 0) {
                    if (e.key == k) {
                        return e;
                    }
                    e = e.next;
                    continue;
                }
                if (!Unsafe.compareAndSwapInt(this, LOCKSTATE, s, s + 4)) continue;
                try {
                    TreeNode<V> r = this.root;
                    p = r == null ? null : r.findTreeNode(h, k);
                }
                finally {
                    Thread w;
                    if (TreeBin.getAndAddInt(this, LOCKSTATE, -4) == 6 && (w = this.waiter) != null) {
                        LockSupport.unpark(w);
                    }
                }
                return p;
            }
            return null;
        }

        private static int getAndAddInt(Object object, long offset, int v) {
            try {
                return Unsafe.getAndAddInt(object, offset, v);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TreeNode<V> putTreeVal(int h, int k, V v) {
            block18: {
                TreeNode<V> xp;
                int dir2;
                boolean searched = false;
                TreeNode<V> p = this.root;
                do {
                    if (p == null) {
                        this.root = new TreeNode<V>(h, k, v, null, null);
                        this.first = this.root;
                        break block18;
                    }
                    int ph = p.hash;
                    if (ph > h) {
                        dir2 = -1;
                    } else if (ph < h) {
                        dir2 = 1;
                    } else {
                        if (p.key == k) {
                            return p;
                        }
                        if (!searched) {
                            TreeNode q;
                            searched = true;
                            TreeNode ch = p.left;
                            if (ch != null && (q = ch.findTreeNode(h, k)) != null || (ch = p.right) != null && (q = ch.findTreeNode(h, k)) != null) {
                                return q;
                            }
                        }
                        dir2 = 0;
                    }
                    xp = p;
                } while ((p = dir2 <= 0 ? p.left : p.right) != null);
                TreeNode<V> f = this.first;
                TreeNode<V> x = new TreeNode<V>(h, k, v, f, xp);
                this.first = x;
                if (f != null) {
                    f.prev = x;
                }
                if (dir2 <= 0) {
                    xp.left = x;
                } else {
                    xp.right = x;
                }
                if (!xp.red) {
                    x.red = true;
                } else {
                    this.lockRoot();
                    try {
                        this.root = TreeBin.balanceInsertion(this.root, x);
                    }
                    finally {
                        this.unlockRoot();
                    }
                }
            }
            assert (TreeBin.checkInvariants(this.root));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean removeTreeNode(TreeNode<V> p) {
            TreeNode rl;
            TreeNode next = (TreeNode)p.next;
            TreeNode pred = p.prev;
            if (pred == null) {
                this.first = next;
            } else {
                pred.next = next;
            }
            if (next != null) {
                next.prev = pred;
            }
            if (this.first == null) {
                this.root = null;
                return true;
            }
            TreeNode<V> r = this.root;
            if (r == null || r.right == null || (rl = r.left) == null || rl.left == null) {
                return true;
            }
            this.lockRoot();
            try {
                TreeNode pp;
                TreeNode replacement;
                TreeNode pl = p.left;
                TreeNode pr = p.right;
                if (pl != null && pr != null) {
                    TreeNode sl;
                    TreeNode s = pr;
                    while ((sl = s.left) != null) {
                        s = sl;
                    }
                    boolean c = s.red;
                    s.red = p.red;
                    p.red = c;
                    TreeNode sr = s.right;
                    TreeNode pp2 = p.parent;
                    if (s == pr) {
                        p.parent = s;
                        s.right = p;
                    } else {
                        TreeNode sp = s.parent;
                        p.parent = sp;
                        if (p.parent != null) {
                            if (s == sp.left) {
                                sp.left = p;
                            } else {
                                sp.right = p;
                            }
                        }
                        if ((s.right = pr) != null) {
                            pr.parent = s;
                        }
                    }
                    p.left = null;
                    p.right = sr;
                    if (p.right != null) {
                        sr.parent = p;
                    }
                    if ((s.left = pl) != null) {
                        pl.parent = s;
                    }
                    if ((s.parent = pp2) == null) {
                        r = s;
                    } else if (p == pp2.left) {
                        pp2.left = s;
                    } else {
                        pp2.right = s;
                    }
                    replacement = sr != null ? sr : p;
                } else {
                    replacement = pl != null ? pl : (pr != null ? pr : p);
                }
                if (replacement != p) {
                    replacement.parent = p.parent;
                    pp = replacement.parent;
                    if (pp == null) {
                        r = replacement;
                    } else if (p == pp.left) {
                        pp.left = replacement;
                    } else {
                        pp.right = replacement;
                    }
                    p.parent = null;
                    p.right = null;
                    p.left = null;
                }
                TreeNode<V> treeNode = this.root = p.red ? r : TreeBin.balanceDeletion(r, replacement);
                if (p == replacement && (pp = p.parent) != null) {
                    if (p == pp.left) {
                        pp.left = null;
                    } else if (p == pp.right) {
                        pp.right = null;
                    }
                    p.parent = null;
                }
            }
            finally {
                this.unlockRoot();
            }
            assert (TreeBin.checkInvariants(this.root));
            return false;
        }

        static <V> TreeNode<V> rotateLeft(TreeNode<V> root2, TreeNode<V> p) {
            TreeNode r;
            if (p != null && (r = p.right) != null) {
                p.right = r.left;
                TreeNode rl = p.right;
                if (p.right != null) {
                    rl.parent = p;
                }
                TreeNode pp = r.parent = p.parent;
                if (r.parent == null) {
                    root2 = r;
                    r.red = false;
                } else if (pp.left == p) {
                    pp.left = r;
                } else {
                    pp.right = r;
                }
                r.left = p;
                p.parent = r;
            }
            return root2;
        }

        static <V> TreeNode<V> rotateRight(TreeNode<V> root2, TreeNode<V> p) {
            TreeNode l;
            if (p != null && (l = p.left) != null) {
                p.left = l.right;
                TreeNode lr = p.left;
                if (p.left != null) {
                    lr.parent = p;
                }
                TreeNode pp = l.parent = p.parent;
                if (l.parent == null) {
                    root2 = l;
                    l.red = false;
                } else if (pp.right == p) {
                    pp.right = l;
                } else {
                    pp.left = l;
                }
                l.right = p;
                p.parent = l;
            }
            return root2;
        }

        static <V> TreeNode<V> balanceInsertion(TreeNode<V> root2, TreeNode<V> x) {
            x.red = true;
            while (true) {
                TreeNode xpp;
                TreeNode xp;
                if ((xp = x.parent) == null) {
                    x.red = false;
                    return x;
                }
                if (!xp.red || (xpp = xp.parent) == null) {
                    return root2;
                }
                TreeNode xppl = xpp.left;
                if (xp == xppl) {
                    TreeNode xppr = xpp.right;
                    if (xppr != null && xppr.red) {
                        xppr.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x = xpp;
                        continue;
                    }
                    if (x == xp.right) {
                        x = xp;
                        root2 = TreeBin.rotateLeft(root2, x);
                        xp = x.parent;
                        TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    root2 = TreeBin.rotateRight(root2, xpp);
                    continue;
                }
                if (xppl != null && xppl.red) {
                    xppl.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x = xpp;
                    continue;
                }
                if (x == xp.left) {
                    x = xp;
                    root2 = TreeBin.rotateRight(root2, x);
                    xp = x.parent;
                    TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                root2 = TreeBin.rotateLeft(root2, xpp);
            }
        }

        static <V> TreeNode<V> balanceDeletion(TreeNode<V> root2, TreeNode<V> x) {
            while (x != null && x != root2) {
                TreeNode sr;
                TreeNode sl;
                TreeNode xp = x.parent;
                if (xp == null) {
                    x.red = false;
                    return x;
                }
                if (x.red) {
                    x.red = false;
                    return root2;
                }
                TreeNode xpl = xp.left;
                if (xpl == x) {
                    TreeNode xpr = xp.right;
                    if (xpr != null && xpr.red) {
                        xpr.red = false;
                        xp.red = true;
                        root2 = TreeBin.rotateLeft(root2, xp);
                        xp = x.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr == null) {
                        x = xp;
                        continue;
                    }
                    sl = xpr.left;
                    sr = xpr.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        xpr.red = true;
                        x = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        if (sl != null) {
                            sl.red = false;
                        }
                        xpr.red = true;
                        root2 = TreeBin.rotateRight(root2, xpr);
                        xp = x.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr != null) {
                        xpr.red = xp == null ? false : xp.red;
                        sr = xpr.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        xp.red = false;
                        root2 = TreeBin.rotateLeft(root2, xp);
                    }
                    x = root2;
                    continue;
                }
                if (xpl != null && xpl.red) {
                    xpl.red = false;
                    xp.red = true;
                    root2 = TreeBin.rotateRight(root2, xp);
                    xp = x.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl == null) {
                    x = xp;
                    continue;
                }
                sl = xpl.left;
                sr = xpl.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    xpl.red = true;
                    x = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    if (sr != null) {
                        sr.red = false;
                    }
                    xpl.red = true;
                    root2 = TreeBin.rotateLeft(root2, xpl);
                    xp = x.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl != null) {
                    xpl.red = xp == null ? false : xp.red;
                    sl = xpl.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    xp.red = false;
                    root2 = TreeBin.rotateRight(root2, xp);
                }
                x = root2;
            }
            return root2;
        }

        static <V> boolean checkInvariants(TreeNode<V> t) {
            TreeNode tp = t.parent;
            TreeNode tl = t.left;
            TreeNode tr = t.right;
            TreeNode tb = t.prev;
            TreeNode tn = (TreeNode)t.next;
            if (tb != null && tb.next != t) {
                return false;
            }
            if (tn != null && tn.prev != t) {
                return false;
            }
            if (tp != null && t != tp.left && t != tp.right) {
                return false;
            }
            if (tl != null && (tl.parent != t || tl.hash > t.hash)) {
                return false;
            }
            if (tr != null && (tr.parent != t || tr.hash < t.hash)) {
                return false;
            }
            if (t.red && tl != null && tl.red && tr != null && tr.red) {
                return false;
            }
            if (tl != null && !TreeBin.checkInvariants(tl)) {
                return false;
            }
            return tr == null || TreeBin.checkInvariants(tr);
        }

        static {
            try {
                Class<TreeBin> k = TreeBin.class;
                Field field = k.getDeclaredField("lockState");
                LOCKSTATE = Unsafe.objectFieldOffset(field);
            }
            catch (Throwable t) {
                throw new Error(t);
            }
        }
    }

    static final class TreeNode<V>
    extends Node<V> {
        TreeNode<V> parent;
        TreeNode<V> left;
        TreeNode<V> right;
        TreeNode<V> prev;
        boolean red;

        TreeNode(int hash, int key, V val, Node<V> next, TreeNode<V> parent) {
            super(hash, key, val, next);
            this.parent = parent;
        }

        @Override
        Node<V> find(int h, int k) {
            return this.findTreeNode(h, k);
        }

        final TreeNode<V> findTreeNode(int h, int k) {
            TreeNode<V> p = this;
            do {
                TreeNode<V> pl = p.left;
                TreeNode<V> pr = p.right;
                int ph = p.hash;
                if (ph > h) {
                    p = pl;
                    continue;
                }
                if (ph < h) {
                    p = pr;
                    continue;
                }
                if (p.key == k) {
                    return p;
                }
                if (pl == null) {
                    p = pr;
                    continue;
                }
                if (pr == null) {
                    p = pl;
                    continue;
                }
                TreeNode<V> q = pr.findTreeNode(h, k);
                if (q != null) {
                    return q;
                }
                p = pl;
            } while (p != null);
            return null;
        }
    }

    static final class ReservationNode<V>
    extends Node<V> {
        ReservationNode() {
            super(-3, 0, null, null);
        }

        Node<V> find(int h, Object k) {
            return null;
        }
    }

    static final class ValuesView<V>
    extends CollectionView<V, V>
    implements Collection<V> {
        ValuesView(ConcurrentIntObjectHashMap<V> map2) {
            super(map2);
        }

        @Override
        public final boolean contains(Object o) {
            return this.map.containsValue(o);
        }

        @Override
        public final boolean remove(Object o) {
            if (o != null) {
                Iterator<V> it = this.iterator();
                while (it.hasNext()) {
                    if (!o.equals(it.next())) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public final Iterator<V> iterator() {
            ConcurrentIntObjectHashMap m = this.map;
            Node<V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new ValueIterator(t, f, 0, f, m);
        }

        @Override
        public final boolean add(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            boolean modified = false;
            Iterator<V> it = this.iterator();
            while (it.hasNext()) {
                if (!c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean removeIf(Predicate<? super V> filter2) {
            return this.map.removeValueIf(filter2);
        }

        @Override
        public Spliterator<V> spliterator() {
            ConcurrentIntObjectHashMap m = this.map;
            long n = m.sumCount();
            Node<V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new ValueSpliterator(t, f, 0, f, n < 0L ? 0L : n);
        }

        @Override
        public void forEach(Consumer<? super V> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node<V>[] t = this.map.table;
            if (this.map.table != null) {
                Node p;
                Traverser it = new Traverser(t, t.length, 0, t.length);
                while ((p = it.advance()) != null) {
                    action2.accept(p.val);
                }
            }
        }
    }

    static final class EntrySetView<V>
    extends CollectionView<V, IntObjectMap.Entry<V>>
    implements Set<IntObjectMap.Entry<V>> {
        EntrySetView(ConcurrentIntObjectHashMap<V> map2) {
            super(map2);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof IntObjectMap.Entry)) {
                return false;
            }
            IntObjectMap.Entry e = (IntObjectMap.Entry)o;
            Object r = this.map.get(e.getKey());
            if (r == null) {
                return false;
            }
            Object v = e.getValue();
            return v == r || v.equals(r);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof IntObjectMap.Entry)) {
                return false;
            }
            IntObjectMap.Entry e = (IntObjectMap.Entry)o;
            Object v = e.getValue();
            return this.map.remove(e.getKey(), v);
        }

        @Override
        @NotNull
        public Iterator<IntObjectMap.Entry<V>> iterator() {
            ConcurrentIntObjectHashMap m = this.map;
            Node<V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new EntryIterator(t, f, 0, f, m);
        }

        @Override
        public boolean add(IntObjectMap.Entry<V> e) {
            return this.map.putVal(e.getKey(), e.getValue(), false) == null;
        }

        @Override
        public boolean addAll(Collection<? extends IntObjectMap.Entry<V>> c) {
            boolean added = false;
            for (IntObjectMap.Entry<V> e : c) {
                if (!this.add(e)) continue;
                added = true;
            }
            return added;
        }

        @Override
        public int hashCode() {
            int h = 0;
            Node<V>[] t = this.map.table;
            if (this.map.table != null) {
                Node p;
                Traverser it = new Traverser(t, t.length, 0, t.length);
                while ((p = it.advance()) != null) {
                    h += p.hashCode();
                }
            }
            return h;
        }

        @Override
        public final boolean equals(Object o) {
            Set c;
            return o instanceof Set && ((c = (Set)o) == this || this.containsAll(c) && c.containsAll(this));
        }

        @Override
        public Spliterator<IntObjectMap.Entry<V>> spliterator() {
            ConcurrentIntObjectHashMap m = this.map;
            long n = m.sumCount();
            Node<V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new EntrySpliterator(t, f, 0, f, n < 0L ? 0L : n, m);
        }

        @Override
        public void forEach(Consumer<? super IntObjectMap.Entry<V>> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node<V>[] t = this.map.table;
            if (this.map.table != null) {
                Node p;
                Traverser it = new Traverser(t, t.length, 0, t.length);
                while ((p = it.advance()) != null) {
                    action2.accept(new SimpleEntry(p.key, p.val));
                }
            }
        }
    }

    static final class ValueIterator<V>
    extends BaseIterator<V>
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator(Node<V>[] tab, int size, int index, int limit, ConcurrentIntObjectHashMap<V> map2) {
            super(tab, size, index, limit, map2);
        }

        @Override
        public final V next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            Object v = p.val;
            this.lastReturned = p;
            this.advance();
            return v;
        }

        @Override
        public final V nextElement() {
            return this.next();
        }
    }

    static final class CounterCell {
        volatile long p0;
        volatile long p1;
        volatile long p2;
        volatile long p3;
        volatile long p4;
        volatile long p5;
        volatile long p6;
        volatile long value;
        volatile long q0;
        volatile long q1;
        volatile long q2;
        volatile long q3;
        volatile long q4;
        volatile long q5;
        volatile long q6;

        CounterCell(long x) {
            this.value = x;
        }
    }

    static final class ForwardingNode<V>
    extends Node<V> {
        final Node<V>[] nextTable;

        ForwardingNode(Node<V>[] tab) {
            super(-1, 0, null, null);
            this.nextTable = tab;
        }

        @Override
        Node<V> find(int h, int k) {
            Node<V>[] tab = this.nextTable;
            block0: while (true) {
                Node<V> e;
                int n;
                if (tab == null || (n = tab.length) == 0 || (e = ConcurrentIntObjectHashMap.tabAt(tab, n - 1 & h)) == null) {
                    return null;
                }
                do {
                    if (e.key == k) {
                        return e;
                    }
                    if (e.hash >= 0) continue;
                    if (e instanceof ForwardingNode) {
                        tab = ((ForwardingNode)e).nextTable;
                        continue block0;
                    }
                    return e.find(h, k);
                } while ((e = e.next) != null);
                break;
            }
            return null;
        }
    }

    private static class SimpleEntry<V>
    implements IntObjectMap.Entry<V> {
        private final int key;
        private final V value;

        private SimpleEntry(int key, @NotNull V value2) {
            if (value2 == null) {
                SimpleEntry.$$$reportNull$$$0(0);
            }
            this.key = key;
            this.value = value2;
        }

        @Override
        public int getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public V getValue() {
            V v = this.value;
            if (v == null) {
                SimpleEntry.$$$reportNull$$$0(1);
            }
            return v;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentIntObjectHashMap$SimpleEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentIntObjectHashMap$SimpleEntry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static abstract class CollectionView<V, E>
    implements Collection<E> {
        final ConcurrentIntObjectHashMap<V> map;
        private static final String OOME_MSG = "Required array size too large";

        CollectionView(ConcurrentIntObjectHashMap<V> map2) {
            this.map = map2;
        }

        public ConcurrentIntObjectHashMap<V> getMap() {
            return this.map;
        }

        @Override
        public final void clear() {
            this.map.clear();
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public abstract Iterator<E> iterator();

        @Override
        public abstract boolean contains(Object var1);

        @Override
        public abstract boolean remove(Object var1);

        @Override
        public final Object[] toArray() {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(OOME_MSG);
            }
            int n = (int)sz;
            Object[] r = new Object[n];
            int i2 = 0;
            for (E e : this) {
                if (i2 == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(OOME_MSG);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i2++] = e;
            }
            return i2 == n ? r : Arrays.copyOf(r, i2);
        }

        @Override
        public final <T> T[] toArray(T[] a) {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(OOME_MSG);
            }
            int m = (int)sz;
            T[] r = a.length >= m ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), m);
            int n = r.length;
            int i2 = 0;
            for (E e : this) {
                if (i2 == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(OOME_MSG);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i2++] = e;
            }
            if (a == r && i2 < n) {
                r[i2] = null;
                return r;
            }
            return i2 == n ? r : Arrays.copyOf(r, i2);
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Iterator<E> it = this.iterator();
            if (it.hasNext()) {
                while (true) {
                    E e;
                    sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
                    if (!it.hasNext()) break;
                    sb.append(',').append(' ');
                }
            }
            return sb.append(']').toString();
        }

        @Override
        public final boolean containsAll(Collection<?> c) {
            if (c != this) {
                for (Object e : c) {
                    if (e != null && this.contains(e)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            boolean modified = false;
            Node<V>[] t = this.map.table;
            if (this.map.table == null) {
                return false;
            }
            if (c instanceof Set && c.size() > t.length) {
                Iterator<E> it = this.iterator();
                while (it.hasNext()) {
                    if (!c.contains(it.next())) continue;
                    it.remove();
                    modified = true;
                }
            } else {
                for (Object e : c) {
                    modified |= this.remove(e);
                }
            }
            return modified;
        }

        @Override
        public final boolean retainAll(Collection<?> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            boolean modified = false;
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                if (c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }
    }

    static final class EntrySpliterator<V>
    extends Traverser<V>
    implements Spliterator<IntObjectMap.Entry<V>> {
        final ConcurrentIntObjectHashMap<V> map;
        long est;

        EntrySpliterator(Node<V>[] tab, int size, int index, int limit, long est, ConcurrentIntObjectHashMap<V> map2) {
            super(tab, size, index, limit);
            this.map = map2;
            this.est = est;
        }

        @Override
        public EntrySpliterator<V> trySplit() {
            EntrySpliterator<V> entrySpliterator;
            int i2 = this.baseIndex;
            int f = this.baseLimit;
            int h = i2 + f >>> 1;
            if (h <= i2) {
                entrySpliterator = null;
            } else {
                this.baseLimit = h;
                EntrySpliterator<V> entrySpliterator2 = new EntrySpliterator<V>(this.tab, this.baseSize, this.baseLimit, f, this.est >>>= 1, this.map);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super IntObjectMap.Entry<V>> action2) {
            Node p;
            if (action2 == null) {
                throw new NullPointerException();
            }
            while ((p = this.advance()) != null) {
                action2.accept(new SimpleEntry(p.key, p.val));
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super IntObjectMap.Entry<V>> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node p = this.advance();
            if (p == null) {
                return false;
            }
            action2.accept(new SimpleEntry(p.key, p.val));
            return true;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return 4353;
        }
    }

    static final class ValueSpliterator<V>
    extends Traverser<V>
    implements Spliterator<V> {
        long est;

        ValueSpliterator(Node<V>[] tab, int size, int index, int limit, long est) {
            super(tab, size, index, limit);
            this.est = est;
        }

        @Override
        public ValueSpliterator<V> trySplit() {
            ValueSpliterator<V> valueSpliterator;
            int i2 = this.baseIndex;
            int f = this.baseLimit;
            int h = i2 + f >>> 1;
            if (h <= i2) {
                valueSpliterator = null;
            } else {
                this.baseLimit = h;
                ValueSpliterator<V> valueSpliterator2 = new ValueSpliterator<V>(this.tab, this.baseSize, this.baseLimit, f, this.est >>>= 1);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action2) {
            Node p;
            if (action2 == null) {
                throw new NullPointerException();
            }
            while ((p = this.advance()) != null) {
                action2.accept(p.val);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node p = this.advance();
            if (p == null) {
                return false;
            }
            action2.accept(p.val);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return 4352;
        }
    }

    static final class EntryIterator<V>
    extends BaseIterator<V>
    implements Iterator<IntObjectMap.Entry<V>> {
        EntryIterator(Node<V>[] tab, int size, int index, int limit, ConcurrentIntObjectHashMap<V> map2) {
            super(tab, size, index, limit, map2);
        }

        @Override
        public final IntObjectMap.Entry<V> next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            int k = p.key;
            Object v = p.val;
            this.lastReturned = p;
            this.advance();
            return new SimpleEntry(k, v);
        }
    }

    static class BaseIterator<V>
    extends Traverser<V> {
        final ConcurrentIntObjectHashMap<V> map;
        Node<V> lastReturned;

        BaseIterator(Node<V>[] tab, int size, int index, int limit, ConcurrentIntObjectHashMap<V> map2) {
            super(tab, size, index, limit);
            this.map = map2;
            this.advance();
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        public final boolean hasMoreElements() {
            return this.next != null;
        }

        public final void remove() {
            Node<V> p = this.lastReturned;
            if (p == null) {
                throw new IllegalStateException();
            }
            this.lastReturned = null;
            this.map.replaceNode(p.key, null, null);
        }
    }

    static final class TableStack<V> {
        int length;
        int index;
        Node<V>[] tab;
        TableStack<V> next;

        TableStack() {
        }
    }

    static class Segment<V>
    extends ReentrantLock {
        final float loadFactor;

        Segment(float lf) {
            this.loadFactor = lf;
        }
    }
}

