/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.gradle.internal.analyzer.CompilationErrorException;
import org.jetbrains.kotlin.util.Logger;

@Metadata(k=1, mv={2, 0, 0}, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\r\u0010\fJ\u0017\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\fJ\u0017\u0010\u000f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\fJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\bH\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0014\u001a\u00020\u0013*\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/CompilerLoggerAdapter;", "Lorg/jetbrains/kotlin/gradle/internal/util/Logger;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "messageCollector", "", "treatWarningsAsErrors", "<init>", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Z)V", "", "message", "", "log", "(Ljava/lang/String;)V", "warning", "strongWarning", "error", "", "fatal", "(Ljava/lang/String;)Ljava/lang/Void;", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "orError", "(Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;)Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Z", "cli"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
final class CompilerLoggerAdapter
implements Logger {
    @NotNull
    private final MessageCollector messageCollector;
    private final boolean treatWarningsAsErrors;

    public CompilerLoggerAdapter(@NotNull MessageCollector messageCollector, boolean treatWarningsAsErrors) {
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        this.messageCollector = messageCollector;
        this.treatWarningsAsErrors = treatWarningsAsErrors;
    }

    public void log(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.messageCollector.report(CompilerMessageSeverity.LOGGING, message2, null);
    }

    public void warning(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.messageCollector.report(this.orError(CompilerMessageSeverity.WARNING), message2, null);
    }

    public void strongWarning(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.messageCollector.report(this.orError(CompilerMessageSeverity.STRONG_WARNING), message2, null);
    }

    public void error(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.messageCollector.report(CompilerMessageSeverity.ERROR, message2, null);
    }

    @Deprecated(message="Invocation of fatal() may cause severe side effects such as throwing an exception or even terminating the current JVM process (check various implementations of this function for details). The code that uses Logger.fatal() sometimes expects a particular kind of side effect. This is an undesirable design. And it's definitely not a responsibility of Logger to influence the execution flow of the program.", replaceWith=@ReplaceWith(expression="error(message)", imports={}))
    @NotNull
    public Void fatal(@NotNull String message2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.error(message2);
            MessageCollector messageCollector = this.messageCollector;
            GroupingMessageCollector groupingMessageCollector = messageCollector instanceof GroupingMessageCollector ? (GroupingMessageCollector)messageCollector : null;
            if (groupingMessageCollector == null) break block0;
            groupingMessageCollector.flush();
        }
        throw new CompilationErrorException();
    }

    private final CompilerMessageSeverity orError(CompilerMessageSeverity $this$orError) {
        return this.treatWarningsAsErrors ? CompilerMessageSeverity.ERROR : $this$orError;
    }
}

